#include "clkgen.h"
#include "systemc.h"

int sc_main(int argc, char **argv)
{
  /* Declare/define signal channels */
  sc_core::sc_signal<bool> slctsig;
  sc_core::sc_signal<bool> clk_1;
  sc_core::sc_signal<bool> clk_2;
  sc_core::sc_signal<bool> clk_3;

  /* Declare/define master clock, clock generator and trace file */
  sc_core::sc_clock clk("clk", 10.0, sc_core::SC_NS, 0.5);
  clkgen clk_gen("clk_gen");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_clkgen");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  bool slctval;

  /* Connect module ports and channels and trace file */
  clk_gen.clk_in(clk);
  clk_gen.slct(slctsig);
  clk_gen.clk1(clk_1);
  clk_gen.clk2(clk_2);
  clk_gen.clk3(clk_3);

  sc_core::sc_trace(fp, clk, "clk_in");
  sc_core::sc_trace(fp, slctsig, "slct");
  sc_core::sc_trace(fp, clk_1, "clk1");
  sc_core::sc_trace(fp, clk_2, "clk2");
  sc_core::sc_trace(fp, clk_3, "clk3");

  /* Set scan mode select and run simulation for pre-defined time period */
  slctval = false;
  slctsig.write(slctval);
  sc_core::sc_start(50.0, sc_core::SC_NS);

   /* Reset scan mode select and run simulation for pre-defined time period */
  slctval = true;
  slctsig.write(slctval);
  sc_core::sc_start(50.0, sc_core::SC_NS);

  /* Reset scan mode select and run simulation for pre-defined time period */
  slctval = false;
  slctsig.write(slctval);
  sc_core::sc_start(50.0, sc_core::SC_NS);

  /* Reset scan mode select and run simulation for pre-defined time period */
  slctval = true;
  slctsig.write(slctval);
  sc_core::sc_start(50.0, sc_core::SC_NS);

  /* Reset scan mode select and run simulation for pre-defined time period */
  slctval = false;
  slctsig.write(slctval);
  sc_core::sc_start(50.0, sc_core::SC_NS);

  /* Stop simulation and close trace file */
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}
