#include "delsfde.h"
#include "sysctrace.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<double> sig0;
  sc_core::sc_signal<double> sig1;
  sc_core::sc_signal<double> sig2; 

  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  desrc de_src("de_src");
  delsfde de_lsfde("de_lsfde");
  ssctracetrdbl trace_tr_dbl("tr_delsfde"); 
  
  de_src.clk(clk);
  de_src.outp(sig0);
  
  de_lsfde.clk(clk);
  de_lsfde.inp(sig0);
  
  de_lsfde.out0(sig1);
  de_lsfde.out1(sig2);
  
 /* trace_tr_dbl.clk(clk); */
  trace_tr_dbl.din0(sig0);
  trace_tr_dbl.din1(sig1);
  trace_tr_dbl.din2(sig2);
 
  sc_core::sc_start(500.0, sc_core::SC_NS);
  sc_core::sc_stop();
   
  return 0;
}

