#include "commonsrcs.h"
#include "elnbndpass.h"
#include "gendatatrace.h"

#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  
  sca_tdf::sca_signal<double> sigin;
  sca_tdf::sca_signal<double> sigout;
  
  double amplitude;
  double frequency;

  if(argc < 3)
  {
    std::cout<<"insufficient parameters ..."<<std::endl;
    std::cout<<"usage : ./sim <amplitude> <frequency>"<<std::endl;
    exit(0);
  }

  amplitude = strtod(argv[1], NULL);
  frequency = strtod(argv[2], NULL);

  elnbndpass eln_bp("eln_bp");
  sinsrc sin_src("sin_src");
  tracedoublecombo trdbl("tr_bndpass");

  sin_src.sigout(sigin);
  sin_src.amplitude = amplitude;
  sin_src.frequency = frequency;

  eln_bp.inp(sigin);
  eln_bp.outp(sigout);

  trdbl.in1(sigin);
  trdbl.in2(sigout);

  sc_start(100.0, sc_core::SC_MS);
  return 0;
}


