#include "explicitevent.h"

/* TEST BENCH FOR SYSTEMC 7.1 */

int sc_main(int argc, char **argv)
{
  /* Declare/define channel */
  sc_core::sc_signal<double> data;
  /* Declare/define clock for implicit event synchronization */
  sc_core::sc_clock clk("clock", 2.0, sc_core::SC_NS, 0.5);
  /* Declare/define components */
  stimulus stim("stim");
  master mas_ter("mas_ter");
  slave slave_0("slave_0");
  slave slave_1("slave_1");

  /* Connect modules and channels */
  stim.clk(clk);
  mas_ter.clk(clk);
  mas_ter.dout(data);
  slave_0.clk(clk);
  slave_0.din(data);
  slave_1.clk(clk);
  slave_1.din(data);
  /* Run simulation for pre-defined time interval and then stop */
  sc_core::sc_start(250.0, sc_core::SC_NS);
  sc_core::sc_stop();
  return 0;
}

