#include "commonsrcs.h"
#include "filtfordbtweln.h"
#include "gendatatrace.h"
#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  sca_tdf::sca_signal<double> sig0;
  sca_tdf::sca_signal<double> sig1;
  double amplitude;
  double frequency;
  
  if(argc < 3)
  {
    std::cout<<"missing input ..."<<std::endl;
    std::cout<<"usage ./sim <amplitude> <frequency>"<<std::endl;    
    exit(0);
  }

  amplitude = strtod(argv[1], NULL);
  frequency = strtod(argv[2], NULL);
  
  sinsrc sin_src("sin_src");
  filtfordbtweln filt("filt");
  tracedoublecombo trdbl("tr_filt_5_ord_btw"); 

  sin_src.sigout(sig0);
  sin_src.amplitude = amplitude;
  sin_src.frequency = frequency;

  filt.inp(sig0);
  filt.outp(sig1);

  trdbl.in1(sig0);
  trdbl.in2(sig1);
  
  sc_start(200.0, sc_core::SC_MS);
  return 0;
}
 
  

