#include "flipflop.h"
#include "syscsrcs.h"
#include "systemc.h"

/* TEST BENCH SYSTEMC EXAMPLE 6.1 */

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;

  sc_core::sc_clock clk("clk", 10.0, sc_core::SC_NS, 0.5);
  
  inv inv_0("inv_0");
  jkff jk_ff_0("master");
  jkff jk_ff_1("slave");

  syncdatasrc s_data_0("s_data_0");
  syncdatasrc s_data_1("s_data_1");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_jkff");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  s_data_0.clk(clk);
  s_data_0.dout(sig0);

  s_data_1.clk(clk);
  s_data_1.dout(sig1);

  inv_0.din(clk);
  inv_0.dout(sig4);
  
  jk_ff_0.clk(clk);
  jk_ff_0.din0(sig0);
  jk_ff_0.din1(sig1);
  jk_ff_0.dout0(sig2);
  jk_ff_0.dout1(sig3);

  jk_ff_1.clk(sig4);
  jk_ff_1.din0(sig2);
  jk_ff_1.din1(sig3);
  jk_ff_1.dout0(sig5);
  jk_ff_1.dout1(sig6);  

  sc_core::sc_trace(fp, clk, "clk");
  sc_core::sc_trace(fp, sig0, "j");
  sc_core::sc_trace(fp, sig1, "k");
  sc_core::sc_trace(fp, sig2, "qm");
  sc_core::sc_trace(fp, sig3, "qbm");
  sc_core::sc_trace(fp, sig5, "qs");
  sc_core::sc_trace(fp, sig6, "qbs");
 
  sc_core::sc_start(1000.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

