#include "fsm.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> fsm_input_sig;
  sc_core::sc_signal<unsigned int> fsm_out;

  sc_core::sc_clock clk("clk", 10.0, sc_core::SC_US, 0.5);
  
  fsm_input_src fsm_inp("fsm_input_src");
  fsm fs_m("fsm");

  fsm_inp.clk(clk);
  fsm_inp.fsm_input_out(fsm_input_sig);
    
  fs_m.fsm_in(fsm_input_sig);
  fs_m.curr_state_out(fsm_out);

  sc_core::sc_start(1500.0, sc_core::SC_US);
  sc_core::sc_stop();
  return 0;
}

