#include "n2_com_256x132async_dp_cust_array.h"
#include "memmisc.h"
#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal< sc_dt::sc_bv<8> > rd_addr_sig;
  sc_core::sc_signal< sc_dt::sc_bv<8> > wr_addr_sig;
  sc_core::sc_signal<bool> rd_en_array_sig;
  sc_core::sc_signal<bool> wr_en_array_sig;
  sc_core::sc_signal<bool> wclk;
  sc_core::sc_signal< sc_dt::sc_bv<132> > din_array_sig;
  sc_core::sc_signal< sc_dt::sc_bv<132> > dout_array_sig;
  bool rd_en_array_value;
  bool wr_en_array_value;
  sc_dt::sc_bv<8> rd_array_addr;
  sc_dt::sc_bv<8> wr_array_addr;
  sc_dt::sc_bv<132> din_array_value;
  sc_dt::sc_bv<132> dout_array_value;
 
  sc_core::sc_clock rclk("read_clk", 2.0, sc_core::SC_NS, 0.5);
  inv_clk in_v_clk("inv_clk");
  n2_com_256x132async_dp_cust_array mem_array("mem_array");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_mem_array");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  in_v_clk.clk(rclk);
  in_v_clk.inv_clk_out(wclk);

  mem_array.rd_clk(rclk);
  mem_array.wr_clk(wclk);
  mem_array.rd_en_array(rd_en_array_sig);
  mem_array.wr_en_array(wr_en_array_sig);
  mem_array.rd_addr_array(rd_addr_sig);
  mem_array.wr_addr_array(wr_addr_sig);
  mem_array.din_array(din_array_sig);
  mem_array.dout_array(dout_array_sig);
  sc_core::sc_trace(fp, rclk, "rd_clk");
  sc_core::sc_trace(fp, wclk, "wr_clk");
  sc_core::sc_trace(fp, rd_en_array_sig, "rd_en");
  sc_core::sc_trace(fp, wr_en_array_sig, "wr_en");
  sc_core::sc_trace(fp, rd_addr_sig, "rd_addr");
  sc_core::sc_trace(fp, wr_addr_sig, "wr_addr");
  sc_core::sc_trace(fp, din_array_sig, "din");
  sc_core::sc_trace(fp, dout_array_sig, "dout");


  rd_en_array_value = false;
  wr_en_array_value = false;
  rd_array_addr="00000000";
  wr_array_addr="00000000";
  din_array_value="0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";       dout_array_value="0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);
  dout_array_sig.write(dout_array_value);

  sc_core::sc_start(5.0, sc_core::SC_NS);

  rd_en_array_value = false;
  wr_en_array_value = true;
  rd_array_addr="00000000";
  wr_array_addr="00000000"; din_array_value="01001001001101010011010100101101011001110010101010101011100101010101101110010101010101001011100111001001111001001011011100110001010110";                
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);

  rd_en_array_value = false;
  wr_en_array_value = true;
  rd_array_addr="00000000";
  wr_array_addr="00000001"; din_array_value="01001001111101010011010110101101011001110010101010101011100101010101101111010101010101001011110111001011111001001011011100110001010110"; 
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);

  rd_en_array_value = false;
  wr_en_array_value = true;
  rd_array_addr="00000000";
  wr_array_addr="00000010"; din_array_value="01001101001000010011010100101101010001110010101010101011100101010101101110010101010101001011100111001001001001001011011100110001010110"; 
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);

  sc_core::sc_start(5.0, sc_core::SC_NS);

  rd_en_array_value = false;
  wr_en_array_value = true;
  rd_array_addr="00000000";
  wr_array_addr="00000011"; din_array_value="01001101011011010011010101101101010101110010101010101011110101010101101110010101010101001011100111001001001001001011011100110001010110";
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);
  sc_core::sc_start(5.0, sc_core::SC_NS);

  rd_en_array_value = true;
  wr_en_array_value = false;
  rd_array_addr="00000010";
  wr_array_addr="00000000"; din_array_value="01001101001000010011010100101101010001110010101010101011100101010101101110010101010101001011100111001001001001001011011100110001010110";
  rd_en_array_sig.write(rd_en_array_value);
  wr_en_array_sig.write(wr_en_array_value);
  rd_addr_sig.write(rd_array_addr);
  wr_addr_sig.write(wr_array_addr);
  din_array_sig.write(din_array_value);
  

  sc_core::sc_start(5.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}
