#include "n2_flop_bank_cust.h"
#include "syscsrcs.h"

int sc_main(int argc, char **argv)
{
  /* Declare/define channels/signals */		
  sc_core::sc_signal<bool> scan_in_sig;
  sc_core::sc_signal<bool> tcu_scan_en_sig;
  sc_core::sc_signal<bool> tcu_pce_ov_sig;
  sc_core::sc_signal<bool> local_stop_sig;
  sc_core::sc_signal< sc_dt::sc_bv<16> > data_in_sig;
  sc_core::sc_signal<bool> scan_out_sig;
  sc_core::sc_signal< sc_dt::sc_bv<16> > data_out_sig;
  sc_core::sc_signal<bool> clkA;
  sc_core::sc_signal<bool> clkB;
  sc_core::sc_signal<bool> clkC;

  /* Declare/define three clocks */
  /* First the master clock */
  sc_core::sc_clock masterclock("masterclock", 
                                 2.0, 
                                 sc_core::SC_NS, 0.5);
  /*
  sc_core::sc_clock clockA("clockA", 4.0, sc_core::SC_PS, 0.5);
  sc_core::sc_clock clockB("clockB", 8.0, sc_core::SC_PS, 0.5);
  */
  /* Then three derived clocks */
  clkdiv_2_4_8 clk_div_2_4_8("clk_div_2_4_8");
  
  /* Declare/define intermediate variables */
  sc_dt::sc_bv<16> data_in_value;
  sc_dt::sc_bv<16> data_out_value;
  bool scan_in_value;
  bool tcu_scan_en_value;
  bool tcu_pce_ov_value;
  bool local_stop_value;
  
/* Declare/define flip-flop bank and trace file object */
  n2_flop_bank_cust n2_flop_bank_cust_OBJ("n2_flop_bank_cust_OBJ");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_flop_bank");
  fp->set_time_unit(500.0, sc_core::SC_PS);
 
  /* Connect master and derived clocks */
  clk_div_2_4_8.clk(masterclock);
  clk_div_2_4_8.clk2(clkA);
  clk_div_2_4_8.clk4(clkB);
  clk_div_2_4_8.clk8(clkC); 
  
  /* Connect flip-flop bank ports and channels/signals */
  /*
  n2_flop_bank_cust_OBJ.l2clk(masterclock);
  n2_flop_bank_cust_OBJ.tcu_aclk(clockA);
  n2_flop_bank_cust_OBJ.tcu_bclk(clockB);
  */
  n2_flop_bank_cust_OBJ.l2clk(clkA);
  n2_flop_bank_cust_OBJ.tcu_aclk(clkB);
  n2_flop_bank_cust_OBJ.tcu_bclk(clkC);

  n2_flop_bank_cust_OBJ.scan_in(scan_in_sig);
  n2_flop_bank_cust_OBJ.tcu_scan_en(tcu_scan_en_sig);
  n2_flop_bank_cust_OBJ.tcu_pce_ov(tcu_pce_ov_sig);
  n2_flop_bank_cust_OBJ.local_stop(local_stop_sig);
  n2_flop_bank_cust_OBJ.data_in(data_in_sig);
  n2_flop_bank_cust_OBJ.scan_out(scan_out_sig);
  n2_flop_bank_cust_OBJ.data_out(data_out_sig);

  /* Connect data channels/signals with trace file */
  sc_core::sc_trace(fp, clkA, "clk");
  sc_core::sc_trace(fp, clkB, "aclk");
  sc_core::sc_trace(fp, clkC, "bclk");
  sc_core::sc_trace(fp, scan_in_sig, "scan_in");
  sc_core::sc_trace(fp, tcu_scan_en_sig, "scan_en");
  sc_core::sc_trace(fp, tcu_pce_ov_sig, "pce_ov");
  sc_core::sc_trace(fp, data_in_sig, "data_in");
  sc_core::sc_trace(fp, data_out_sig, "data_out");
  
/* Generate initial input data and write to channels */
  data_in_value = "0000000000000000";
  scan_in_value = false;
  tcu_scan_en_value = false;
  tcu_pce_ov_value = false;
  local_stop_value = true;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);
  std::cout<<"Start"<<std::endl;

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(25.0, sc_core::SC_NS);

  /* Change input data and write to channels */
  data_in_value = "0010101010011110";
  scan_in_value = true;
  tcu_scan_en_value = true;
  tcu_pce_ov_value = false;
  local_stop_value = false;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(500.0, sc_core::SC_PS);

  /* Change input data and write to channels */
  data_in_value = "0110101010011000";
  scan_in_value = true;
  tcu_scan_en_value = true;
  tcu_pce_ov_value = true;
  local_stop_value = false;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(25.0, sc_core::SC_NS);

  /* Change input data and write to channels */
  data_in_value = "1010101010000110";
  scan_in_value = true;
  tcu_scan_en_value = true;
  tcu_pce_ov_value = true;
  local_stop_value = true;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(25.0, sc_core::SC_NS);

  /* Change input data and write to channels */
  data_in_value = "0010101011111110";
  scan_in_value = true;
  tcu_scan_en_value = true;
  tcu_pce_ov_value = false;
  local_stop_value = true;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(25.0, sc_core::SC_NS);

  /* Change input data and write to channels */
  data_in_value = "0010101010011110";
  scan_in_value = true;
  tcu_scan_en_value = true;
  tcu_pce_ov_value = false;
  local_stop_value = false;
  data_in_sig.write(data_in_value);
  scan_in_sig.write(scan_in_value);
  tcu_scan_en_sig.write(tcu_scan_en_value);
  tcu_pce_ov_sig.write(tcu_pce_ov_value);
  local_stop_sig.write(local_stop_value);

  /* Run simulation for pre-defined time-interval */
  sc_core::sc_start(25.0, sc_core::SC_NS);

  /* Stop simulation and close trace file */
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);  
  return 0;
}

