#include "prn.h"

/* TEST BENCH FOR SYSTEMC EXAMPLE 8.1 */

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> prnout;
  
  sc_core::sc_clock prn_clk("prn_clk", 5.0, sc_core::SC_NS, 0.5);
  prn p_r_n("p_r_n");
  sc_core::sc_trace_file *fp =  
                       sc_core::sc_create_vcd_trace_file("tr_prn");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  p_r_n.clk(prn_clk);
  p_r_n.prnout(prnout);

  sc_core::sc_trace(fp, prn_clk, "prn_clk");
  sc_core::sc_trace(fp, prnout, "prn_out");
  
  sc_core::sc_start(5000.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

