#include "clkgen.h"
#include "systemc.h"
#include "syscsrcs.h"

int sc_main(int argc, char **argv)
{
  
  sc_core::sc_signal<bool> clk_1;
  sc_core::sc_signal<bool> clk_2;
  sc_core::sc_signal<bool> clk_3;
  sc_core::sc_signal<bool> rcnout0;
  sc_core::sc_signal<bool> rcnout1;
  sc_core::sc_signal<bool> syndatasig;
  sc_core::sc_signal<bool> slctsig;

  sc_core::sc_clock clk("clk", 10.0, sc_core::SC_NS, 0.5);
  clkgen clk_gen("clk_gen");
  reconDff rcnDff("rcnDff");
  syncdatasrc syndata("syndata");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_clkgen");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  bool slctval;

  clk_gen.clk_in(clk);
  clk_gen.slct(slctsig);
  clk_gen.clk1(clk_1);
  clk_gen.clk2(clk_2);
  clk_gen.clk3(clk_3);

  syndata.clk(clk);
  syndata.dout(syndatasig);

  rcnDff.clk1(clk_1);
  rcnDff.clk2(clk_2);
  rcnDff.clk3(clk_3);
  rcnDff.din(syndatasig);
  rcnDff.slct(slctsig);
  rcnDff.dout0(rcnout0);
  rcnDff.dout1(rcnout1);
  
  sc_core::sc_trace(fp, clk, "clk_in");
  sc_core::sc_trace(fp, syndatasig, "Dff_data_in");
  sc_core::sc_trace(fp, slctsig, "slct");
  sc_core::sc_trace(fp, clk_1, "clk1");
  sc_core::sc_trace(fp, clk_2, "clk2");
  sc_core::sc_trace(fp, clk_3, "clk3");
  sc_core::sc_trace(fp, rcnout0, "rcnDffout0");
  sc_core::sc_trace(fp, rcnout1, "rcnDffout1");

  slctval = false;
  slctsig.write(slctval);

  sc_core::sc_start(50.0, sc_core::SC_NS);

  slctval = true;
  slctsig.write(slctval);

  sc_core::sc_start(50.0, sc_core::SC_NS);

  slctval = false;
  slctsig.write(slctval);

  sc_core::sc_start(50.0, sc_core::SC_NS);

  slctval = true;
  slctsig.write(slctval);

  sc_core::sc_start(50.0, sc_core::SC_NS);

  slctval = false;
  slctsig.write(slctval);

  sc_core::sc_start(50.0, sc_core::SC_NS);

  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

