#include "siganal.h"
#include "systemc.h"


int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;
  sc_core::sc_signal<bool> sig9;
  sc_core::sc_signal<bool> sig10;
  sc_core::sc_signal<bool> sig11;
  sc_core::sc_signal<bool> sig12;
  sc_core::sc_signal<bool> sig13;
  sc_core::sc_signal<bool> sig14;
 
  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;

  siganal6x6 siganal("siganal");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_siganal");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  siganal.clk(clk);
  siganal.in0(sig0);
  siganal.in1(sig1);
  siganal.in2(sig2);
  siganal.in3(sig3);
  siganal.in4(sig4);
  siganal.in5(sig5);
  siganal.in6(sig6);

  siganal.out0(sig7);
  siganal.out1(sig8);
  siganal.out2(sig9);
  siganal.out3(sig10);
  siganal.out4(sig11);
  siganal.out5(sig12);
  siganal.out6(sig13);
  siganal.out7(sig14);

  sc_core::sc_trace(fp, clk, "clk");
  sc_core::sc_trace(fp, sig0, "d0");
  sc_core::sc_trace(fp, sig1, "d1");
  sc_core::sc_trace(fp, sig2, "d2");
  sc_core::sc_trace(fp, sig3, "d3");
  sc_core::sc_trace(fp, sig4, "d4");
  sc_core::sc_trace(fp, sig5, "d5");
  sc_core::sc_trace(fp, sig6, "d6");
  sc_core::sc_trace(fp, sig7, "o0");
  sc_core::sc_trace(fp, sig8, "o1");
  sc_core::sc_trace(fp, sig9,  "o2");
  sc_core::sc_trace(fp, sig10, "o3");
  sc_core::sc_trace(fp, sig11, "o4");
  sc_core::sc_trace(fp, sig12, "o5");
  sc_core::sc_trace(fp, sig13, "o6");
  sc_core::sc_trace(fp, sig14, "o7");
  
  b0 = true;
  b1 = false;
  b2 = true;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);
   
  b0 = true;
  b1 = true;
  b2 = true;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);

  b0 = false;
  b1 = true;
  b2 = false;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = true;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = false;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS); 

  b0 = true;
  b1 = false;
  b2 = true;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);

  b0 = false;
  b1 = false;
  b2 = true;
  b3 = true;
  b4 = true;
  b5 = false;
  b6 = false;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);

  b0 = false;
  b1 = false;
  b2 = false;
  b3 = false;
  b4 = true;
  b5 = true;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = true;
  b3 = true;
  b4 = true;
  b5 = false;
  b6 = true;

  sig0.write(b0);
  sig1.write(b1);
  sig2.write(b2);
  sig3.write(b3);
  sig4.write(b4);
  sig5.write(b5);
  sig6.write(b6);
      
  sc_core::sc_start(5.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  
  return 0;


}

