#include "sipo.h"
#include "syscsrcs.h"

/* TEST BENCH FOR SYSTEMC EXAMPLE 6.2 */

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> sigin;
  sc_core::sc_signal< sc_dt::sc_bv<64> > sigout;

  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  sipo64 sipo_64("sipo_64");
  syncdatasrc sync_d_src("sync_d_src");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_sipo");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  sync_d_src.clk(clk);
  sync_d_src.dout(sigin);

  sipo_64.clk(clk);
  sipo_64.in(sigin);
  sipo_64.out(sigout);
  sc_trace(fp, clk, "clock");
  sc_trace(fp, sigin, "serial_data");
  sc_trace(fp, sigout, "parallel_data");

  sc_core::sc_start(1000.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}
    
   
