#ifndef TEST_H
#define TEST_H

#include <systemc>

const unsigned int MAX = 4;

SC_MODULE(onecounter)
{
  sc_core::sc_in< sc_dt::sc_bv<8> > in;
  sc_core::sc_out< sc_dt::sc_bv<4> > out;

  sc_dt::sc_bv<8> inbits;
  sc_dt::sc_bv<4> outbits;
  unsigned int count;
  unsigned int i;

  void process_input()
  {
    while(1)
    {
      wait();
      inbits = in.read();
      count = 0;
      outbits = "0000";

      for(i = 0; i < 8; i++)
      {
        if(count == 4) break;
        if(inbits[i] == '1') count++;
      }

      if(count < 4)
      {
        for(i = 0; i < count; i++) outbits[MAX-1-i] = "1";
      }
      else
      {
        outbits = "1111";
      }
      out.write(outbits);
      std::cout<<"8 sort In : "<<inbits<<" Out : "<<outbits<<std::endl;
    }
    count = 0; 
  }

  SC_CTOR(onecounter) 
  { 
    SC_THREAD(process_input);
    sensitive << in; 
  }
  ~onecounter() { }
};

SC_MODULE(onehot)
{
  sc_core::sc_in< sc_dt::sc_bv<4> > in;
  sc_core::sc_out< sc_dt::sc_bv<5> > out; 

  sc_dt::sc_bv<4> input;
  sc_dt::sc_bv<5> output;
  
  unsigned int count;
  unsigned int i;

  void process_input()
  {
    count = 0;
    i = 0;
    input = "0000";
    while(1)
    {
      wait();
      count = 0;
      i = 0;
      input = in.read();
      for(; i < MAX; i++)
      {
        if(input[i] == '1') count++;
      }
    
      if(count == 0) output = "00000";
      else if(count == 1) output = "01000";
      else if(count == 2) output = "00100";
      else if(count == 3) output = "00010";
      else if(count == 4) output = "00001";
      out.write(output);
      std::cout<<"1 hot In : "<<input<<" Out : "<<output<<std::endl;
    } 
  }

  SC_CTOR(onehot) 
  { 
    SC_THREAD(process_input);
    sensitive << in;
  }
  ~onehot(){ }
};

SC_MODULE(inv)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;

  void inv_proc0()
  {
   while(1)
   {
    wait();
    out.write(!(in.read()));
   }
  }
 
  SC_CTOR(inv)
  {
    SC_THREAD(inv_proc0);
    sensitive << in;
  }
 
  ~inv() { }
};

SC_MODULE(dlatch)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<1> > din;
  sc_core::sc_out< sc_dt::sc_bv<1> > dout;
  
  void dlatch_proc0()
  {
    while(1)
    {
      wait();
      dout.write(din.read());
    }
  }

  SC_CTOR(dlatch)
  {
    SC_CTHREAD(dlatch_proc0, clk.pos());
  }
  ~dlatch(){ }
};

SC_MODULE(dlatch_2)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<1> > din;
  sc_core::sc_out< sc_dt::sc_bv<1> > dout;
  sc_core::sc_out< sc_dt::sc_bv<1> > dout_1;
  sc_dt::sc_bv<1> tmp;

  void dlatch_2_proc0()
  {
    while(1)
    {
      wait();
      tmp = din.read();
      dout.write(tmp);
      dout_1.write(tmp);
    }
  }

  SC_CTOR(dlatch_2)
  {
    SC_CTHREAD(dlatch_2_proc0, clk.pos());
  }
  ~dlatch_2(){ }
};


SC_MODULE(mux5)
{
  sc_core::sc_in< sc_dt::sc_bv<1> > in0;
  sc_core::sc_in< sc_dt::sc_bv<4> > in1;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_out< sc_dt::sc_bv<1> > out;
  sc_dt::sc_bv<5> tmp0;
  sc_dt::sc_bv<4> tmp_in1;
  sc_dt::sc_bv<1> tmp_in0;
  sc_dt::sc_bv<1> tmp_out;
  sc_dt::sc_bv<5> tmp_sel;
  sc_dt::sc_bv<5> tmp_out_5;

  void mux5_proc0()
  {
    while(1)
    {
      wait();
      tmp_in0 = in0.read();
      tmp_in1 = in1.read();
      tmp_sel = sel.read();
      tmp0.range(4,4) = tmp_in0.range(0,0);
      tmp0.range(3,0) = tmp_in1.range(3,0);
      tmp_out_5 = tmp_sel & tmp0;
      tmp_out = tmp_out_5.or_reduce();
      out.write(tmp_out);
    }
  }

  SC_CTOR(mux5)
  {
    SC_THREAD(mux5_proc0);
    sensitive << sel;
  }

  ~mux5(){ }
};

SC_MODULE(wakeup_mux)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<4> > din;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg; 

  sc_core::sc_signal< sc_dt::sc_bv<1> > sig0;
  sc_core::sc_signal< sc_dt::sc_bv<1> > sig1;
  sc_core::sc_signal< sc_dt::sc_bv<1> > sig2;
  sc_core::sc_signal<bool> sig3;

  inv in_v;
  dlatch_2 d_latch_0;
  dlatch d_latch_1;
  mux5 mux_5;

  SC_CTOR(wakeup_mux):in_v("in_v"), 
                      d_latch_0("d_latch_0"),
                      d_latch_1("d_latch_1"),
                      mux_5("mux_5")
  {
    in_v.in(clk);
    in_v.out(sig3);
    
    d_latch_0.clk(clk);
    d_latch_0.din(sig0);
    d_latch_0.dout(sig1);
    d_latch_0.dout_1(new_reg);
    
    d_latch_1.clk(sig3);
    d_latch_1.din(sig1);
    d_latch_1.dout(sig2);

    mux_5.in0(sig2);
    mux_5.in1(din);
    mux_5.sel(sel);
    mux_5.out(sig0);
  }

  ~wakeup_mux(){ }
};

SC_MODULE(andnorand64_1)
{
  sc_core::sc_in< sc_dt::sc_bv<1> > in0;
  sc_core::sc_in< sc_dt::sc_bv<1> > in1;
  sc_core::sc_in< sc_dt::sc_bv<1> > in2;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in3;
  sc_core::sc_in< sc_dt::sc_bv<1> > in4;
  sc_core::sc_in< sc_dt::sc_bv<1> > in5;
  sc_core::sc_in< sc_dt::sc_bv<1> > in6;
  sc_core::sc_in< sc_dt::sc_bv<1> > in7;
  sc_core::sc_in< sc_dt::sc_bv<1> > in8;
  sc_core::sc_in< sc_dt::sc_bv<1> > in9;
  sc_core::sc_in< sc_dt::sc_bv<1> > in10;
  sc_core::sc_in< sc_dt::sc_bv<1> > in11;
  sc_core::sc_in< sc_dt::sc_bv<1> > in12;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in13;
  sc_core::sc_in< sc_dt::sc_bv<1> > in14;
  sc_core::sc_in< sc_dt::sc_bv<1> > in15;
  sc_core::sc_in< sc_dt::sc_bv<1> > in16;
  sc_core::sc_in< sc_dt::sc_bv<1> > in17;
  sc_core::sc_in< sc_dt::sc_bv<1> > in18;
  sc_core::sc_in< sc_dt::sc_bv<1> > in19;
  sc_core::sc_in< sc_dt::sc_bv<1> > in20;
  sc_core::sc_in< sc_dt::sc_bv<1> > in21;
  sc_core::sc_in< sc_dt::sc_bv<1> > in22;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in23;
  sc_core::sc_in< sc_dt::sc_bv<1> > in24;
  sc_core::sc_in< sc_dt::sc_bv<1> > in25;
  sc_core::sc_in< sc_dt::sc_bv<1> > in26;
  sc_core::sc_in< sc_dt::sc_bv<1> > in27;
  sc_core::sc_in< sc_dt::sc_bv<1> > in28;
  sc_core::sc_in< sc_dt::sc_bv<1> > in29;
  sc_core::sc_in< sc_dt::sc_bv<1> > in30;
  sc_core::sc_in< sc_dt::sc_bv<1> > in31;
  sc_core::sc_in< sc_dt::sc_bv<1> > in32;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in33;
  sc_core::sc_in< sc_dt::sc_bv<1> > in34;
  sc_core::sc_in< sc_dt::sc_bv<1> > in35;
  sc_core::sc_in< sc_dt::sc_bv<1> > in36;
  sc_core::sc_in< sc_dt::sc_bv<1> > in37;
  sc_core::sc_in< sc_dt::sc_bv<1> > in38;
  sc_core::sc_in< sc_dt::sc_bv<1> > in39;
  sc_core::sc_in< sc_dt::sc_bv<1> > in40;
  sc_core::sc_in< sc_dt::sc_bv<1> > in41;
  sc_core::sc_in< sc_dt::sc_bv<1> > in42;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in43;
  sc_core::sc_in< sc_dt::sc_bv<1> > in44;
  sc_core::sc_in< sc_dt::sc_bv<1> > in45;
  sc_core::sc_in< sc_dt::sc_bv<1> > in46;
  sc_core::sc_in< sc_dt::sc_bv<1> > in47;
  sc_core::sc_in< sc_dt::sc_bv<1> > in48;
  sc_core::sc_in< sc_dt::sc_bv<1> > in49;
  sc_core::sc_in< sc_dt::sc_bv<1> > in50;
  sc_core::sc_in< sc_dt::sc_bv<1> > in51;
  sc_core::sc_in< sc_dt::sc_bv<1> > in52;  
  sc_core::sc_in< sc_dt::sc_bv<1> > in53;
  sc_core::sc_in< sc_dt::sc_bv<1> > in54;
  sc_core::sc_in< sc_dt::sc_bv<1> > in55;
  sc_core::sc_in< sc_dt::sc_bv<1> > in56;
  sc_core::sc_in< sc_dt::sc_bv<1> > in57;
  sc_core::sc_in< sc_dt::sc_bv<1> > in58;
  sc_core::sc_in< sc_dt::sc_bv<1> > in59;
  sc_core::sc_in< sc_dt::sc_bv<1> > in60;
  sc_core::sc_in< sc_dt::sc_bv<1> > in61;
  sc_core::sc_in< sc_dt::sc_bv<1> > in62;
  sc_core::sc_in< sc_dt::sc_bv<1> > in63;
  sc_core::sc_in< sc_dt::sc_bv<64> > in64;
  sc_core::sc_out< sc_dt::sc_bv<1> > andnorand64_1_out;

  sc_dt::sc_bv<64> tmp;
  sc_dt::sc_bv<64> tmp0;
  sc_dt::sc_bv<1> out;

  void andnorand64_1_proc0()
  {
    while(1)
    {
     wait();
     tmp.range(63,63) = in63.read().range(0,0);
     tmp.range(62,62) = in62.read().range(0,0);
     tmp.range(61,61) = in61.read().range(0,0);
     tmp.range(60,60) = in60.read().range(0,0);
     tmp.range(59,59) = in59.read().range(0,0);
     tmp.range(58,58) = in58.read().range(0,0);
     tmp.range(57,57) = in57.read().range(0,0);
     tmp.range(56,56) = in56.read().range(0,0);
     tmp.range(55,55) = in55.read().range(0,0);
     tmp.range(54,54) = in54.read().range(0,0);
     tmp.range(53,53) = in53.read().range(0,0);
     tmp.range(52,52) = in52.read().range(0,0);
     tmp.range(51,51) = in51.read().range(0,0);
     tmp.range(50,50) = in50.read().range(0,0);
     tmp.range(49,49) = in49.read().range(0,0);
     tmp.range(48,48) = in48.read().range(0,0);
     tmp.range(47,47) = in47.read().range(0,0);
     tmp.range(46,46) = in46.read().range(0,0);
     tmp.range(45,45) = in45.read().range(0,0);
     tmp.range(44,44) = in44.read().range(0,0);
     tmp.range(43,43) = in43.read().range(0,0);
     tmp.range(42,42) = in42.read().range(0,0);
     tmp.range(41,41) = in41.read().range(0,0);
     tmp.range(40,40) = in40.read().range(0,0);
     tmp.range(39,39) = in39.read().range(0,0);
     tmp.range(38,38) = in38.read().range(0,0);
     tmp.range(37,37) = in37.read().range(0,0);
     tmp.range(36,36) = in36.read().range(0,0);
     tmp.range(35,35) = in35.read().range(0,0);
     tmp.range(34,34) = in34.read().range(0,0);
     tmp.range(33,33) = in33.read().range(0,0);
     tmp.range(32,32) = in32.read().range(0,0);
     tmp.range(31,31) = in31.read().range(0,0);
     tmp.range(30,30) = in30.read().range(0,0);
     tmp.range(29,29) = in29.read().range(0,0);
     tmp.range(28,28) = in28.read().range(0,0);
     tmp.range(27,27) = in27.read().range(0,0);
     tmp.range(26,26) = in26.read().range(0,0);
     tmp.range(25,25) = in25.read().range(0,0);
     tmp.range(24,24) = in24.read().range(0,0);
     tmp.range(23,23) = in23.read().range(0,0);
     tmp.range(22,22) = in22.read().range(0,0);
     tmp.range(21,21) = in21.read().range(0,0);
     tmp.range(20,20) = in20.read().range(0,0);
     tmp.range(19,19) = in19.read().range(0,0);
     tmp.range(18,18) = in18.read().range(0,0);
     tmp.range(17,17) = in17.read().range(0,0);
     tmp.range(16,16) = in16.read().range(0,0);
     tmp.range(15,15) = in15.read().range(0,0);
     tmp.range(14,14) = in14.read().range(0,0);
     tmp.range(13,13) = in13.read().range(0,0);
     tmp.range(12,12) = in12.read().range(0,0);
     tmp.range(11,11) = in11.read().range(0,0);
     tmp.range(10,10) = in10.read().range(0,0);
     tmp.range(9,9) = in9.read().range(0,0);
     tmp.range(8,8) = in8.read().range(0,0);
     tmp.range(7,7) = in7.read().range(0,0);
     tmp.range(6,6) = in6.read().range(0,0);
     tmp.range(5,5) = in5.read().range(0,0);
     tmp.range(4,4) = in4.read().range(0,0);
     tmp.range(3,3) = in3.read().range(0,0);
     tmp.range(2,2) = in2.read().range(0,0);
     tmp.range(1,1) = in1.read().range(0,0);
     tmp.range(0,0) = in0.read().range(0,0);
     tmp0.range(63,0) = (tmp & in64.read()).range(63,0);
     out = tmp0.or_reduce();
     andnorand64_1_out.write(out);
    }
  }
     
  SC_CTOR(andnorand64_1)
  {
    SC_THREAD(andnorand64_1_proc0);
    sensitive << in0 << in1 << in2 << in3 << in4 << in5 << in6 << in7 << in8 << in9 << in10 << in11 << in12 << in13 << in14 << in15 << in16 << in17 << in18 << in19 << in20 << in21 << in22 << in23 << in24 << in25 << in26 << in27 << in28 << in29 << in30 << in31 << in32 << in33 << in34 << in35 << in36 << in37 << in38 << in39 << in40 << in41 << in42 << in43 << in44 << in45 << in46 << in47 << in48 << in49 << in50 << in51 << in52 << in53 << in54 << in55 << in56 << in57 << in58 << in59 << in60 << in61 << in62 << in63;
  }
  
  ~andnorand64_1(){}
};


SC_MODULE(register64bit)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg0_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg1_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg2_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg3_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg4_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg5_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg6_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg7_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg8_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg9_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg10_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg11_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg12_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg13_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg14_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg15_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg16_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg17_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg18_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg19_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg20_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg21_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg22_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg23_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg24_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg25_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg26_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg27_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg28_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg29_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg30_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg31_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg32_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg33_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg34_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg35_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg36_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg37_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg38_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg39_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg40_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg41_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg42_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg43_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg44_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg45_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg46_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg47_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg48_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg49_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg50_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg51_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg52_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg53_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg54_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg55_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg56_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg57_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg58_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg59_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg60_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg61_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg62_in;
  sc_core::sc_in< sc_dt::sc_bv<4> > reg63_in;

  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  /*
  sc_core::sc_in< sc_dt::sc_bv<5> > sel0;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel1;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel2;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel3;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel4;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel5;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel6;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel7;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel8;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel9;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel10;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel11;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel12;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel13;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel14;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel15;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel16;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel17;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel18;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel19;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel20;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel21;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel22;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel23;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel24;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel25;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel26;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel27;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel28;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel29;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel30;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel31;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel32;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel33;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel34;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel35;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel36;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel37;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel38;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel39;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel40;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel41;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel42;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel43;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel44;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel45;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel46;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel47;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel48;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel49;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel50;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel51;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel52;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel53;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel54;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel55;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel56;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel57;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel58;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel59;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel60;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel61;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel62;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel63;
  */

  sc_core::sc_in< sc_dt::sc_bv<64> > statusregbits;
  sc_core::sc_out< sc_dt::sc_bv<1> > rdy;

  sc_core::sc_signal< sc_dt::sc_bv<1> > reg0out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg1out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg2out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg3out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg4out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg5out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg6out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg7out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg8out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg9out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg10out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg11out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg12out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg13out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg14out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg15out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg16out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg17out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg18out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg19out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg20out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg21out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg22out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg23out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg24out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg25out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg26out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg27out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg28out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg29out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg30out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg31out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg32out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg33out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg34out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg35out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg36out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg37out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg38out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg39out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg40out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg41out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg42out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg43out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg44out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg45out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg46out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg47out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg48out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg49out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg50out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg51out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg52out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg53out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg54out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg55out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg56out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg57out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg58out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg59out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg60out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg61out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg62out;
  sc_core::sc_signal< sc_dt::sc_bv<1> > reg63out;

  wakeup_mux reg0;
  wakeup_mux reg1;
  wakeup_mux reg2;
  wakeup_mux reg3;
  wakeup_mux reg4;
  wakeup_mux reg5;
  wakeup_mux reg6;
  wakeup_mux reg7;
  wakeup_mux reg8;
  wakeup_mux reg9;
  wakeup_mux reg10;
  wakeup_mux reg11;
  wakeup_mux reg12;
  wakeup_mux reg13;
  wakeup_mux reg14;
  wakeup_mux reg15;
  wakeup_mux reg16;
  wakeup_mux reg17;
  wakeup_mux reg18;
  wakeup_mux reg19;
  wakeup_mux reg20;
  wakeup_mux reg21;
  wakeup_mux reg22;
  wakeup_mux reg23;
  wakeup_mux reg24;
  wakeup_mux reg25;
  wakeup_mux reg26;
  wakeup_mux reg27;
  wakeup_mux reg28;
  wakeup_mux reg29;
  wakeup_mux reg30;
  wakeup_mux reg31;
  wakeup_mux reg32;
  wakeup_mux reg33;
  wakeup_mux reg34;
  wakeup_mux reg35;
  wakeup_mux reg36;
  wakeup_mux reg37;
  wakeup_mux reg38;
  wakeup_mux reg39;
  wakeup_mux reg40;
  wakeup_mux reg41;
  wakeup_mux reg42;
  wakeup_mux reg43;
  wakeup_mux reg44;
  wakeup_mux reg45;
  wakeup_mux reg46;
  wakeup_mux reg47;
  wakeup_mux reg48;
  wakeup_mux reg49;
  wakeup_mux reg50;
  wakeup_mux reg51;
  wakeup_mux reg52;
  wakeup_mux reg53;
  wakeup_mux reg54;
  wakeup_mux reg55;
  wakeup_mux reg56;
  wakeup_mux reg57;
  wakeup_mux reg58;
  wakeup_mux reg59;
  wakeup_mux reg60;
  wakeup_mux reg61;
  wakeup_mux reg62;
  wakeup_mux reg63;
  andnorand64_1 and_or_and_64_1;  
  
  SC_CTOR(register64bit):reg0("reg0"),
                         reg1("reg1"),
                         reg2("reg2"),
                         reg3("reg3"),
                         reg4("reg4"),
                         reg5("reg5"),
                         reg6("reg6"),
                         reg7("reg7"),
                         reg8("reg8"),
                         reg9("reg9"),
                         reg10("reg10"),
                         reg11("reg11"),
                         reg12("reg12"),
                         reg13("reg13"),
                         reg14("reg14"),
                         reg15("reg15"),
                         reg16("reg16"),
                         reg17("reg17"),
                         reg18("reg18"),
                         reg19("reg19"),
                         reg20("reg20"),
                         reg21("reg21"),
                         reg22("reg22"),
                         reg23("reg23"),
                         reg24("reg24"),
                         reg25("reg25"),
                         reg26("reg26"),
                         reg27("reg27"),
                         reg28("reg28"),
                         reg29("reg29"),
                         reg30("reg30"),
                         reg31("reg31"),
                         reg32("reg32"),
                         reg33("reg33"),
                         reg34("reg34"),
                         reg35("reg35"),
                         reg36("reg36"),
                         reg37("reg37"),
                         reg38("reg38"),
                         reg39("reg39"),
                         reg40("reg40"),
                         reg41("reg41"),
                         reg42("reg42"),
                         reg43("reg43"),
                         reg44("reg44"),
                         reg45("reg45"),
                         reg46("reg46"),
                         reg47("reg47"),
                         reg48("reg48"),
                         reg49("reg49"),
                         reg50("reg50"),
                         reg51("reg51"),
                         reg52("reg52"),
                         reg53("reg53"),
                         reg54("reg54"),
                         reg55("reg55"),
                         reg56("reg56"),
                         reg57("reg57"),
                         reg58("reg58"),
                         reg59("reg59"),
                         reg60("reg60"),
                         reg61("reg61"),
                         reg62("reg62"),
                         reg63("reg63"),
                         and_or_and_64_1("and_or_and_64_1") 
    {
      reg0.clk(clk);
      reg0.din(reg0_in);
      reg0.sel(sel);
      reg0.new_reg(reg0out);
     
      reg1.clk(clk);
      reg1.din(reg1_in);
      reg1.sel(sel);
      reg1.new_reg(reg1out);
 
      reg2.clk(clk);
      reg2.din(reg2_in);
      reg2.sel(sel);
      reg2.new_reg(reg2out);

      reg3.clk(clk);
      reg3.din(reg3_in);
      reg3.sel(sel);
      reg3.new_reg(reg3out);

      reg4.clk(clk);
      reg4.din(reg4_in);
      reg4.sel(sel);
      reg4.new_reg(reg4out);

      reg5.clk(clk);
      reg5.din(reg5_in);
      reg5.sel(sel);
      reg5.new_reg(reg5out);

      reg6.clk(clk);
      reg6.din(reg6_in);
      reg6.sel(sel);
      reg6.new_reg(reg6out);

      reg7.clk(clk);
      reg7.din(reg7_in);
      reg7.sel(sel);
      reg7.new_reg(reg7out);

      reg8.clk(clk);
      reg8.din(reg8_in);
      reg8.sel(sel);
      reg8.new_reg(reg8out);

      reg9.clk(clk);
      reg9.din(reg9_in);
      reg9.sel(sel);
      reg9.new_reg(reg9out);

      reg10.clk(clk);
      reg10.din(reg10_in);
      reg10.sel(sel);
      reg10.new_reg(reg10out);

      reg11.clk(clk);
      reg11.din(reg11_in);
      reg11.sel(sel);
      reg11.new_reg(reg11out);

      reg12.clk(clk);
      reg12.din(reg12_in);
      reg12.sel(sel);
      reg12.new_reg(reg12out);

      reg13.clk(clk);
      reg13.din(reg13_in);
      reg13.sel(sel);
      reg13.new_reg(reg13out);

      reg14.clk(clk);
      reg14.din(reg14_in);
      reg14.sel(sel);
      reg14.new_reg(reg14out);

      reg15.clk(clk);
      reg15.din(reg15_in);
      reg15.sel(sel);
      reg15.new_reg(reg15out);

      reg16.clk(clk);
      reg16.din(reg16_in);
      reg16.sel(sel);
      reg16.new_reg(reg16out);

      reg17.clk(clk);
      reg17.din(reg17_in);
      reg17.sel(sel);
      reg17.new_reg(reg17out);

      reg18.clk(clk);
      reg18.din(reg18_in);
      reg18.sel(sel);
      reg18.new_reg(reg18out);

      reg19.clk(clk);
      reg19.din(reg19_in);
      reg19.sel(sel);
      reg19.new_reg(reg19out);

      reg20.clk(clk);
      reg20.din(reg20_in);
      reg20.sel(sel);
      reg20.new_reg(reg20out);

      reg21.clk(clk);
      reg21.din(reg21_in);
      reg21.sel(sel);
      reg21.new_reg(reg21out);

      reg22.clk(clk);
      reg22.din(reg22_in);
      reg22.sel(sel);
      reg22.new_reg(reg22out);

      reg23.clk(clk);
      reg23.din(reg23_in);
      reg23.sel(sel);
      reg23.new_reg(reg23out);

      reg24.clk(clk);
      reg24.din(reg24_in);
      reg24.sel(sel);
      reg24.new_reg(reg24out);

      reg25.clk(clk);
      reg25.din(reg25_in);
      reg25.sel(sel);
      reg25.new_reg(reg25out);

      reg26.clk(clk);
      reg26.din(reg26_in);
      reg26.sel(sel);
      reg26.new_reg(reg26out);

      reg27.clk(clk);
      reg27.din(reg27_in);
      reg27.sel(sel);
      reg27.new_reg(reg27out);

      reg28.clk(clk);
      reg28.din(reg28_in);
      reg28.sel(sel);
      reg28.new_reg(reg28out);

      reg29.clk(clk);
      reg29.din(reg29_in);
      reg29.sel(sel);
      reg29.new_reg(reg29out);

      reg30.clk(clk);
      reg30.din(reg30_in);
      reg30.sel(sel);
      reg30.new_reg(reg30out);

      reg31.clk(clk);
      reg31.din(reg31_in);
      reg31.sel(sel);
      reg31.new_reg(reg31out);

      reg32.clk(clk);
      reg32.din(reg32_in);
      reg32.sel(sel);
      reg32.new_reg(reg32out);

      reg33.clk(clk);
      reg33.din(reg33_in);
      reg33.sel(sel);
      reg33.new_reg(reg33out);

      reg34.clk(clk);
      reg34.din(reg34_in);
      reg34.sel(sel);
      reg34.new_reg(reg34out);

      reg35.clk(clk);
      reg35.din(reg35_in);
      reg35.sel(sel);
      reg35.new_reg(reg35out);

      reg36.clk(clk);
      reg36.din(reg36_in);
      reg36.sel(sel);
      reg36.new_reg(reg36out);

      reg37.clk(clk);
      reg37.din(reg37_in);
      reg37.sel(sel);
      reg37.new_reg(reg37out);

      reg38.clk(clk);
      reg38.din(reg38_in);
      reg38.sel(sel);
      reg38.new_reg(reg38out);

      reg39.clk(clk);
      reg39.din(reg39_in);
      reg39.sel(sel);
      reg39.new_reg(reg39out);

      reg40.clk(clk);
      reg40.din(reg40_in);
      reg40.sel(sel);
      reg40.new_reg(reg40out);

      reg41.clk(clk);
      reg41.din(reg41_in);
      reg41.sel(sel);
      reg41.new_reg(reg41out);

      reg42.clk(clk);
      reg42.din(reg42_in);
      reg42.sel(sel);
      reg42.new_reg(reg42out);

      reg43.clk(clk);
      reg43.din(reg43_in);
      reg43.sel(sel);
      reg43.new_reg(reg43out);

      reg44.clk(clk);
      reg44.din(reg44_in);
      reg44.sel(sel);
      reg44.new_reg(reg44out);

      reg45.clk(clk);
      reg45.din(reg45_in);
      reg45.sel(sel);
      reg45.new_reg(reg45out);

      reg46.clk(clk);
      reg46.din(reg46_in);
      reg46.sel(sel);
      reg46.new_reg(reg46out);

      reg47.clk(clk);
      reg47.din(reg47_in);
      reg47.sel(sel);
      reg47.new_reg(reg47out);

      reg48.clk(clk);
      reg48.din(reg48_in);
      reg48.sel(sel);
      reg48.new_reg(reg48out);

      reg49.clk(clk);
      reg49.din(reg49_in);
      reg49.sel(sel);
      reg49.new_reg(reg49out);

      reg50.clk(clk);
      reg50.din(reg50_in);
      reg50.sel(sel);
      reg50.new_reg(reg50out);

      reg51.clk(clk);
      reg51.din(reg51_in);
      reg51.sel(sel);
      reg51.new_reg(reg51out);

      reg52.clk(clk);
      reg52.din(reg52_in);
      reg52.sel(sel);
      reg52.new_reg(reg52out);

      reg53.clk(clk);
      reg53.din(reg53_in);
      reg53.sel(sel);
      reg53.new_reg(reg53out);

      reg54.clk(clk);
      reg54.din(reg54_in);
      reg54.sel(sel);
      reg54.new_reg(reg54out);

      reg55.clk(clk);
      reg55.din(reg55_in);
      reg55.sel(sel);
      reg55.new_reg(reg55out);

      reg56.clk(clk);
      reg56.din(reg56_in);
      reg56.sel(sel);
      reg56.new_reg(reg56out);

      reg57.clk(clk);
      reg57.din(reg57_in);
      reg57.sel(sel);
      reg57.new_reg(reg57out);

      reg58.clk(clk);
      reg58.din(reg58_in);
      reg58.sel(sel);
      reg58.new_reg(reg58out);

      reg59.clk(clk);
      reg59.din(reg59_in);
      reg59.sel(sel);
      reg59.new_reg(reg59out);

      reg60.clk(clk);
      reg60.din(reg60_in);
      reg60.sel(sel);
      reg60.new_reg(reg60out);

      reg61.clk(clk);
      reg61.din(reg61_in);
      reg61.sel(sel);
      reg61.new_reg(reg61out);

      reg62.clk(clk);
      reg62.din(reg62_in);
      reg62.sel(sel);
      reg62.new_reg(reg62out);

      reg63.clk(clk);
      reg63.din(reg63_in);
      reg63.sel(sel);
      reg63.new_reg(reg63out);

      and_or_and_64_1.in0(reg0out);
      and_or_and_64_1.in1(reg1out);
      and_or_and_64_1.in2(reg2out);
      and_or_and_64_1.in3(reg3out);
      and_or_and_64_1.in4(reg4out);
      and_or_and_64_1.in5(reg5out);
      and_or_and_64_1.in6(reg6out);
      and_or_and_64_1.in7(reg7out);
      and_or_and_64_1.in8(reg8out);
      and_or_and_64_1.in9(reg9out);
      and_or_and_64_1.in10(reg10out);
      and_or_and_64_1.in11(reg11out);
      and_or_and_64_1.in12(reg12out);
      and_or_and_64_1.in13(reg13out);
      and_or_and_64_1.in14(reg14out);
      and_or_and_64_1.in15(reg15out);
      and_or_and_64_1.in16(reg16out);
      and_or_and_64_1.in17(reg17out);
      and_or_and_64_1.in18(reg18out);
      and_or_and_64_1.in19(reg19out);
      and_or_and_64_1.in20(reg20out);
      and_or_and_64_1.in21(reg21out);
      and_or_and_64_1.in22(reg22out);
      and_or_and_64_1.in23(reg23out);
      and_or_and_64_1.in24(reg24out);
      and_or_and_64_1.in25(reg25out);
      and_or_and_64_1.in26(reg26out);
      and_or_and_64_1.in27(reg27out);
      and_or_and_64_1.in28(reg28out);
      and_or_and_64_1.in29(reg29out);
      and_or_and_64_1.in30(reg30out);
      and_or_and_64_1.in31(reg31out);
      and_or_and_64_1.in32(reg32out);
      and_or_and_64_1.in33(reg33out);
      and_or_and_64_1.in34(reg34out);
      and_or_and_64_1.in35(reg35out);
      and_or_and_64_1.in36(reg36out);
      and_or_and_64_1.in37(reg37out);
      and_or_and_64_1.in38(reg38out);
      and_or_and_64_1.in39(reg39out);
      and_or_and_64_1.in40(reg40out);
      and_or_and_64_1.in41(reg41out);
      and_or_and_64_1.in42(reg42out);
      and_or_and_64_1.in43(reg43out);
      and_or_and_64_1.in44(reg44out);
      and_or_and_64_1.in45(reg45out);
      and_or_and_64_1.in46(reg46out);
      and_or_and_64_1.in47(reg47out);
      and_or_and_64_1.in48(reg48out);
      and_or_and_64_1.in49(reg49out);
      and_or_and_64_1.in50(reg50out);
      and_or_and_64_1.in51(reg51out);
      and_or_and_64_1.in52(reg52out);
      and_or_and_64_1.in53(reg53out);
      and_or_and_64_1.in54(reg54out);
      and_or_and_64_1.in55(reg55out);
      and_or_and_64_1.in56(reg56out);
      and_or_and_64_1.in57(reg57out);
      and_or_and_64_1.in58(reg58out);
      and_or_and_64_1.in59(reg59out);
      and_or_and_64_1.in60(reg60out);
      and_or_and_64_1.in61(reg61out);
      and_or_and_64_1.in62(reg62out);
      and_or_and_64_1.in63(reg63out);
      and_or_and_64_1.in64(statusregbits);
      and_or_and_64_1.andnorand64_1_out(rdy); 

    }

    ~register64bit(){ }
};

SC_MODULE(reginsplit4_64)
{
  sc_core::sc_in< sc_dt::sc_bv<64> > reg_A;
  sc_core::sc_in< sc_dt::sc_bv<64> > reg_B;
  sc_core::sc_in< sc_dt::sc_bv<64> > reg_C;
  sc_core::sc_in< sc_dt::sc_bv<64> > reg_D;

  sc_core::sc_out< sc_dt::sc_bv<4> > reg_0;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_1;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_2;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_3;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_4;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_5;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_6;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_7;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_8;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_9;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_10;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_11;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_12;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_13;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_14;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_15;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_16;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_17;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_18;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_19;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_20;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_21;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_22;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_23;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_24;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_25;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_26;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_27;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_28;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_29;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_30;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_31;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_32;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_33;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_34;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_35;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_36;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_37;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_38;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_39;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_40;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_41;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_42;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_43;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_44;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_45;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_46;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_47;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_48;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_49;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_50;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_51;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_52;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_53;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_54;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_55;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_56;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_57;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_58;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_59;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_60;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_61;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_62;
  sc_core::sc_out< sc_dt::sc_bv<4> > reg_63;

  sc_dt::sc_bv<64> in0;
  sc_dt::sc_bv<64> in1;
  sc_dt::sc_bv<64> in2;
  sc_dt::sc_bv<64> in3;

  sc_dt::sc_bv<4> reg_0_out;
  sc_dt::sc_bv<4> reg_1_out;
  sc_dt::sc_bv<4> reg_2_out;
  sc_dt::sc_bv<4> reg_3_out;
  sc_dt::sc_bv<4> reg_4_out;
  sc_dt::sc_bv<4> reg_5_out;
  sc_dt::sc_bv<4> reg_6_out;
  sc_dt::sc_bv<4> reg_7_out;
  sc_dt::sc_bv<4> reg_8_out;
  sc_dt::sc_bv<4> reg_9_out;
  sc_dt::sc_bv<4> reg_10_out;
  sc_dt::sc_bv<4> reg_11_out;
  sc_dt::sc_bv<4> reg_12_out;
  sc_dt::sc_bv<4> reg_13_out;
  sc_dt::sc_bv<4> reg_14_out;
  sc_dt::sc_bv<4> reg_15_out;
  sc_dt::sc_bv<4> reg_16_out;
  sc_dt::sc_bv<4> reg_17_out;
  sc_dt::sc_bv<4> reg_18_out;
  sc_dt::sc_bv<4> reg_19_out;
  sc_dt::sc_bv<4> reg_20_out;
  sc_dt::sc_bv<4> reg_21_out;
  sc_dt::sc_bv<4> reg_22_out;
  sc_dt::sc_bv<4> reg_23_out;
  sc_dt::sc_bv<4> reg_24_out;
  sc_dt::sc_bv<4> reg_25_out;
  sc_dt::sc_bv<4> reg_26_out;
  sc_dt::sc_bv<4> reg_27_out;
  sc_dt::sc_bv<4> reg_28_out;
  sc_dt::sc_bv<4> reg_29_out;
  sc_dt::sc_bv<4> reg_30_out;
  sc_dt::sc_bv<4> reg_31_out;
  sc_dt::sc_bv<4> reg_32_out;
  sc_dt::sc_bv<4> reg_33_out;
  sc_dt::sc_bv<4> reg_34_out;
  sc_dt::sc_bv<4> reg_35_out;
  sc_dt::sc_bv<4> reg_36_out;
  sc_dt::sc_bv<4> reg_37_out;
  sc_dt::sc_bv<4> reg_38_out;
  sc_dt::sc_bv<4> reg_39_out;
  sc_dt::sc_bv<4> reg_40_out;
  sc_dt::sc_bv<4> reg_41_out;
  sc_dt::sc_bv<4> reg_42_out;
  sc_dt::sc_bv<4> reg_43_out;
  sc_dt::sc_bv<4> reg_44_out;
  sc_dt::sc_bv<4> reg_45_out;
  sc_dt::sc_bv<4> reg_46_out;
  sc_dt::sc_bv<4> reg_47_out;
  sc_dt::sc_bv<4> reg_48_out;
  sc_dt::sc_bv<4> reg_49_out;
  sc_dt::sc_bv<4> reg_50_out;
  sc_dt::sc_bv<4> reg_51_out;
  sc_dt::sc_bv<4> reg_52_out;
  sc_dt::sc_bv<4> reg_53_out;
  sc_dt::sc_bv<4> reg_54_out;
  sc_dt::sc_bv<4> reg_55_out;
  sc_dt::sc_bv<4> reg_56_out;
  sc_dt::sc_bv<4> reg_57_out;
  sc_dt::sc_bv<4> reg_58_out;
  sc_dt::sc_bv<4> reg_59_out;
  sc_dt::sc_bv<4> reg_60_out;
  sc_dt::sc_bv<4> reg_61_out;
  sc_dt::sc_bv<4> reg_62_out;
  sc_dt::sc_bv<4> reg_63_out;

  void reginsplit4_64_proc0()
  {
    while(1)
    {
      wait();
      in0 = reg_A.read();
      in1 = reg_B.read();
      in2 = reg_C.read();
      in3 = reg_D.read();

      reg_63_out.range(3,3) = in3.range(63,63);
      reg_63_out.range(2,2) = in2.range(63,63);
      reg_63_out.range(1,1) = in1.range(63,63);
      reg_63_out.range(0,0) = in0.range(63,63);

      reg_62_out.range(3,3) = in3.range(62,52);
      reg_62_out.range(2,2) = in2.range(62,62);
      reg_62_out.range(1,1) = in1.range(62,62);
      reg_62_out.range(0,0) = in0.range(62,62);

      reg_61_out.range(3,3) = in3.range(61,61);
      reg_61_out.range(2,2) = in2.range(61,61);
      reg_61_out.range(1,1) = in1.range(61,61);
      reg_61_out.range(0,0) = in0.range(61,61);

      reg_60_out.range(3,3) = in3.range(60,60);
      reg_60_out.range(2,2) = in2.range(60,60);
      reg_60_out.range(1,1) = in1.range(60,60);
      reg_60_out.range(0,0) = in0.range(60,60);

      reg_59_out.range(3,3) = in3.range(59,59);
      reg_59_out.range(2,2) = in2.range(59,59);
      reg_59_out.range(1,1) = in1.range(59,59);
      reg_59_out.range(0,0) = in0.range(59,59);

      reg_58_out.range(3,3) = in3.range(58,58);
      reg_58_out.range(2,2) = in2.range(58,58);
      reg_58_out.range(1,1) = in1.range(58,58);
      reg_58_out.range(0,0) = in0.range(58,58);

      reg_57_out.range(3,3) = in3.range(57,57);
      reg_57_out.range(2,2) = in2.range(57,57);
      reg_57_out.range(1,1) = in1.range(57,57);
      reg_57_out.range(0,0) = in0.range(57,57);

      reg_56_out.range(3,3) = in3.range(56,56);
      reg_56_out.range(2,2) = in2.range(56,56);
      reg_56_out.range(1,1) = in1.range(56,56);
      reg_56_out.range(0,0) = in0.range(56,56);

      reg_55_out.range(3,3) = in3.range(55,55);
      reg_55_out.range(2,2) = in2.range(55,55);
      reg_55_out.range(1,1) = in1.range(55,55);
      reg_55_out.range(0,0) = in0.range(55,55);

      reg_54_out.range(3,3) = in3.range(54,54);
      reg_54_out.range(2,2) = in2.range(54,54);
      reg_54_out.range(1,1) = in1.range(54,54);
      reg_54_out.range(0,0) = in0.range(54,54);

      reg_53_out.range(3,3) = in3.range(53,53);
      reg_53_out.range(2,2) = in2.range(53,53);
      reg_53_out.range(1,1) = in1.range(53,53);
      reg_53_out.range(0,0) = in0.range(53,53);

      reg_52_out.range(3,3) = in3.range(52,52);
      reg_52_out.range(2,2) = in2.range(52,52);
      reg_52_out.range(1,1) = in1.range(52,53);
      reg_52_out.range(0,0) = in0.range(52,52);

      reg_51_out.range(3,3) = in3.range(51,51);
      reg_51_out.range(2,2) = in2.range(51,51);
      reg_51_out.range(1,1) = in1.range(51,51);
      reg_51_out.range(0,0) = in0.range(51,51);

      reg_50_out.range(3,3) = in3.range(50,50);
      reg_50_out.range(2,2) = in2.range(50,50);
      reg_50_out.range(1,1) = in1.range(50,50);
      reg_50_out.range(0,0) = in0.range(50,50);

      reg_49_out.range(3,3) = in3.range(49,49);
      reg_49_out.range(2,2) = in2.range(49,49);
      reg_49_out.range(1,1) = in1.range(49,49);
      reg_49_out.range(0,0) = in0.range(49,49);

      reg_48_out.range(3,3) = in3.range(48,48);
      reg_48_out.range(2,2) = in2.range(48,48);
      reg_48_out.range(1,1) = in1.range(48,48);
      reg_48_out.range(0,0) = in0.range(48,48);

      reg_47_out.range(3,3) = in3.range(47,47);
      reg_47_out.range(2,2) = in2.range(47,47);
      reg_47_out.range(1,1) = in1.range(47,47);
      reg_47_out.range(0,0) = in0.range(47,47);

      reg_46_out.range(3,3) = in3.range(46,46);
      reg_46_out.range(2,2) = in2.range(46,46);
      reg_46_out.range(1,1) = in1.range(46,46);
      reg_46_out.range(0,0) = in0.range(46,46);

      reg_45_out.range(3,3) = in3.range(45,45);
      reg_45_out.range(2,2) = in2.range(45,45);
      reg_45_out.range(1,1) = in1.range(45,45);
      reg_45_out.range(0,0) = in0.range(45,45);

      reg_44_out.range(3,3) = in3.range(44,44);
      reg_44_out.range(2,2) = in2.range(44,44);
      reg_44_out.range(1,1) = in1.range(44,44);
      reg_44_out.range(0,0) = in0.range(44,44);

      reg_43_out.range(3,3) = in3.range(43,43);
      reg_43_out.range(2,2) = in2.range(43,43);
      reg_43_out.range(1,1) = in1.range(43,43);
      reg_43_out.range(0,0) = in0.range(43,43);

      reg_42_out.range(3,3) = in3.range(42,42);
      reg_42_out.range(2,2) = in2.range(42,42);
      reg_42_out.range(1,1) = in1.range(42,42);
      reg_42_out.range(0,0) = in0.range(42,42);

      reg_41_out.range(3,3) = in3.range(41,41);
      reg_41_out.range(2,2) = in2.range(41,41);
      reg_41_out.range(1,1) = in1.range(41,41);
      reg_41_out.range(0,0) = in0.range(41,41);

      reg_40_out.range(3,3) = in3.range(40,40);
      reg_40_out.range(2,2) = in2.range(40,40);
      reg_40_out.range(1,1) = in1.range(40,40);
      reg_40_out.range(0,0) = in0.range(40,40);

      reg_39_out.range(3,3) = in3.range(39,39);
      reg_39_out.range(2,2) = in2.range(39,39);
      reg_39_out.range(1,1) = in1.range(39,39);
      reg_39_out.range(0,0) = in0.range(39,39);

      reg_38_out.range(3,3) = in3.range(38,38);
      reg_38_out.range(2,2) = in2.range(38,38);
      reg_38_out.range(1,1) = in1.range(38,38);
      reg_38_out.range(0,0) = in0.range(38,38);

      reg_37_out.range(3,3) = in3.range(37,37);
      reg_37_out.range(2,2) = in2.range(37,37);
      reg_37_out.range(1,1) = in1.range(37,37);
      reg_37_out.range(0,0) = in0.range(37,37);

      reg_36_out.range(3,3) = in3.range(36,36);
      reg_36_out.range(2,2) = in2.range(36,36);
      reg_36_out.range(1,1) = in1.range(36,36);
      reg_36_out.range(0,0) = in0.range(36,36);

      reg_35_out.range(3,3) = in3.range(35,35);
      reg_35_out.range(2,2) = in2.range(35,35);
      reg_35_out.range(1,1) = in1.range(35,35);
      reg_35_out.range(0,0) = in0.range(35,35);

      reg_34_out.range(3,3) = in3.range(34,34);
      reg_34_out.range(2,2) = in2.range(34,34);
      reg_34_out.range(1,1) = in1.range(34,34);
      reg_34_out.range(0,0) = in0.range(34,34);

      reg_33_out.range(3,3) = in3.range(33,33);
      reg_33_out.range(2,2) = in2.range(33,33);
      reg_33_out.range(1,1) = in1.range(33,33);
      reg_33_out.range(0,0) = in0.range(33,33);

      reg_32_out.range(3,3) = in3.range(32,32);
      reg_32_out.range(2,2) = in2.range(32,32);
      reg_32_out.range(1,1) = in1.range(32,32);
      reg_32_out.range(0,0) = in0.range(32,32);

      reg_31_out.range(3,3) = in3.range(31,31);
      reg_31_out.range(2,2) = in2.range(31,31);
      reg_31_out.range(1,1) = in1.range(31,31);
      reg_31_out.range(0,0) = in0.range(31,31);

      reg_30_out.range(3,3) = in3.range(30,30);
      reg_30_out.range(2,2) = in2.range(30,30);
      reg_30_out.range(1,1) = in1.range(30,30);
      reg_30_out.range(0,0) = in0.range(30,30);

      reg_29_out.range(3,3) = in3.range(29,29);
      reg_29_out.range(2,2) = in2.range(29,29);
      reg_29_out.range(1,1) = in1.range(29,29);
      reg_29_out.range(0,0) = in0.range(29,29);

      reg_28_out.range(3,3) = in3.range(28,28);
      reg_28_out.range(2,2) = in2.range(28,28);
      reg_28_out.range(1,1) = in1.range(28,28);
      reg_28_out.range(0,0) = in0.range(28,28);

      reg_27_out.range(3,3) = in3.range(27,27);
      reg_27_out.range(2,2) = in2.range(27,27);
      reg_27_out.range(1,1) = in1.range(27,27);
      reg_27_out.range(0,0) = in0.range(27,27);

      reg_26_out.range(3,3) = in3.range(26,26);
      reg_26_out.range(2,2) = in2.range(26,26);
      reg_26_out.range(1,1) = in1.range(26,26);
      reg_26_out.range(0,0) = in0.range(26,26);

      reg_25_out.range(3,3) = in3.range(25,25);
      reg_25_out.range(2,2) = in2.range(25,25);
      reg_25_out.range(1,1) = in1.range(25,25);
      reg_25_out.range(0,0) = in0.range(25,25);

      reg_24_out.range(3,3) = in3.range(24,24);
      reg_24_out.range(2,2) = in2.range(24,24);
      reg_24_out.range(1,1) = in1.range(24,24);
      reg_24_out.range(0,0) = in0.range(24,24);

      reg_23_out.range(3,3) = in3.range(23,23);
      reg_23_out.range(2,2) = in2.range(23,23);
      reg_23_out.range(1,1) = in1.range(23,23);
      reg_23_out.range(0,0) = in0.range(23,23);

      reg_22_out.range(3,3) = in3.range(22,22);
      reg_22_out.range(2,2) = in2.range(22,22);
      reg_22_out.range(1,1) = in1.range(22,22);
      reg_22_out.range(0,0) = in0.range(22,22);

      reg_21_out.range(3,3) = in3.range(21,21);
      reg_21_out.range(2,2) = in2.range(21,21);
      reg_21_out.range(1,1) = in1.range(21,21);
      reg_21_out.range(0,0) = in0.range(21,21);

      reg_20_out.range(3,3) = in3.range(20,20);
      reg_20_out.range(2,2) = in2.range(20,20);
      reg_20_out.range(1,1) = in1.range(20,20);
      reg_20_out.range(0,0) = in0.range(20,20);

      reg_19_out.range(3,3) = in3.range(19,19);
      reg_19_out.range(2,2) = in2.range(19,19);
      reg_19_out.range(1,1) = in1.range(19,19);
      reg_19_out.range(0,0) = in0.range(19,19);

      reg_18_out.range(3,3) = in3.range(18,18);
      reg_18_out.range(2,2) = in2.range(18,18);
      reg_18_out.range(1,1) = in1.range(18,18);
      reg_18_out.range(0,0) = in0.range(18,18);

      reg_17_out.range(3,3) = in3.range(17,17);
      reg_17_out.range(2,2) = in2.range(17,17);
      reg_17_out.range(1,1) = in1.range(17,17);
      reg_17_out.range(0,0) = in0.range(17,17);

      reg_16_out.range(3,3) = in3.range(16,16);
      reg_16_out.range(2,2) = in2.range(16,16);
      reg_16_out.range(1,1) = in1.range(16,16);
      reg_16_out.range(0,0) = in0.range(16,16);

      reg_15_out.range(3,3) = in3.range(15,15);
      reg_15_out.range(2,2) = in2.range(15,15);
      reg_15_out.range(1,1) = in1.range(15,15);
      reg_15_out.range(0,0) = in0.range(15,15);

      reg_14_out.range(3,3) = in3.range(14,14);
      reg_14_out.range(2,2) = in2.range(14,14);
      reg_14_out.range(1,1) = in1.range(14,14);
      reg_14_out.range(0,0) = in0.range(14,14);

      reg_13_out.range(3,3) = in3.range(13,13);
      reg_13_out.range(2,2) = in2.range(13,13);
      reg_13_out.range(1,1) = in1.range(13,13);
      reg_13_out.range(0,0) = in0.range(13,13);

      reg_12_out.range(3,3) = in3.range(12,12);
      reg_12_out.range(2,2) = in2.range(12,12);
      reg_12_out.range(1,1) = in1.range(12,12);
      reg_12_out.range(0,0) = in0.range(12,12);

      reg_11_out.range(3,3) = in3.range(11,11);
      reg_11_out.range(2,2) = in2.range(11,11);
      reg_11_out.range(1,1) = in1.range(11,11);
      reg_11_out.range(0,0) = in0.range(11,11);
 
      reg_10_out.range(3,3) = in3.range(10,10);
      reg_10_out.range(2,2) = in2.range(10,10);
      reg_10_out.range(1,1) = in1.range(10,10);
      reg_10_out.range(0,0) = in0.range(10,10);

      reg_9_out.range(3,3) = in3.range(9,9);
      reg_9_out.range(2,2) = in2.range(9,9);
      reg_9_out.range(1,1) = in1.range(9,9);
      reg_9_out.range(0,0) = in0.range(9,9);

      reg_8_out.range(3,3) = in3.range(8,8);
      reg_8_out.range(2,2) = in2.range(8,8);
      reg_8_out.range(1,1) = in1.range(8,8);
      reg_8_out.range(0,0) = in0.range(8,8);

      reg_7_out.range(3,3) = in3.range(7,7);
      reg_7_out.range(2,2) = in2.range(7,7);
      reg_7_out.range(1,1) = in1.range(7,7);
      reg_7_out.range(0,0) = in0.range(7,7);

      reg_6_out.range(3,3) = in3.range(6,6);
      reg_6_out.range(2,2) = in2.range(6,6);
      reg_6_out.range(1,1) = in1.range(6,6);
      reg_6_out.range(0,0) = in0.range(6,6);

      reg_5_out.range(3,3) = in3.range(5,5);
      reg_5_out.range(2,2) = in2.range(5,5);
      reg_5_out.range(1,1) = in1.range(5,5);
      reg_5_out.range(0,0) = in0.range(5,5);

      reg_4_out.range(3,3) = in3.range(4,4);
      reg_4_out.range(2,2) = in2.range(4,4);
      reg_4_out.range(1,1) = in1.range(4,4);
      reg_4_out.range(0,0) = in0.range(4,4);

      reg_3_out.range(3,3) = in3.range(3,3);
      reg_3_out.range(2,2) = in2.range(3,3);
      reg_3_out.range(1,1) = in1.range(3,3);
      reg_3_out.range(0,0) = in0.range(3,3);

      reg_2_out.range(3,3) = in3.range(2,2);
      reg_2_out.range(2,2) = in2.range(2,2);
      reg_2_out.range(1,1) = in1.range(2,2);
      reg_2_out.range(0,0) = in0.range(2,2);

      reg_1_out.range(3,3) = in3.range(1,1);
      reg_1_out.range(2,2) = in2.range(1,1);
      reg_1_out.range(1,1) = in1.range(1,1);
      reg_1_out.range(0,0) = in0.range(1,1);

      reg_0_out.range(3,3) = in3.range(0,0);
      reg_0_out.range(2,2) = in2.range(0,0);
      reg_0_out.range(1,1) = in1.range(0,0);
      reg_0_out.range(0,0) = in0.range(0,0);

      reg_63.write(reg_63_out);
      reg_62.write(reg_62_out);
      reg_61.write(reg_61_out);
      reg_60.write(reg_60_out);
      
      reg_59.write(reg_59_out);
      reg_58.write(reg_58_out);
      reg_57.write(reg_57_out);
      reg_56.write(reg_56_out);
      reg_55.write(reg_55_out);
      reg_54.write(reg_54_out);
      reg_53.write(reg_53_out);
      reg_52.write(reg_52_out);
      reg_51.write(reg_51_out);
      reg_50.write(reg_50_out);

      reg_49.write(reg_49_out);
      reg_48.write(reg_48_out);
      reg_47.write(reg_47_out);
      reg_46.write(reg_46_out);
      reg_45.write(reg_45_out);
      reg_44.write(reg_44_out);
      reg_43.write(reg_43_out);
      reg_42.write(reg_42_out);
      reg_41.write(reg_41_out);
      reg_40.write(reg_40_out);

      reg_39.write(reg_39_out);
      reg_38.write(reg_38_out);
      reg_37.write(reg_37_out);
      reg_36.write(reg_36_out);
      reg_35.write(reg_35_out);
      reg_34.write(reg_34_out);
      reg_33.write(reg_33_out);
      reg_32.write(reg_32_out);
      reg_31.write(reg_31_out);
      reg_30.write(reg_30_out);

      reg_29.write(reg_29_out);
      reg_28.write(reg_28_out);
      reg_27.write(reg_27_out);
      reg_26.write(reg_26_out);
      reg_25.write(reg_25_out);
      reg_24.write(reg_24_out);
      reg_23.write(reg_23_out);
      reg_22.write(reg_22_out);
      reg_21.write(reg_21_out);
      reg_20.write(reg_20_out);

      reg_9.write(reg_9_out);
      reg_8.write(reg_8_out);
      reg_7.write(reg_7_out);
      reg_6.write(reg_6_out);
      reg_5.write(reg_5_out);
      reg_4.write(reg_4_out);
      reg_3.write(reg_3_out);
      reg_2.write(reg_2_out);
      reg_1.write(reg_1_out);
      reg_0.write(reg_0_out);
    }
  }

  SC_CTOR(reginsplit4_64)
  {
    SC_THREAD(reginsplit4_64_proc0);
    sensitive << reg_A << reg_B << reg_C << reg_D;
  }

  ~reginsplit4_64() { }
};

SC_MODULE(reg1hotsplit)
{
  sc_core::sc_in< sc_dt::sc_bv<160> > onehotin;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg0_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg1_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg2_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg3_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg4_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg5_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg6_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg7_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg8_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg9_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg10_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg11_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg12_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg13_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg14_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg15_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg16_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg17_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg18_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg19_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg20_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg21_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg22_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg23_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg24_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg25_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg26_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg27_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg28_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg29_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg30_1hot;
  sc_core::sc_out< sc_dt::sc_bv<5> > reg31_1hot;
  
  sc_dt::sc_bv<160> onehot_in;
  sc_dt::sc_bv<5> reg0_1hot_out;
  sc_dt::sc_bv<5> reg1_1hot_out;
  sc_dt::sc_bv<5> reg2_1hot_out;
  sc_dt::sc_bv<5> reg3_1hot_out;
  sc_dt::sc_bv<5> reg4_1hot_out;
  sc_dt::sc_bv<5> reg5_1hot_out;
  sc_dt::sc_bv<5> reg6_1hot_out;
  sc_dt::sc_bv<5> reg7_1hot_out;
  sc_dt::sc_bv<5> reg8_1hot_out;
  sc_dt::sc_bv<5> reg9_1hot_out;
  sc_dt::sc_bv<5> reg10_1hot_out;
  sc_dt::sc_bv<5> reg11_1hot_out;
  sc_dt::sc_bv<5> reg12_1hot_out;
  sc_dt::sc_bv<5> reg13_1hot_out;
  sc_dt::sc_bv<5> reg14_1hot_out;
  sc_dt::sc_bv<5> reg15_1hot_out;
  sc_dt::sc_bv<5> reg16_1hot_out;
  sc_dt::sc_bv<5> reg17_1hot_out;
  sc_dt::sc_bv<5> reg18_1hot_out;
  sc_dt::sc_bv<5> reg19_1hot_out;
  sc_dt::sc_bv<5> reg20_1hot_out;
  sc_dt::sc_bv<5> reg21_1hot_out;
  sc_dt::sc_bv<5> reg22_1hot_out;
  sc_dt::sc_bv<5> reg23_1hot_out;
  sc_dt::sc_bv<5> reg24_1hot_out;
  sc_dt::sc_bv<5> reg25_1hot_out;
  sc_dt::sc_bv<5> reg26_1hot_out;
  sc_dt::sc_bv<5> reg27_1hot_out;
  sc_dt::sc_bv<5> reg28_1hot_out;
  sc_dt::sc_bv<5> reg29_1hot_out;
  sc_dt::sc_bv<5> reg30_1hot_out;
  sc_dt::sc_bv<5> reg31_1hot_out;

  void reg1hotsplit_proc0()
  {
    while(1)
    {
     wait();
     onehot_in = onehotin.read();
     reg31_1hot_out.range(4,0) = onehot_in.range(159,155);
     reg30_1hot_out.range(4,0) = onehot_in.range(154,150);
     reg29_1hot_out.range(4,0) = onehot_in.range(149,145);
     reg28_1hot_out.range(4,0) = onehot_in.range(144,140);
     reg27_1hot_out.range(4,0) = onehot_in.range(139,135);
     reg26_1hot_out.range(4,0) = onehot_in.range(134,130);
     reg25_1hot_out.range(4,0) = onehot_in.range(129,125);
     reg24_1hot_out.range(4,0) = onehot_in.range(124,120);
     reg23_1hot_out.range(4,0) = onehot_in.range(119,115);
     reg22_1hot_out.range(4,0) = onehot_in.range(114,110);
     reg21_1hot_out.range(4,0) = onehot_in.range(109,105);
     reg20_1hot_out.range(4,0) = onehot_in.range(104,100);
     reg19_1hot_out.range(4,0) = onehot_in.range(99,95);
     reg18_1hot_out.range(4,0) = onehot_in.range(94,90);
     reg17_1hot_out.range(4,0) = onehot_in.range(89,85);
     reg16_1hot_out.range(4,0) = onehot_in.range(84,80);
     reg15_1hot_out.range(4,0) = onehot_in.range(79,75);
     reg14_1hot_out.range(4,0) = onehot_in.range(74,70);
     reg13_1hot_out.range(4,0) = onehot_in.range(69,65);
     reg12_1hot_out.range(4,0) = onehot_in.range(64,60);
     reg11_1hot_out.range(4,0) = onehot_in.range(59,55);
     reg10_1hot_out.range(4,0) = onehot_in.range(54,50);
     reg9_1hot_out.range(4,0) = onehot_in.range(49,45);
     reg8_1hot_out.range(4,0) = onehot_in.range(44,40);
     reg7_1hot_out.range(4,0) = onehot_in.range(39,35);
     reg6_1hot_out.range(4,0) = onehot_in.range(34,30);
     reg5_1hot_out.range(4,0) = onehot_in.range(29,25);
     reg4_1hot_out.range(4,0) = onehot_in.range(24,20);
     reg3_1hot_out.range(4,0) = onehot_in.range(19,15);
     reg2_1hot_out.range(4,0) = onehot_in.range(14,10);
     reg1_1hot_out.range(4,0) = onehot_in.range(9,5);
     reg0_1hot_out.range(4,0) = onehot_in.range(4,0);
     reg31_1hot.write(reg31_1hot_out);
     reg30_1hot.write(reg30_1hot_out);
     reg29_1hot.write(reg29_1hot_out);
     reg28_1hot.write(reg28_1hot_out);
     reg27_1hot.write(reg27_1hot_out);
     reg26_1hot.write(reg26_1hot_out);
     reg25_1hot.write(reg25_1hot_out);
     reg24_1hot.write(reg24_1hot_out);
     reg23_1hot.write(reg23_1hot_out);
     reg22_1hot.write(reg22_1hot_out);
     reg21_1hot.write(reg21_1hot_out);
     reg20_1hot.write(reg20_1hot_out);
     reg19_1hot.write(reg19_1hot_out);
     reg18_1hot.write(reg18_1hot_out);
     reg17_1hot.write(reg17_1hot_out);
     reg16_1hot.write(reg16_1hot_out);
     reg15_1hot.write(reg15_1hot_out);
     reg14_1hot.write(reg14_1hot_out);
     reg13_1hot.write(reg13_1hot_out);
     reg12_1hot.write(reg12_1hot_out);
     reg11_1hot.write(reg11_1hot_out);
     reg10_1hot.write(reg10_1hot_out);
     reg9_1hot.write(reg9_1hot_out);
     reg8_1hot.write(reg8_1hot_out);
     reg7_1hot.write(reg7_1hot_out);
     reg6_1hot.write(reg6_1hot_out);
     reg5_1hot.write(reg5_1hot_out);
     reg4_1hot.write(reg4_1hot_out);
     reg3_1hot.write(reg3_1hot_out);
     reg2_1hot.write(reg2_1hot_out);
     reg1_1hot.write(reg1_1hot_out);
     reg0_1hot.write(reg0_1hot_out);
   }
  }

  SC_CTOR(reg1hotsplit)
  {
    SC_THREAD(reg1hotsplit_proc0);
    sensitive << onehotin;
  }

  ~reg1hotsplit() { }
};


SC_MODULE(scoreboard)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_in< sc_dt::sc_bv<64> > regin0;
  sc_core::sc_in< sc_dt::sc_bv<64> > regin1;
  sc_core::sc_in< sc_dt::sc_bv<64> > regin2;
  sc_core::sc_in< sc_dt::sc_bv<64> > regin3;
  sc_core::sc_in< sc_dt::sc_bv<64> > statusreg;
  sc_core::sc_out< sc_dt::sc_bv<1> > rdy_31;
  
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_0;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_1;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_2;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_3;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_4;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_5;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_6;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_7;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_8;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_9;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_10;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_11;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_12;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_13;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_14;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_15;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_16;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_17;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_18;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_19;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_20;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_21;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_22;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_23;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_24;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_25;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_26;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_27;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_28;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_29;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_30;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_31;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_32;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_33;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_34;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_35;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_36;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_37;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_38;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_39;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_40;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_41;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_42;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_43;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_44;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_45;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_46;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_47;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_48;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_49;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_50;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_51;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_52;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_53;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_54;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_55;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_56;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_57;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_58;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_59;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_60;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_61;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_62;
  sc_core::sc_signal< sc_dt::sc_bv<4> > sig63_63;

  reginsplit4_64 reg_in_split_4_64_63;
  register64bit reg__64bit_63;
  
  SC_CTOR(scoreboard):reg__64bit_63("reg__64bit_63"),
                      reg_in_split_4_64_63("reg_in_split_4_64_63")
  {
    reg_in_split_4_64_63.reg_A(regin0);
    reg_in_split_4_64_63.reg_B(regin1);
    reg_in_split_4_64_63.reg_C(regin2);
    reg_in_split_4_64_63.reg_D(regin3);
    reg_in_split_4_64_63.reg_0(sig63_0);
    reg_in_split_4_64_63.reg_1(sig63_1);
    reg_in_split_4_64_63.reg_2(sig63_2);
    reg_in_split_4_64_63.reg_3(sig63_3);
    reg_in_split_4_64_63.reg_4(sig63_4);
    reg_in_split_4_64_63.reg_5(sig63_5);
    reg_in_split_4_64_63.reg_6(sig63_6);
    reg_in_split_4_64_63.reg_7(sig63_7);
    reg_in_split_4_64_63.reg_8(sig63_8);
    reg_in_split_4_64_63.reg_9(sig63_9);
    reg_in_split_4_64_63.reg_10(sig63_10);
    reg_in_split_4_64_63.reg_11(sig63_11);
    reg_in_split_4_64_63.reg_12(sig63_12);
    reg_in_split_4_64_63.reg_13(sig63_13);
    reg_in_split_4_64_63.reg_14(sig63_14);
    reg_in_split_4_64_63.reg_15(sig63_15);
    reg_in_split_4_64_63.reg_16(sig63_16);
    reg_in_split_4_64_63.reg_17(sig63_17);
    reg_in_split_4_64_63.reg_18(sig63_18);
    reg_in_split_4_64_63.reg_19(sig63_19);
    reg_in_split_4_64_63.reg_20(sig63_20);
    reg_in_split_4_64_63.reg_21(sig63_21);
    reg_in_split_4_64_63.reg_22(sig63_22);
    reg_in_split_4_64_63.reg_23(sig63_23);
    reg_in_split_4_64_63.reg_24(sig63_24);
    reg_in_split_4_64_63.reg_25(sig63_25);
    reg_in_split_4_64_63.reg_26(sig63_26);
    reg_in_split_4_64_63.reg_27(sig63_27);
    reg_in_split_4_64_63.reg_28(sig63_28);
    reg_in_split_4_64_63.reg_29(sig63_29);
    reg_in_split_4_64_63.reg_30(sig63_30);
    reg_in_split_4_64_63.reg_31(sig63_31);
    reg_in_split_4_64_63.reg_32(sig63_32);
    reg_in_split_4_64_63.reg_33(sig63_33);
    reg_in_split_4_64_63.reg_34(sig63_34);
    reg_in_split_4_64_63.reg_35(sig63_35);
    reg_in_split_4_64_63.reg_36(sig63_36);
    reg_in_split_4_64_63.reg_37(sig63_37);
    reg_in_split_4_64_63.reg_38(sig63_38);
    reg_in_split_4_64_63.reg_39(sig63_39);
    reg_in_split_4_64_63.reg_40(sig63_40);
    reg_in_split_4_64_63.reg_41(sig63_41);
    reg_in_split_4_64_63.reg_42(sig63_42);
    reg_in_split_4_64_63.reg_43(sig63_43);
    reg_in_split_4_64_63.reg_44(sig63_44);
    reg_in_split_4_64_63.reg_45(sig63_45);
    reg_in_split_4_64_63.reg_46(sig63_46);
    reg_in_split_4_64_63.reg_47(sig63_47);
    reg_in_split_4_64_63.reg_48(sig63_48);
    reg_in_split_4_64_63.reg_49(sig63_49);
    reg_in_split_4_64_63.reg_50(sig63_50);
    reg_in_split_4_64_63.reg_51(sig63_51);
    reg_in_split_4_64_63.reg_52(sig63_52);
    reg_in_split_4_64_63.reg_53(sig63_53);
    reg_in_split_4_64_63.reg_54(sig63_54);
    reg_in_split_4_64_63.reg_55(sig63_55);
    reg_in_split_4_64_63.reg_56(sig63_56);
    reg_in_split_4_64_63.reg_57(sig63_57);
    reg_in_split_4_64_63.reg_58(sig63_58);
    reg_in_split_4_64_63.reg_59(sig63_59);
    reg_in_split_4_64_63.reg_60(sig63_60);
    reg_in_split_4_64_63.reg_61(sig63_61);
    reg_in_split_4_64_63.reg_62(sig63_62);
    reg_in_split_4_64_63.reg_63(sig63_63);
 
    reg__64bit_63.clk(clk);
    reg__64bit_63.sel(sel);
    reg__64bit_63.statusregbits(statusreg);
    reg__64bit_63.rdy(rdy_31);
    reg__64bit_63.reg0_in(sig63_0);
    reg__64bit_63.reg1_in(sig63_1);
    reg__64bit_63.reg2_in(sig63_2);
    reg__64bit_63.reg3_in(sig63_3);
    reg__64bit_63.reg4_in(sig63_4);
    reg__64bit_63.reg5_in(sig63_5);
    reg__64bit_63.reg6_in(sig63_6);
    reg__64bit_63.reg7_in(sig63_7);
    reg__64bit_63.reg8_in(sig63_8);
    reg__64bit_63.reg9_in(sig63_9);
    reg__64bit_63.reg10_in(sig63_10);
    reg__64bit_63.reg11_in(sig63_11);
    reg__64bit_63.reg12_in(sig63_12);
    reg__64bit_63.reg13_in(sig63_13);
    reg__64bit_63.reg14_in(sig63_14);
    reg__64bit_63.reg15_in(sig63_15);
    reg__64bit_63.reg16_in(sig63_16);
    reg__64bit_63.reg17_in(sig63_17);
    reg__64bit_63.reg18_in(sig63_18);
    reg__64bit_63.reg19_in(sig63_19);
    reg__64bit_63.reg20_in(sig63_20);
    reg__64bit_63.reg21_in(sig63_21);
    reg__64bit_63.reg22_in(sig63_22);
    reg__64bit_63.reg23_in(sig63_23);
    reg__64bit_63.reg24_in(sig63_24);
    reg__64bit_63.reg25_in(sig63_25);
    reg__64bit_63.reg26_in(sig63_26);
    reg__64bit_63.reg27_in(sig63_27);
    reg__64bit_63.reg28_in(sig63_28);
    reg__64bit_63.reg29_in(sig63_29);
    reg__64bit_63.reg30_in(sig63_30);
    reg__64bit_63.reg31_in(sig63_31);
    reg__64bit_63.reg32_in(sig63_32);
    reg__64bit_63.reg33_in(sig63_33);
    reg__64bit_63.reg34_in(sig63_34);
    reg__64bit_63.reg35_in(sig63_35);
    reg__64bit_63.reg36_in(sig63_36);
    reg__64bit_63.reg37_in(sig63_37);
    reg__64bit_63.reg38_in(sig63_38);
    reg__64bit_63.reg39_in(sig63_39);
    reg__64bit_63.reg40_in(sig63_40);
    reg__64bit_63.reg41_in(sig63_41);
    reg__64bit_63.reg42_in(sig63_42);
    reg__64bit_63.reg43_in(sig63_43);
    reg__64bit_63.reg44_in(sig63_44);
    reg__64bit_63.reg45_in(sig63_45);
    reg__64bit_63.reg46_in(sig63_46);
    reg__64bit_63.reg47_in(sig63_47);
    reg__64bit_63.reg48_in(sig63_48);
    reg__64bit_63.reg49_in(sig63_49);
    reg__64bit_63.reg50_in(sig63_50);
    reg__64bit_63.reg51_in(sig63_51);
    reg__64bit_63.reg52_in(sig63_52);
    reg__64bit_63.reg53_in(sig63_53);
    reg__64bit_63.reg54_in(sig63_54);
    reg__64bit_63.reg55_in(sig63_55);
    reg__64bit_63.reg56_in(sig63_56);
    reg__64bit_63.reg57_in(sig63_57);
    reg__64bit_63.reg58_in(sig63_58);
    reg__64bit_63.reg59_in(sig63_59);
    reg__64bit_63.reg60_in(sig63_60);
    reg__64bit_63.reg61_in(sig63_61);
    reg__64bit_63.reg62_in(sig63_62);
    reg__64bit_63.reg63_in(sig63_63);
  }

  ~scoreboard(){ }
};

#endif

