#ifndef THREEIGHTDEC_H
#define THREEIGHTDEC_H

#include <systemc>

SC_MODULE(threeightdec)
{
  sc_core::sc_in< sc_dt::sc_lv<3> > in;
  sc_core::sc_out< sc_dt::sc_lv<8> > out; 

  sc_dt::sc_lv<3> inlv;
  sc_dt::sc_lv<8> outlv;

  void threeightdec_proc0()
  {
    while(1)
    {
      wait();
      inlv = in.read();
      if(inlv == "000") outlv = "10000000";
      else if(inlv == "001") outlv = "01000000";
      else if(inlv == "010") outlv = "00100000";
      else if(inlv == "011") outlv = "00010000";
      else if(inlv == "100") outlv = "00001000";     
      else if(inlv == "101") outlv = "00000100";
      else if(inlv == "110") outlv = "00000010";
      else if(inlv == "111") outlv = "00000001";
      else outlv = "ZZZZZZZZ";
      out.write(outlv);
    }
  }

  SC_CTOR(threeightdec):inlv("ZZZ"), outlv("ZZZZZZZZ")
  {
    SC_THREAD(threeightdec_proc0);
    sensitive << in;
  }

  ~threeightdec(){ }
};

#endif
  
