/*
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * 
 *
 * This file is a generated sample test application.
 *
 * This application is intended to test and/or illustrate some 
 * functionality of your system.  The contents of this file may
 * vary depending on the IP in your system and may use existing
 * IP driver functions.  These drivers will be generated in your
 * SDK application project when you run the "Generate Libraries" menu item.
 *
 */

#include <stdio.h>
#include "xparameters.h"
#include "xil_cache.h"
#include "xscugic.h"
#include "xil_exception.h"
#include "scugic_header.h"
#include "xgpio.h"
#include "gpio_header.h"
#include "xdevcfg.h"
#include "devcfg_header.h"
#include "xdmaps.h"
#include "dmaps_header.h"
#include "xiicps.h"
#include "iicps_header.h"
#include "xqspips.h"
#include "qspips_header.h"
#include "xscutimer.h"
#include "scutimer_header.h"
#include "xscuwdt.h"
#include "scuwdt_header.h"
#include "xttcps.h"
#include "ttcps_header.h"

  // Specify the device ID that is generated in xparameters.h
#define DeviceId  XPAR_XSCUTIMER_0_DEVICE_ID
#define TIMER_LOAD_VALUE  0x7FFFFFFF
#define LEDR 0x41210000
#define SWITCHES 0x41220000
#define LOOPS 1000000
#define BITS 32


// Needed for the timer:
  XScuTimer Timer;    /* Cortex A9 SCU Private Timer Instance */
  XScuTimer_Config *ConfigPtr;
  XScuTimer *TimerInstancePtr = &Timer;
// Function prototypes:
     int SW_BITSWAP(int);

int main() 
{
  int Status;
  volatile int Value1 = 0;
  volatile int Value2 = 0;
  volatile int Value21 = 0;
  int seconds=0;
  int k, s4, sv, swap, old_sv =0;
  int start_time, finish_time, total_time1, total_time2;
  int a = 0x12345678;
  int b = 0x1E6A2C48;
  printf("SWAP %X bits => %X\n",a,swap);
  static XScuGic intc;
  static XScuTimer ps7_scutimer_0;
  static XScuWdt ps7_scuwdt_0;
  static XTtcPs ps7_ttc_0;
  Xil_ICacheEnable();
  Xil_DCacheEnable();
  print("---Entering main---\n\r");

     {
        int Status;

        print("\r\n Running ScuGicSelfTestExample() for ps7_scugic_0...\r\n");

        Status = ScuGicSelfTestExample(XPAR_PS7_SCUGIC_0_DEVICE_ID);

        if (Status == 0) {
           print("ScuGicSelfTestExample PASSED\r\n");
        }
        else {
           print("ScuGicSelfTestExample FAILED\r\n");
        }
     }

     {
         int Status;

         Status = ScuGicInterruptSetup(&intc, XPAR_PS7_SCUGIC_0_DEVICE_ID);
         if (Status == 0) {
            print("ScuGic Interrupt Setup PASSED\r\n");
         }
         else {
           print("ScuGic Interrupt Setup FAILED\r\n");
        }
     }
   

   {
      u32 status;
      
      print("\r\nRunning GpioOutputExample() for axi_gpio_led...\r\n");

      status = GpioOutputExample(XPAR_AXI_GPIO_LED_DEVICE_ID,4);
      
      if (status == 0) {
         print("GpioOutputExample PASSED.\r\n");
      }
      else {
         print("GpioOutputExample FAILED.\r\n");
      }
   }
   

   {
      u32 status;
      
      print("\r\nRunning GpioInputExample() for axi_gpio_sw...\r\n");

      u32 DataRead;
      
      status = GpioInputExample(XPAR_AXI_GPIO_SW_DEVICE_ID, &DataRead);
      
      if (status == 0) {
         xil_printf("GpioInputExample PASSED. Read data:0x%X\r\n", DataRead);
      }
      else {
         print("GpioInputExample FAILED.\r\n");
      }
   }
   

   {
      int Status;

      print("\r\n Running DcfgSelfTestExample() for ps7_dev_cfg_0...\r\n");

      Status = DcfgSelfTestExample(XPAR_PS7_DEV_CFG_0_DEVICE_ID);

      if (Status == 0) {
         print("DcfgSelfTestExample PASSED\r\n");
      }
      else {
         print("DcfgSelfTestExample FAILED\r\n");
      }
   }
   

   {
      int Status;
      
      print("\r\n Running XDmaPs_Example_W_Intr() for ps7_dma_s...\r\n");
      
      Status = XDmaPs_Example_W_Intr(&intc,XPAR_PS7_DMA_S_DEVICE_ID);
      
      if (Status == 0) {
         print("XDmaPs_Example_W_Intr PASSED\r\n");
      }
      else {
         print("XDmaPs_Example_W_Intr FAILED\r\n");
      }
   }
   

   {
      int Status;

      print("\r\n Running IicPsSelfTestExample() for ps7_i2c_0...\r\n");

      Status = IicPsSelfTestExample(XPAR_PS7_I2C_0_DEVICE_ID);

      if (Status == 0) {
         print("IicPsSelfTestExample PASSED\r\n");
      }
      else {
         print("IicPsSelfTestExample FAILED\r\n");
      }
   }
   

   {
      int Status;

      print("\r\n Running IicPsSelfTestExample() for ps7_i2c_1...\r\n");

      Status = IicPsSelfTestExample(XPAR_PS7_I2C_1_DEVICE_ID);

      if (Status == 0) {
         print("IicPsSelfTestExample PASSED\r\n");
      }
      else {
         print("IicPsSelfTestExample FAILED\r\n");
      }
   }
   

   {
      int Status;

      print("\r\n Running QspiSelfTestExample() for ps7_qspi_0...\r\n");

      Status = QspiPsSelfTestExample(XPAR_PS7_QSPI_0_DEVICE_ID);

      if (Status == 0) {
         print("QspiPsSelfTestExample PASSED\r\n");
      }
      else {
         print("QspiPsSelfTestExample FAILED\r\n");
      }
   }
   

   {
      u32 status;
      
      print("\r\nRunning GpioInputExample() for axi_gpio_btn...\r\n");

      u32 DataRead;
      
      status = GpioInputExample(XPAR_AXI_GPIO_BTN_DEVICE_ID, &DataRead);
      
      if (status == 0) {
         xil_printf("GpioInputExample PASSED. Read data:0x%X\r\n", DataRead);
      }
      else {
         print("GpioInputExample FAILED.\r\n");
      }
   }
   

 /*  {
      int Status;

      print("\r\n Running ScuTimerPolledExample() for ps7_scutimer_0...\r\n");

      Status = ScuTimerPolledExample(XPAR_PS7_SCUTIMER_0_DEVICE_ID);

      if (Status == 0) {
         print("ScuTimerPolledExample PASSED\r\n");
      }
      else {
         print("ScuTimerPolledExample FAILED\r\n");
      }
   }
   */
   {
      int Status;

      print("\r\n Running Interrupt Test  for ps7_scutimer_0...\r\n");

      Status = ScuTimerIntrExample(&intc, &ps7_scutimer_0, \
                                 XPAR_PS7_SCUTIMER_0_DEVICE_ID, \
                                 XPAR_PS7_SCUTIMER_0_INTR);

      if (Status == 0) {
         print("ScuTimerIntrExample PASSED\r\n");
      }
      else {
         print("ScuTimerIntrExample FAILED\r\n");
      }

   }
   
   {
      int Status;

      print("\r\n Running Interrupt Test  for ps7_scuwdt_0...\r\n");

      Status = ScuWdtIntrExample(&intc, &ps7_scuwdt_0, \
                                 XPAR_PS7_SCUWDT_0_DEVICE_ID, \
                                 XPAR_PS7_SCUWDT_0_INTR);

      if (Status == 0) {
         print("ScuWdtIntrExample PASSED\r\n");
      }
      else {
         print("ScuWdtIntrExample FAILED\r\n");
      }

   }
   
   {
      int Status;

      print("\r\n Running Interrupt Test  for ps7_ttc_0...\r\n");

      Status = TmrInterruptExample(&ps7_ttc_0, \
        XPAR_PS7_TTC_0_DEVICE_ID, \
        XPAR_PS7_TTC_0_INTR, &intc);

      if (Status == 0) {
         print("TtcIntrExample PASSED\r\n");
      }
      else {
         print("TtcIntrExample FAILED\r\n");
      }

   }
   
   /*
    * Peripheral Test will not be run for ps7_uart_1
    * because it has been selected as the STDOUT device
    */

   print("---Exiting main---\n\r");

   print("--- Start the SWAP test now .........\n\r");
   print("*** Software test first; using ScuTimerPolledExample() tutor for timing\n\r");
   // int Status;
   //   volatile u32 CntValue1 = 0;
   //   volatile u32 CntValue2 = 0;
   //   XScuTimer_Config *ConfigPtr;
   //   XScuTimer *TimerInstancePtr = &Timer;

      // Initialize the Scu Private Timer so that it is ready to use.
     ConfigPtr = XScuTimer_LookupConfig(DeviceId);

      // This is where the virtual address would be used, this example uses physical address.
     Status = XScuTimer_CfgInitialize(TimerInstancePtr, ConfigPtr, ConfigPtr->BaseAddr);
     if (Status != XST_SUCCESS) {
       return XST_FAILURE;
     } else { print("*** XScuTimer_CfgInitialize successful ... \r\n"); }

      // Load the timer counter register.
     XScuTimer_LoadTimer(TimerInstancePtr, TIMER_LOAD_VALUE);

      // Get a snapshot of the timer counter value before it's started to compare against later.
     Value1 = XScuTimer_GetCounterValue(TimerInstancePtr);

     // Start the Scu Private Timer device.
     XScuTimer_Start(TimerInstancePtr);

    //get timer value and compute elapsed time
    Value2 = XScuTimer_GetCounterValue(TimerInstancePtr);
    Value21 = Value1 - Value2;
    xil_printf("Value1: %d\r\n", Value1);
    xil_printf("Value2: %d\r\n", Value2);
    xil_printf("Value21: %d\r\n", Value21);
    //Value2 = XScuTimer_GetPrescaler(TimerInstancePtr);
    //xil_printf("Prescaler: %d\r\n", Value2);

    s4 =  Xil_In32(SWITCHES);
    sv= s4+((s4+1)<<4)+((s4+2)<<8)+((s4+3)<<12);

    xil_printf("*** Measure the Software BITSWAP operation ...\n");
    start_time = XScuTimer_GetCounterValue(TimerInstancePtr);
    for (k=1;k<LOOPS;k++){
        sv = SW_BITSWAP(sv);
    }
    finish_time = XScuTimer_GetCounterValue(TimerInstancePtr);
    total_time1 = start_time - finish_time; // count down to zero
    xil_printf("start_time : %d\r\n", start_time);
    xil_printf("finish_time: %d\r\n", finish_time);
    xil_printf("total_time1: %d\r\n", total_time1);

    printf("SW_BITSWAP %d cycle %d ticks\n",LOOPS,total_time1);
    printf("SW_BITSWAP %d time  %d/1000 ms\n",LOOPS,(int) total_time1/325);
    Xil_Out32(LEDR, sv);

    xil_printf("*** Measure the Custom IP BITSWAP operation ...\n");
    start_time = XScuTimer_GetCounterValue(TimerInstancePtr);
    swap = sv;
    for (k=1;k<LOOPS;k++){
      Xil_Out32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR, swap); // write to CIP
      swap =  Xil_In32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR + 4); // read from CIP
    }
    finish_time = XScuTimer_GetCounterValue(TimerInstancePtr);
    total_time2 = start_time - finish_time; // count down to zero
    xil_printf("start_time : %d\r\n", start_time);
    xil_printf("finish_time: %d\r\n", finish_time);
    xil_printf("total_time2: %d\r\n", total_time2);
    printf("CIP_BITSWAP %d cycle %d ticks\n",LOOPS,total_time2);
    printf("CIP_BITSWAP %d time  %d/1000 ms\n",LOOPS,(int) total_time2/325);
    printf("CIP_BITSWAP speedup = %d (int)\n",(int) (total_time1*1.0 /total_time2));
    printf("CIP_BITSWAP speedup = %d percent\n",(int) (100.0*total_time1/total_time2));
    xil_printf("Second counter starts\n\r");
    Value1=XScuTimer_GetCounterValue(TimerInstancePtr);
    while (seconds<5) {
      Value2 = XScuTimer_GetCounterValue(TimerInstancePtr);
      Value21 = Value1 - Value2;
      if (Value21 > 325000000){ // second count is 667/2MHz cycles per second
        Value1 = Value2;
        xil_printf("seconds=%d   ",seconds);
        seconds++;
      }
    }
    xil_printf("\n\rSecond counter ends; BITS= %d\n\r", BITS);

    sv = SW_BITSWAP(a);
    printf("SW_SWAP(%d bits) %X bits => %X\n",BITS,a,sv);
    sv = SW_BITSWAP(b);
    printf("SW_SWAP(%d bits) %X bits => %X\n",BITS,b,sv);
    Xil_Out32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR, a); // write to CIP
    swap =  Xil_In32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR + 4); // read from CIP
    printf("CIP_SWAP(%d bits) %X bits => %X\n",BITS,a,swap);
    Xil_Out32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR, b); // write to CIP
    swap =  Xil_In32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR + 4); // read from CIP
    printf("CIP_SWAP(%d bits) %X bits => %X\n",BITS,b,swap);

    while (1) { /* run forever */
       //a = *switches; /* read the Switch value*/
       //a_swap = SW_BITSWAP(a);
      //  a_swap = ALT_CI_BITSWAP(a);
      //  a_swap >>=24;
       //*leds = a_swap; /* Display on LEDs */
      sv =  Xil_In32(SWITCHES);
      Xil_Out32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR, sv); // write to CIP
      swap =  Xil_In32(XPAR_MY_SWAP_0_S00_AXI_BASEADDR + 4); // read from CIP
      Xil_Out32(LEDR, swap);
      if (old_sv!=sv) {
        old_sv=sv; print("New SW value !\n\r");
        // display the new value
        xil_printf("SW= %d; SWAP=%d \n\r",sv, swap);
      }
    }

  Xil_DCacheDisable();
  xil_ICacheDisable();
  return 0;
}
int SW_BITSWAP(int a)
{ int lsb, k, r=0;
  int t=a;
  for (k=0;k<BITS;k++)
  {
   lsb = t & 1; // take LSB
   r = r*2 + lsb; // add lsb and shift left
   t >>= 1; // shift to right by one bit
  }
  return(r);
}
