// ======================================================================
// This program demonstrates use of parallel ports in the DE1-SoC board
//
// It performs the following: 
//   1. displays the SW switch values on the red LEDR
//   2. toggle the LEDR every second
//   3. if KEY[3..0] is pressed, uses the SW switches as the pattern
// ======================================================================
#include "address_map_arm.h"
//#include "address_map_nios2.h"

//#define LEDR_BASE    0xFF200000
//#define SW_BASE      0xFF200040
//#define KEY_BASE     0xFF200050
//#define TIMER_BASE   0xFF202000
#define Fcpu         50000000 

int main(void)
{
  /* Declare volatile pointers to I/O registers (volatile means that I/O load
   * and store instructions will be used to access these pointer locations, 
   * instead of regular memory loads and stores)
  */
  volatile int *red_LED_ptr   = (int *) LEDR_BASE;  // Red LED address
  volatile int *SW_switch_ptr = (int *) SW_BASE;    // Slider switch address
  volatile int *KEY_ptr    = (int *) KEY_BASE;  // Pushbutton KEY address
  volatile int *interval_timer_ptr = (int *) TIMER_BASE; // Timer address

  int high_half, counter, User_Time=0;
  int SW_value, KEY_value;

  SW_value = *(SW_switch_ptr);       // Read the initial SW slider switch values
  while(1)  {
    /* Set the interval timer to 32 bit max */
    *(interval_timer_ptr + 1) = 0x8;  // Set STOP=1  START = 0, CONT = 0, ITO = 0  
    *(interval_timer_ptr + 0x2) = 0xFFFF;
    *(interval_timer_ptr + 0x3) = 0x7FFF;
    *(interval_timer_ptr + 1) = 0x4;  // Set START = 1, CONT = 0, ITO = 0
  
    *(red_LED_ptr) = SW_value;       // Light up the red LEDs

    KEY_value = *(KEY_ptr);          // Read the pushbutton KEY values
    if (KEY_value != 0)              // Check if any KEY was pressed
    {  SW_value = *(SW_switch_ptr);  // Read the SW slider switch values
     while (*KEY_ptr);}              // Wait for pushbutton KEY release  

    // Use the timer to find out when 500ms are over  
    User_Time=0;
    while (User_Time < 500) {
      // Make a counter snapshot by wrting a dummy value to snapl    
      *(interval_timer_ptr + 0x4) =  0;
      // Read the 32-bit counter snapshot from the 16-bit timer registers
      high_half = *(interval_timer_ptr + 0x5) & 0xFFFF;
      counter = (*(interval_timer_ptr + 0x4) & 0xFFFF) | (high_half << 16);
      // Compute User Time is in ms
      User_Time = (0x7FFFFFFF - counter) / (Fcpu/1000); // Clock cycles divided by CPU frequency
    }
    SW_value = SW_value ^ 0xFFFF; // Build complement
  }
}
