/******************************************************************************
*
* Copyright (C) 2009 - 2014 Xilinx, Inc.  All rights reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* Use of the Software is limited solely to applications:
* (a) running on a Xilinx device, or
* (b) that interact with a Xilinx device through a bus or interconnect.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* XILINX  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
* OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Except as contained in this notice, the name of the Xilinx shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Xilinx.
*
******************************************************************************/

/*
 * helloworld.c: simple test application
 *
 * This application configures UART 16550 to baud rate 9600.
 * PS7 UART (Zynq) is not initialized by this application, since
 * bootrom/bsp configures it to baud rate 115200
 *
 * ------------------------------------------------
 * | UART TYPE   BAUD RATE      |
 * ------------------------------------------------
 *   uartns550   9600
 *   uartlite    Configurable only in HW design
 *   ps7_uart    115200 (configured by bootrom/bsp)
 */

#include <stdio.h>    /* printf */

#include "platform.h"
#include "xil_printf.h"

#include "xparameters.h"
#include "xgpio.h"
#include "xtmrctr.h"
#include "xil_exception.h"
#include <math.h>     /* sqrt */
#include <stdlib.h>     /* abs */

#define INPUT_DIR  0xffffffff
#define OUTPUT_DIR 0x00000000
#define LOOP_ITERATIONS 1000000

int main()
{
XGpio buttons, leds;   // from xgpio.h struct with:
// typedef struct {
//  u32 BaseAddress;  /* Device base address */
//  u32 IsReady;    /* Device is initialized and ready */
//  int InterruptPresent;  /* Are interrupts supported in h/w */
//  int IsDual;    /* Are 2 channels supported in h/w */
//} XGpio;

// For the timer:
u16 DeviceId=XPAR_AXI_TIMER_0_DEVICE_ID;
u8 TmrCtrNumber=0;
int Status;
u32 Value1=0;
u32 Value2=0;
u32 Value21=0;
u32 seconds=0;
float j, result;
float Cscale;
XTmrCtr TimerCounter; /* The instance of the Tmrctr Device */
XTmrCtr *TmrCtrInstancePtr = &TimerCounter;

// for the buttons:
int old_buttons_state=-1;
int buttons_state, count=0;
volatile unsigned int k, i = 0;
//volatile prevents compiler optimization of empty loop

    init_platform();

    print("Hello World\n\r");
    //initialize buttons and set data direction to input
    XGpio_Initialize(&buttons, XPAR_AXI_GPIO_BTN_DEVICE_ID);
    XGpio_SetDataDirection(&buttons, 1, INPUT_DIR);

    //initialize LEDs and set data direction to output
    XGpio_Initialize(&leds, XPAR_AXI_GPIO_LED_DEVICE_ID);
    XGpio_SetDataDirection(&leds, 1, OUTPUT_DIR);

    // Get the timer ready to measure the time
    Status = XTmrCtr_Initialize(TmrCtrInstancePtr, DeviceId);
    if (Status != XST_SUCCESS) {
    return XST_FAILURE;
    } else xil_printf("XTmrCtr_Initialize passed OK !\r\n");

    Status = XTmrCtr_SelfTest(TmrCtrInstancePtr, TmrCtrNumber);
    if (Status != XST_SUCCESS) {return XST_FAILURE; }
    else xil_printf("XTmrCtr_SelfTest passed OK !\r\n");

    // Enable the Autoreload mode of the timer counters.
    XTmrCtr_SetOptions(TmrCtrInstancePtr, TmrCtrNumber, XTC_AUTO_RELOAD_OPTION);

    // Reset value for the timer counter
    XTmrCtr_SetResetValue(TmrCtrInstancePtr, TmrCtrNumber, (u32) 0);
    xil_printf("XTmrCtr_SetResetValue to zero passed OK !\r\n");

    // Reset the timer counter
    XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Reset passed OK !\r\n");

    // Start the timer counter such that it's incrementing by default
    XTmrCtr_Start(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Start passed OK !\r\n");

     // Get a snapshot of the timer counter value
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    Value21 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("1. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value1,Value1);
    // Get a snapshot of the timer counter value
    xil_printf("2. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value21,Value21);
    // wait for it to change, if since it's incrementing it should change,
    while (1) {
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      if (Value1 != Value2) {
        xil_printf("Timer Counter: %d  increments => passed OK !\r\n",TmrCtrNumber);
        xil_printf("New value is %x (hex) %d (dec) !\r\n",Value2,Value2);
        Value21 = Value2 - Value1;
        xil_printf("Difference is %x (hex) %d (dec) !\r\n",Value21,Value21);
      break;
    }
    }

    Cscale = 125.0*1000000.0;
    xil_printf("************650 MHz ARM with FP HW support AIX Timer=125MHz*************\r\n");
    /////////////////// FP add test ////////////////////////
    j = 1.3;
    result = j+j;
    Value1=result*100;
    xil_printf("add 1.3+1.3 times 100 = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
      // addition time
      result = result + j;result = result + j;result = result + j;
      result = result + j;result = result + j;result = result + j;
      result = result + j;result = result + j;result = result + j;
      result = result + j;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //get timer value
    Value21 = abs(Value2 - Value1);
    //Elapsed cycles for 10x100.0000 single precision multiplications
    xil_printf("FP Add 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP Add cycles: %d /100\r\n", (int) (100*Value21/1000000));
    xil_printf("FP Add   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K adds result: %d\r\n\r\n", (int) result);

    /////////////////// FP sub test ////////////////////////
    j = 1.3;
    result = j*2-j;
    Value1=result*100;
    xil_printf("sub 1.3*2 - 1.3 times 100 = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
    // subtraction
      result = result - j;result = result - j;result = result - j;
      result = result - j;result = result - j;result = result - j;
      result = result - j;result = result - j;result = result - j;
      result = result - j;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //get timer value
    Value21 = abs(Value2 - Value1);
    //Elapsed cycles for 10x100.0000 single precision multiplications
    xil_printf("FP Sub 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP sub cycles: %d /100\r\n", (int) (100*Value21/1000000));
    xil_printf("FP sub   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K sub result: %d\r\n\r\n", (int) result);

    /////////////////// FP Mult test ////////////////////////
    j = 1.3;
    result = j*j;
    Value1=result*100;
    xil_printf("Multiplication 1.3*1.3 times 100 = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
      //multiplication
      result = result * j;result = result * j;result = result * j;
      result = result * j;result = result * j;result = result * j;
      result = result * j;result = result * j;result = result * j;
      result = result * j;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value2 - Value1);
    //Elapsed cycles for 10x100.0000 single precision multiplications
    xil_printf("FP Mul 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP Mul cycles: %d\r\n", (int) (Value21/1000000));
    xil_printf("FP Mul   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K Multiplication result: %d\r\n\r\n", (int) result);

    /////////////////// FP Div test ////////////////////////
    j = 1.3;
    result = j * 2.0 / j;
    Value1=result*100;
    xil_printf("Div 2*1.3/1.3 times 100 = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
      // Division test
      result = result / j;result = result / j;result = result / j;
      result = result / j;result = result / j;result = result / j;
      result = result / j;result = result / j;result = result / j;
      result = result / j;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value2 - Value1);
    //Elapsed cycles for 10x100.0000 single precision multiplications
    xil_printf("FP Div 100K tics: %d\r\n", (int) Value21);
    xil_printf("FP Div cycles: %d \r\n", (int) (Value21/1000000));
    xil_printf("FP Div   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K Div result: %d\r\n\r\n", (int) result);

    XTmrCtr_SetResetValue(TmrCtrInstancePtr, TmrCtrNumber, (u32) 0);
    /////////////////// FP SQRT test ////////////////////////
    j = 4.0;
    result = j * j;
    Value1=sqrt(result);
    xil_printf("Sqrt( 4.0*4.0 )= %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
      //multiplication
      result =sqrt(result);result = sqrt(result);result = sqrt(result);
      result =sqrt(result);result = sqrt(result);result = sqrt(result);
      result =sqrt(result);result = sqrt(result);result = sqrt(result);
      result =sqrt(result);
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value1 - Value2);
    //Elapsed cycles for 10x100.0000 single precision multiplications
    xil_printf("FP sqrt 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP sqrt cycles: %d\r\n", (int) (Value21/1000000));
    xil_printf("FP sqrt   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K sqrt result: %d\r\n\r\n", (int) result);

    /////////////////// FP sqrtf test ////////////////////////
    j = 4.0;
    result =  sqrtf( j* j);
    Value1=result;
    xil_printf("Sqrtf 16  = %d\r\n",Value1);
    //start timer
       Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 100000; i++){
      //multiplication
      result = sqrtf( result );result = sqrtf( result );result = sqrtf( result );
      result = sqrtf( result );result = sqrtf( result );result = sqrtf( result );
      result = sqrtf( result );result = sqrtf( result );result = sqrtf( result );
      result = sqrtf( result );
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value1 - Value2);
    //Elapsed cycles for 10x100.0000 single precision sqrt
    xil_printf("FP sqrtf 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP sqrtf cycles: %d\r\n", (int) (Value21/1000000));
    xil_printf("FP sqrtf   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K SQRTF result: %d\r\n\r\n", (int) result);

    /////////////////// INT -> FP conversion test ////////////////////////
    i = 10;
    result =  (float ) i;
    Value1=(int) 20*result-19*result;
    xil_printf("ten 10.0  = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 1000000; i++){
      //conversion
      result = (float)  i;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value1 - Value2);
    //Elapsed cycles for 1000.0000 single precision conversion
    xil_printf("INT->FP 1000K tics: %d\r\n", (int) Value21);
    xil_printf("INT->FP cycles: %d\r\n", (int) (Value21/1000000));
    xil_printf("INT->FP   MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    printf("FP 10K INT->FP result: %d\r\n", (int) result);

    /////////////////// FP -> INT conversion test ////////////////////////
    i = 10;
    result =  (float ) i;
    Value1=(int) 20*result-19*result;
    xil_printf("ten 10.0  = %d\r\n",Value1);
    //start timer
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 1000000; i++){
      //conversion
      k = (int)  result;
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = abs(Value1 - Value2);
    //Elapsed cycles for 1000.0000 single precision conversion
    xil_printf("FP->INT 1000K tics: %d\r\n", (int) Value21);
    xil_printf("FP->INT  cycles: %d \r\n", (int) (Value21/1000000));
    xil_printf("FP->INT    MOPS: %d MSPS\r\n", (int) (Cscale/Value21));
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K FP->INT result: %d\r\n\r\n", k);

    /////////////////// Clock test ////
    xil_printf("Second counter starts\n\r");
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    while (seconds<5) {
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      Value21 = abs(Value1 - Value2);
      if (Value21 > 125000000){ // second count is 100/2MHz cycles per second
        Value1 = Value2;
        xil_printf("sec=%d \n",seconds);
        seconds++;
      }
    }

    xil_printf("\r\nSuccessfully ran XTmrCtr FP measurements on ARM\r\n");

    while(buttons_state != 1){
    //read the state of the buttons (pressed/released)
      buttons_state = XGpio_DiscreteRead(&buttons, 1);
      if (buttons_state!=old_buttons_state) {
        xil_printf("Buttons State is: %x\r\n", buttons_state);
        Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
        Value21 = Value1 - Value2;
        xil_printf("sec=%d ",(int) Value21);
      }
      old_buttons_state=buttons_state;
      XGpio_DiscreteWrite(&leds, 1, buttons_state);
      count+=1;
      //waiting for some time
      for(i = 0; i < LOOP_ITERATIONS*100; i++){}
    }

    return 0;
    }

