#include <stdio.h>      /* xil_printf */
#include "xparameters.h"
#include "xil_cache.h"
#include "xgpio.h"
#include "xtmrctr.h"
#include <math.h>       /* sqrt */
#include <stdlib.h>     /* abs */
#include "hdmi_util.h"

#define INPUT_DIR	0xffffffff
#define OUTPUT_DIR 0x00000000
#define LOOP_ITERATIONS 200000

int main()
{
XGpio leds;   // from xgpio.h struct with:
// typedef struct {
//	u32 BaseAddress;	/* Device base address */
//	u32 IsReady;		/* Device is initialized and ready */
//	int InterruptPresent;	/* Are interrupts supported in h/w */
//	int IsDual;		/* Are 2 channels supported in h/w */
//} XGpio;

// For HMDI
char str[80];
int line=2;

// For the timer:
u16 DeviceId=XPAR_AXI_TIMER_0_DEVICE_ID;
u8 TmrCtrNumber=0;
int Status;
u32 Value1=0;
u32 Value2=0;
u32 Value21=0;
u32 seconds=0;
float j, result;
//float Tscale, Cscale;
XTmrCtr TimerCounter; /* The instance of the Tmrctr Device */

XTmrCtr *TmrCtrInstancePtr = &TimerCounter;

// for the buttons:
volatile unsigned int k, i = 0;
//volatile prevents compiler optimization of empty loop

//init_platform();

    xil_printf("=== Hello current and possible future MicroBlaze lovers ===\n");

    //initialize LEDs and set data direction to output
    XGpio_Initialize(&leds, XPAR_AXI_GPIO_LEDS_DEVICE_ID);
    XGpio_SetDataDirection(&leds, 1, OUTPUT_DIR);

    // Get the timer ready to measure the time
    Status = XTmrCtr_Initialize(TmrCtrInstancePtr, DeviceId);
    if (Status != XST_SUCCESS) {
    	return XST_FAILURE;
    } else xil_printf("XTmrCtr_Initialize passed OK !\r\n");

    Status = XTmrCtr_SelfTest(TmrCtrInstancePtr, TmrCtrNumber);
    if (Status != XST_SUCCESS) {return XST_FAILURE; }
    else xil_printf("XTmrCtr_SelfTest passed OK !\r\n");

    // Enable the Autoreload mode of the timer counters.
    XTmrCtr_SetOptions(TmrCtrInstancePtr, TmrCtrNumber, XTC_AUTO_RELOAD_OPTION);

    // Reset value for the timer counter
    XTmrCtr_SetResetValue(TmrCtrInstancePtr, TmrCtrNumber, (u32) 0);
    xil_printf("XTmrCtr_SetResetValue to zero passed OK !\r\n");

    // Reset the timer counter
    XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Reset passed OK !\r\n");

    // Start the timer counter such that it's incrementing by default
    XTmrCtr_Start(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Start passed OK !\r\n");

     // Get a snapshot of the timer counter value
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    Value21 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("1. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value1,Value1);
    // Get a snapshot of the timer counter value
    xil_printf("2. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value21,Value21);
    // wait for it to change, if since it's incrementing it should change,
    while (1) {
    	Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    	if (Value1 != Value2) {
    		xil_printf("Timer Counter: %d  increments => passed OK !\r\n",TmrCtrNumber);
    		xil_printf("New value is %x (hex) %d (dec) !\r\n",Value2,Value2);
    		Value21 = Value2 - Value1;
    		xil_printf("Difference is %x (hex) %d (dec) !\r\n",Value21,Value21);
    		break;
    	}
    }

    //Tscale = 1.0/(10.0*10000.0);
    //Cscale = 1.0/(10.0*10000.0);
    HDMI_cls(20); // clear screen 20 lines
    sprintf(str, "=== MicroBlaze no FP HW;XTM=125MHz T=8ns ===\0");
    xil_printf("%s\n",str);
    HDMI_text (4, line++, str); // print next line

      // ============ FP add test ============
      j = 1.3;
      result = j + j;
      Value1=result*100;
      xil_printf("add 1.3+1.3 times 100 = %d\r\n",Value1);
      //start timer at 0
      XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
      Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      for(i = 0; i < 10000; i++){
      result = result + j;result = result + j;result = result + j;
      result = result + j;result = result + j;result = result + j;
      result = result + j;result = result + j;result = result + j;
      result = result + j;
      }
      //stop timer
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      //get timer value
      Value21 = Value2 - Value1;
      //Elapsed cycles for 10x10.000 single precision additions
      xil_printf("FP Add 100K tics: %d\r\n", (int) Value21);
      sprintf(str,"FP Add cycles: %d\0", (int) Value21/100000);
      xil_printf("%s\n",str);
      HDMI_text (4, line++, str); // print next line
      //Note: this output is required otherwise loop is optimized by compiler
      xil_printf("FP 10K adds result: %d\r\n\r\n", (int) result);

      // ============ FP sub test ============
      j = 1.3;
      result = j*2-j;
      Value1=result*100;
      xil_printf("sub 1.3*2 - 1.3 times 100 = %d\r\n",Value1);
      //start timer at 0
      XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
      Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      for(i = 0; i < 10000; i++){
      //multiplication
      result = result - j;result = result - j;result = result - j;
      result = result - j;result = result - j;result = result - j;
      result = result - j;result = result - j;result = result - j;
      result = result - j;
      }
      //stop timer
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      //get timer value
      Value21 = Value2 - Value1;
      //Elapsed cycles for 10x10.000 single precision subtractionss
      xil_printf("FP Sub 100K tics: %d\r\n", (int) Value21);
      sprintf(str,"FP Sub cycles: %d\0", (int) Value21/100000);
      xil_printf("%s\n",str);
      HDMI_text (4, line++, str); // print next line
      //Note: this output is required otherwise loop is optimized by compiler
      xil_printf("FP 10K sub result: %d\r\n\r\n", (int) result);

      // ============ FP Mult test ============
      j = 1.3;
      result = j*j;
      Value1=result*100;
      xil_printf("Multiplication 1.3*1.3 times 100 = %d\r\n",Value1);
      //start timer at 0
      XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
      Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      for(i = 0; i < 10000; i++){
      //multiplication
      result = result * j;result = result * j;result = result * j;
      result = result * j;result = result * j;result = result * j;
      result = result * j;result = result * j;result = result * j;
      result = result * j;
      }
      //stop timer
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      //TODO get timer value
      Value21 = Value2 - Value1;
      //Elapsed cycles for 10x10.000 single precision multiplications
      xil_printf("FP Mul 100K tics: %d\r\n", (int) Value21);
      sprintf(str,"FP Mul cycles: %d\0", (int) Value21/100000);
      xil_printf("%s\n",str);
      HDMI_text (4, line++, str); // print next line
      //Note: this output is required otherwise loop is optimized by compiler
      xil_printf("FP 10K Multiplication result: %d\r\n\r\n", (int) result);

      // ============ FP Div test ============
      j = 1.3;
      result = j * 2.0 / j;
      Value1=result*100;
      xil_printf("Div 2*1.3/1.3 times 100 = %d\r\n",Value1);
      //start timer at 0
      XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
      Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      for(i = 0; i < 10000; i++){
      //multiplication
      result = result / j;result = result / j;result = result / j;
      result = result / j;result = result / j;result = result / j;
      result = result / j;result = result / j;result = result / j;
      result = result / j;
      }
      //stop timer
      Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
      //TODO get timer value
      Value21 = Value2 - Value1;
      //Elapsed cycles for 10x10.0000 single precision divides
      xil_printf("FP Div 100K tics: %d\r\n", (int) Value21);
      sprintf(str,"FP Div cycles: %d\0", (int) Value21/100000);
      xil_printf("%s\n",str);
      HDMI_text (4, line++, str); // print next line
      //Note: this output is required otherwise loop is optimized by compiler
      xil_printf("FP 10K Div result: %d\r\n\r\n", (int) result);

      // ============ FP SQRT test ============
    j = 4.0;
    result = j * j;
    Value1=sqrt(result);
    xil_printf("Sqrt( 4.0*4.0 )= %d\r\n",Value1);
    //start timer at 0
    XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    for(i = 0; i < 1000; i++){
    //multiplication
    result =sqrt(result);result = sqrt(result);result = sqrt(result);
    result =sqrt(result);result = sqrt(result);result = sqrt(result);
    result =sqrt(result);result = sqrt(result);result = sqrt(result);
    result =sqrt(result);
    }
    //stop timer
    Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    //TODO get timer value
    Value21 = Value2 - Value1;
    //Elapsed cycles for 10x1.000 double precision square roots
    xil_printf("FP sqrt 10K tics: %d\r\n", (int) Value21);
    sprintf(str,"FP sqrt cycles: %d\0", (int) Value21/10000);
    xil_printf("%s\n",str);
    HDMI_text (4, line++, str); // print next line
    //Note: this output is required otherwise loop is optimized by compiler
    xil_printf("FP 10K sqrt result: %d\r\n\r\n", (int) result);

    // ============ FP sqrtf test ============
        j = 4.0;
        result =  sqrtf( j* j);
        Value1=result;
        xil_printf("Sqrtf 16  = %d\r\n",Value1);
        //start timer at 0
        XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
        Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
        for(i = 0; i < 1000; i++){
        //multiplication
        result = sqrtf( result ); result = sqrtf( result );result = sqrtf( result );
        result = sqrtf( result );result = sqrtf( result );result = sqrtf( result );
        result = sqrtf( result );result = sqrtf( result );result = sqrtf( result );
        result = sqrtf( result );
        }
        //stop timer
        Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
        //TODO get timer value
        Value21 = Value2 - Value1;
        //Elapsed cycles for 10x1.000 single precision sqrt
        xil_printf("FP sqrtf 10K tics: %d\r\n", (int) Value21);
        sprintf(str,"FP sqrtf cycles: %d\0", (int) Value21/10000);
        xil_printf("%s\n",str);
        HDMI_text (4, line++, str); // print next line
        //Note: this output is required otherwise loop is optimized by compiler
        xil_printf("FP 10K SQRTF result: %d\r\n\r\n", (int) result);

        // ============ INT -> FP conversion test ============
        i = 10;
        result =  (float ) i;
        Value1=(int) 20*result-19*result;
        xil_printf("ten 10.0  = %d\r\n",Value1);
        //start timer at 0
        XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
        Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
        for(i = 0; i < 10000; i++){
        //conversion
        result = (float)  i;
        }
        //stop timer
        Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
        //TODO get timer value
        Value21 = Value2 - Value1;
        //Elapsed cycles for 10.0000 single precision conversion
        xil_printf("INT->FP 10K tics: %d\r\n", (int) Value21);
        sprintf(str,"INT->FP cycles: %d\0", (int) Value21/10000);

        xil_printf("%s\n",str);
        HDMI_text (4, line++, str); // print next line
        //Note: this output is required otherwise loop is optimized by compiler
        xil_printf("FP 10K INT->FP result: %d\r\n", (int) result);

        // ============FP -> INT conversion test ============
          i = 10;
          result =  (float ) i;
          Value1=(int) 20*result-19*result;
          xil_printf("ten 10.0  = %d\r\n",Value1);
          //start timer at 0
          XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
          Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
          for(i = 0; i < 10000; i++){
          //conversion
          k = (int)  result;
          }
          //stop timer
          Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
          //TODO get timer value
          Value21 = Value2 - Value1;
          //Elapsed cycles for 10.0000 single precision conversion
          xil_printf("FP->INT 10K tics: %d\r\n", (int) Value21);
          sprintf(str,"FP->INT cycles: %d\0", (int) Value21/10000);
          xil_printf("%s\n",str);
          HDMI_text (4, line++, str); // print next line
          //Note: this output is required otherwise loop is optimized by compiler
          xil_printf("FP 10K FP->INT result: %d\r\n\r\n", k);

          // ============ Clock test ////
          xil_printf("Second counter starts\n\r");
          //start timer at 0
          XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
          Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
          while (seconds<5) {
          Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
         	  Value21 = abs(Value1 - Value2);
         	  if (Value21 > 125000000){ // second count is 125MHz cycles per second
         		 Value1 = Value2;
         	     xil_printf("sec=%d \n",seconds);
         	     seconds++;
            }
          }

      	xil_printf("\r\nSuccessfully ran XTmrCtr FP measurements on MicroBlaze\r\n");

    return 0;
    }
