/*
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A 
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR 
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION 
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE 
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO 
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO 
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE 
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * 
 *
 * This file is a generated sample test application.
 *
 * This application is intended to test and/or illustrate some 
 * functionality of your system.  The contents of this file may
 * vary depending on the IP in your system and may use existing
 * IP driver functions.  These drivers will be generated in your
 * SDK application project when you run the "Generate Libraries" menu item.
 *
 */

#include <stdio.h>
#include "xparameters.h"
#include "xil_cache.h"
#include "xgpio.h"
#include "gpio_header.h"
#include "xtmrctr.h"
#include "tmrctr_header.h"


#define LEDR XPAR_AXI_GPIO_LEDS_BASEADDR
#define SWITCHES XPAR_AXI_GPIO_SW_BASEADDR
#define HDMI XPAR_MY_HDMI_CIP_0_S00_AXI_BASEADDR
#define mask0 0x000000FF
#define mask1 0x0000FF00
#define mask2 0x00FF0000
#define mask3 0xFF000000

char banner[40]    = "*** ZyBo HDMI Computer by UMB ***\0";
/* Function prototypes */
void HDMI_text (int, int, char *);
void HDMI_cls(int);

int main() 
{

  int num=0;
  volatile int i;
  u32 old_sv, sv, x, y, w0, w1, w2, w3, val;

  char buffer [50];
  int n, a=5, b=3;


	Xil_ICacheEnable();
   Xil_DCacheEnable();
   print("---Entering main---\n\r");
   

   {
      u32 status;
      
      print("\r\nRunning GpioOutputExample() for axi_gpio_leds...\r\n");

      status = GpioOutputExample(XPAR_AXI_GPIO_LEDS_DEVICE_ID,4);
      
      if (status == 0) {
         print("GpioOutputExample PASSED.\r\n");
      }
      else {
         print("GpioOutputExample FAILED.\r\n");
      }
   }
   

   {
      u32 status;
      
      print("\r\nRunning GpioInputExample() for axi_gpio_sw...\r\n");

      u32 DataRead;
      
      status = GpioInputExample(XPAR_AXI_GPIO_SW_DEVICE_ID, &DataRead);
      
      if (status == 0) {
         xil_printf("GpioInputExample PASSED. Read data:0x%X\r\n", DataRead);
      }
      else {
         print("GpioInputExample FAILED.\r\n");
      }
   }
   

   {
      int status;
      
      print("\r\n Running TmrCtrSelfTestExample() for axi_timer_0...\r\n");
      
      status = TmrCtrSelfTestExample(XPAR_AXI_TIMER_0_DEVICE_ID, 0x0);
      
      if (status == 0) {
         print("TmrCtrSelfTestExample PASSED\r\n");
      }
      else {
         print("TmrCtrSelfTestExample FAILED\r\n");
      }
   }
   
   /*
    * Peripheral SelfTest will not be run for axi_uartlite_0
    * because it has been selected as the STDOUT device
    */

   print("*** Test the HDMI communication:\n");
   while(num<1000){
     if(num == 16)
       num = 0;
     else
       num++;

     Xil_Out32(LEDR, num);

     for(i=0;i<125000000/9; i++); // 125_000_000 MHz CPU clock loop takes ca. 9 cycles

     sv =  Xil_In32(SWITCHES);
     if (old_sv != sv) {
       old_sv=sv; xil_printf("New SW value : \n\r");
       xil_printf("%d\n\r", sv);
     }
     sv = num << 4; // shift left by 4
     Xil_Out32(HDMI, sv);
     xil_printf("Num/second value : %d\n",num);
   }

   print("*** Try the sprintf() for HDMI monitor...\n");
   n=sprintf (buffer, "%d plus %d is %d", a, b, a+b);
   printf ("[%s] is a string %d chars long\n",buffer,n);

   print("*** Try to print something new text at HDMI monitor...\n");
   for (y=0;y<6;y++)
     for (x=0;x<80;x++) {
       sv =  Xil_In32(SWITCHES);     //color =BW=00; serif font= SC=01;
       w0= mask0 & ((sv << 4) + 8);  //  set WE=1
       w1= mask1 & (x << 8);
       w2= mask2 & (y << 16);
       i=x+y+48;
       w3= mask3 & (i << 24); // Char ASCII 0=48 dec
       val= w3 + w2 + w1 + w0;
       Xil_Out32(HDMI, val);
       for(i=0;i<(125000000/9)/30; i++); // wait 1sec/60 Hz
     }

    HDMI_cls(60);
    print("*** Print two lines on HDMI monitor...\n");
    HDMI_text (34, 3, banner);
    HDMI_text (34, 4, buffer);
    Xil_DCacheDisable();
    Xil_ICacheDisable();
    return 0;
 }
 //====================================================================
 // Subroutine to send a string of text to the HDMI monitor
 //====================================================================
 void HDMI_text(int x, int y, char *text_ptr)
 {
   volatile int i;
   u32 sv, w0, w1, w2, w3, val, xx=x;

   /* assume that the text string fits on one line */
   while ( *(text_ptr) ) {
     sv =  Xil_In32(SWITCHES);     // sv= color + font
     w0= mask0 & ((sv << 4) + 8);  // set WE=1
     w1= mask1 & (xx << 8);
     w2= mask2 & (y << 16);
     i = *(text_ptr);  // print one char at a time
     text_ptr++;
     w3= mask3 & (i << 24); // Char ASCII 0=48 dec
     val= w3 + w2 + w1 + w0;
     Xil_Out32(HDMI, val);
     xx++;
     for(i=0;i<(125000000/9)/30; i++); // wait WE 1sec/30 Hz
   }
 }
 //===================================================================
 // Subroutine to clear the first ymax lines; add banner to monitor
 //===================================================================
 void HDMI_cls(int ymax)
 {
   volatile int i;
   u32 sv, w0, w1, w2, w3, val, x, y;

   for (y=0;y<ymax;y++)
     for (x=0;x<80;x++) {
       sv =  Xil_In32(SWITCHES);     // serif font= SW=01;
       w0= mask0 & ((sv << 4) + 8);  // color =BW=00; set WE=1
       w1= mask1 & (x << 8);
       w2= mask2 & (y << 16);
       if ((x==0)||(x==79)||(y==0)||(y==59))
         i=banner[(x+y)%32];
       else
         i=32; // space char dec=32
       w3= mask3 & (i << 24); // Char ASCII 0=48 dec
       val= w3 + w2 + w1 + w0;
       Xil_Out32(HDMI, val);
       for(i=0;i<(125000000/9)/30; i++); // wait 1sec/60 Hz
    }
 }

