//*********************************************************
// IEEE STD 1364-2001 Verilog file: char_rom.v 
// Author-EMAIL: Uwe.Meyer-Baese@ieee.org
//*********************************************************
// Initialize the ROM with $readmemb. For Vivado
// use the MIF files extension. Without this file,
// this design will not compile. See Verilog 
// LRM 1364-2001 Section 17.2.8 for details on the
// format of this file.
module char_rom
#(parameter DATA_WIDTH=8, parameter ADDR_WIDTH=10)
  (input  CLK,                       // System clock
   input [1:0] SW, // Font selection
   input [6:0] ADDRESS, // Address input
   input [2:0] ROW, COL, // row/column address 
   output wire Q); // Data output single bit
// --------------------------------------------------------
// Declare the ROM variable
  reg [DATA_WIDTH-1:0] rom0[2**ADDR_WIDTH-1:0];
  reg [DATA_WIDTH-1:0] rom1[2**ADDR_WIDTH-1:0];
  reg [DATA_WIDTH-1:0] rom2[2**ADDR_WIDTH-1:0];
  reg [DATA_WIDTH-1:0] rom3[2**ADDR_WIDTH-1:0];  
  reg [DATA_WIDTH-1:0] word0,word1,word2,word3,word;
  wire [ADDR_WIDTH-1:0] address_row;
  reg [2:0] col_d, col_dd;
  initial
  begin
    $readmemb("char_table_myAPEAUS.mif", rom0); // Arial san serif font
    $readmemb("char_table_myHERCULES.mif", rom1); // Times serif font
    $readmemb("char_table_myHERCITAL.mif", rom2); // Italic Times serif font
    $readmemb("char_table_mySPACE8.mif", rom3); // Fun/SPACE type font
  end
  
  assign address_row = {ADDRESS , ROW}; // concardination for table address

  always @ (posedge CLK)  begin// read table value
    word0 <= rom0[address_row];
    word1 <= rom1[address_row];
    word2 <= rom2[address_row];
    word3 <= rom3[address_row];
  end
   
   always @* 
     case (SW[1:0])
      2'b00   :  word <= word0;
      2'b01   :  word <= word1;
      2'b10   :  word <= word2;
      default :  word <= word3;
    endcase       
      
  always @ (posedge CLK) begin // delay for column values
      col_d <= COL;
      col_dd <= col_d;
  end

  // pick the bit needed
  assign Q = word[~col_dd];

endmodule
