/* 
 ****************************************************************************
 *
 *                   "DHRYSTONE" Benchmark Program
 *                   -----------------------------
 *
 *  Version:    C, Version 2.1
 *
 *  File:       dhry_1.c (part 2 of 3)
 *
 *  Date:       May 25, 1988
 *
 *  Author:     Reinhold P. Weicker
 *
 ****************************************************************************
 */

#include "dhry.h"
#include "xparameters.h"
#include "platform.h"
#include <stdio.h> /* for xil_printf */
#include <stdlib.h>     /* malloc, free, rand */
#include <string.h>     /* strcpy */
#include "xgpio.h"
#include "xtmrctr.h"
#include "xil_io.h"
#include "xil_types.h"
#include "hdmi_util.h"

/* Global Variables: */

Rec_Pointer     Ptr_Glob,
                Next_Ptr_Glob;
int             Int_Glob;
Boolean         Bool_Glob;
char            Ch_1_Glob,
                Ch_2_Glob;
int             Arr_1_Glob [50];
int             Arr_2_Glob [50] [50];

  /* forward declaration necessary since Enumeration may not simply be int */

#ifndef REG
        Boolean Reg = false;
#define REG
        /* REG becomes defined as empty */
        /* i.e. no register variables   */
#else
        Boolean Reg = true;
#endif

#ifdef NO_MALLOC
Rec_Type tmp_var1, tmp_var2;
#endif

// Needed for the timer is 2 seconds or 2000 ms
#define Too_Small_Time 2000
                /* Measurements should last at least 2000 ms */

/* Function Prototypes */
void Proc_1 (Rec_Pointer);
void Proc_2 (One_Fifty *);
void Proc_3 (Rec_Pointer *);
void Proc_4 ();
void Proc_5 ();
void Proc_6 (Enumeration, Enumeration *);
void Proc_7 (One_Fifty , One_Fifty , One_Fifty *);
void Proc_8 (Arr_1_Dim, Arr_2_Dim, int , int);

Enumeration Func_1 (Capital_Letter, Capital_Letter);
Boolean Func_2 (Str_30 , Str_30 );
Boolean Func_3 (Enumeration);


int main ()
{

   	//int Value1, Value2, Value21;
    //int seconds=0;
    int    Begin_Time, End_Time, User_Time;
    float  Nanoseconds, Dhrystones_Per_Second, Vax_Mips;

	// For HMDI
	char str[80];
	//int line=2;


	// For the timer:
	u16 DeviceId=XPAR_AXI_TIMER_0_DEVICE_ID;
	u8 TmrCtrNumber=0;
	int Status;
	u32 Value1=0;
	u32 Value2=0;
	u32 Value21=0;
	//float Tscale, Cscale;
	XTmrCtr TimerCounter; /* The instance of the Tmrctr Device */
	XTmrCtr *TmrCtrInstancePtr = &TimerCounter;


  /* main program, corresponds to procedures        */
  /* Main and Proc_0 in the Ada version             */

        One_Fifty       Int_1_Loc;
  REG   One_Fifty       Int_2_Loc;
        One_Fifty       Int_3_Loc;
  REG   char            Ch_Index;
        Enumeration     Enum_Loc;
        Str_30          Str_1_Loc;
        Str_30          Str_2_Loc;
  REG   int             Run_Index;
  REG   int             Number_Of_Runs;

  /* Initializations */
  init_platform();

#ifdef NO_MALLOC
  Next_Ptr_Glob = (Rec_Pointer) &tmp_var1;
  Ptr_Glob = (Rec_Pointer) &tmp_var2;
#else
  Next_Ptr_Glob = (Rec_Pointer) malloc (sizeof (Rec_Type));
  Ptr_Glob = (Rec_Pointer) malloc (sizeof (Rec_Type));
#endif

  Ptr_Glob->Ptr_Comp                    = Next_Ptr_Glob;
  Ptr_Glob->Discr                       = Ident_1;
  Ptr_Glob->variant.var_1.Enum_Comp     = Ident_3;
  Ptr_Glob->variant.var_1.Int_Comp      = 40;
  strcpy (Ptr_Glob->variant.var_1.Str_Comp,
          "DHRYSTONE PROGRAM, SOME STRING");
  strcpy (Str_1_Loc, "DHRYSTONE PROGRAM, 1'ST STRING");

  Arr_2_Glob [8][7] = 10;
        /* Was missing in published program. Without this statement,    */
        /* Arr_2_Glob [8][7] would have an undefined value.             */
        /* Warning: With 16-Bit processors and Number_Of_Runs > 32000,  */
        /* overflow may occur for this array element.                   */

  xil_printf ("\n");
  xil_printf ("Dhrystone Benchmark, Version 2.1 (Language: C)\n");
  xil_printf ("\n");
  if (Reg)
  {
    xil_printf ("Program compiled with 'register' attribute\n");
    xil_printf ("\n");
  }
  else
  {
    xil_printf ("Program compiled without 'register' attribute\n");
    xil_printf ("\n");
  }
  //xil_printf ("Please give the number of runs through the benchmark: ");
 // {
  //  int n;
  //  scanf ("%d", &n);
  //  Number_Of_Runs = n;
 // }
  // xil_printf ("\n");
  Number_Of_Runs = 150000;
  xil_printf ("Execution starts, %d runs through Dhrystone\n", Number_Of_Runs);

  /***************/
  /* Start timer */
  /***************/
    // Get the timer ready to measure the time
    Status = XTmrCtr_Initialize(TmrCtrInstancePtr, DeviceId);
    if (Status != XST_SUCCESS) {
    	return XST_FAILURE;
    } else xil_printf("XTmrCtr_Initialize passed OK !\r\n");

    Status = XTmrCtr_SelfTest(TmrCtrInstancePtr, TmrCtrNumber);
    if (Status != XST_SUCCESS) {return XST_FAILURE; }
    else xil_printf("XTmrCtr_SelfTest passed OK !\r\n");

    // Enable the Autoreload mode of the timer counters.
    XTmrCtr_SetOptions(TmrCtrInstancePtr, TmrCtrNumber, XTC_AUTO_RELOAD_OPTION);

    // Reset value for the timer counter
    XTmrCtr_SetResetValue(TmrCtrInstancePtr, TmrCtrNumber, (u32) 0);
    xil_printf("XTmrCtr_SetResetValue to zero passed OK !\r\n");

    // Reset the timer counter
    XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Reset passed OK !\r\n");

    // Start the timer counter such that it's incrementing by default
    XTmrCtr_Start(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("XTmrCtr_Start passed OK !\r\n");

     // Get a snapshot of the timer counter value
    Value1 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    Value21 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    xil_printf("1. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value1,Value1);
    // Get a snapshot of the timer counter value
    xil_printf("2. XTmrCtr_GetValue gives = %x (hex)= %d (dec)\r\n",Value21,Value21);
    // wait for it to change, if since it's incrementing it should change,
    while (1) {
    	Value2 = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);
    	if (Value1 != Value2) {
    		xil_printf("Timer Counter: %d  increments => passed OK !\r\n",TmrCtrNumber);
    		xil_printf("New value is %x (hex) %d (dec) !\r\n",Value2,Value2);
    		Value21 = Value2 - Value1;
    		xil_printf("Difference is %x (hex) %d (dec) !\r\n",Value21,Value21);
    		break;
    	}
    }
   xil_printf("\n\rSecond counter ends\n\r");
   
   //start timer at 0
   XTmrCtr_Reset(TmrCtrInstancePtr, TmrCtrNumber);
  Begin_Time = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);

  // XScuTimer_LoadTimer(TimerInstancePtr, TIMER_LOAD_VALUE);
  // Begin_Time  = XScuTimer_GetCounterValue(TimerInstancePtr);

  for (Run_Index = 1; Run_Index <= Number_Of_Runs; ++Run_Index)
  {

    Proc_5();
    Proc_4();
      /* Ch_1_Glob == 'A', Ch_2_Glob == 'B', Bool_Glob == true */
    Int_1_Loc = 2;
    Int_2_Loc = 3;
    strcpy (Str_2_Loc, "DHRYSTONE PROGRAM, 2'ND STRING");
    Enum_Loc = Ident_2;
    Bool_Glob = ! Func_2 (Str_1_Loc, Str_2_Loc);
      /* Bool_Glob == 1 */
    while (Int_1_Loc < Int_2_Loc)  /* loop body executed once */
    {
      Int_3_Loc = 5 * Int_1_Loc - Int_2_Loc;
        /* Int_3_Loc == 7 */
      Proc_7 (Int_1_Loc, Int_2_Loc, &Int_3_Loc);
        /* Int_3_Loc == 7 */
      Int_1_Loc += 1;
    } /* while */
      /* Int_1_Loc == 3, Int_2_Loc == 3, Int_3_Loc == 7 */
    Proc_8 (Arr_1_Glob, Arr_2_Glob, Int_1_Loc, Int_3_Loc);
      /* Int_Glob == 5 */
    Proc_1 (Ptr_Glob);
    for (Ch_Index = 'A'; Ch_Index <= Ch_2_Glob; ++Ch_Index)
                             /* loop body executed twice */
    {
      if (Enum_Loc == Func_1 (Ch_Index, 'C'))
          /* then, not executed */
        {
        Proc_6 (Ident_1, &Enum_Loc);
        strcpy (Str_2_Loc, "DHRYSTONE PROGRAM, 3'RD STRING");
        Int_2_Loc = Run_Index;
        Int_Glob = Run_Index;
        }
    }
      /* Int_1_Loc == 3, Int_2_Loc == 3, Int_3_Loc == 7 */
    Int_2_Loc = Int_2_Loc * Int_1_Loc;
    Int_1_Loc = Int_2_Loc / Int_3_Loc;
    Int_2_Loc = 7 * (Int_2_Loc - Int_3_Loc) - Int_1_Loc;
      /* Int_1_Loc == 1, Int_2_Loc == 13, Int_3_Loc == 7 */
    Proc_2 (&Int_1_Loc);
      /* Int_1_Loc == 5 */

  } /* loop "for Run_Index" */

  /**************/
  /* Stop timer */
  /**************/
  //End_Time = XScuTimer_GetCounterValue(TimerInstancePtr);
      //stop timer
  End_Time  = XTmrCtr_GetValue(TmrCtrInstancePtr, TmrCtrNumber);  

  xil_printf ("Execution ends\n");
  xil_printf ("\n");
  xil_printf ("Final values of the variables used in the benchmark:\n");
  xil_printf ("\n");
  xil_printf ("Int_Glob:            %d\n", Int_Glob);
  xil_printf ("        should be:   %d\n", 5);
  xil_printf ("Bool_Glob:           %d\n", Bool_Glob);
  xil_printf ("        should be:   %d\n", 1);
  xil_printf ("Ch_1_Glob:           %c\n", Ch_1_Glob);
  xil_printf ("        should be:   %c\n", 'A');
  xil_printf ("Ch_2_Glob:           %c\n", Ch_2_Glob);
  xil_printf ("        should be:   %c\n", 'B');
  xil_printf ("Arr_1_Glob[8]:       %d\n", Arr_1_Glob[8]);
  xil_printf ("        should be:   %d\n", 7);
  xil_printf ("Arr_2_Glob[8][7]:    %d\n", Arr_2_Glob[8][7]);
  xil_printf ("        should be:   Number_Of_Runs + 10\n");
  xil_printf ("Ptr_Glob->\n");
  xil_printf ("  Ptr_Comp:          %d\n", (int) Ptr_Glob->Ptr_Comp);
  xil_printf ("        should be:   (implementation-dependent)\n");
  xil_printf ("  Discr:             %d\n", Ptr_Glob->Discr);
  xil_printf ("        should be:   %d\n", 0);
  xil_printf ("  Enum_Comp:         %d\n", Ptr_Glob->variant.var_1.Enum_Comp);
  xil_printf ("        should be:   %d\n", 2);
  xil_printf ("  Int_Comp:          %d\n", Ptr_Glob->variant.var_1.Int_Comp);
  xil_printf ("        should be:   %d\n", 17);
  xil_printf ("  Str_Comp:          %s\n", Ptr_Glob->variant.var_1.Str_Comp);
  xil_printf ("        should be:   DHRYSTONE PROGRAM, SOME STRING\n");
  xil_printf ("Next_Ptr_Glob->\n");
  xil_printf ("  Ptr_Comp:          %d\n", (int) Next_Ptr_Glob->Ptr_Comp);
  xil_printf ("        should be:   (implementation-dependent), same as above\n");
  xil_printf ("  Discr:             %d\n", Next_Ptr_Glob->Discr);
  xil_printf ("        should be:   %d\n", 0);
  xil_printf ("  Enum_Comp:         %d\n", Next_Ptr_Glob->variant.var_1.Enum_Comp);
  xil_printf ("        should be:   %d\n", 1);
  xil_printf ("  Int_Comp:          %d\n", Next_Ptr_Glob->variant.var_1.Int_Comp);
  xil_printf ("        should be:   %d\n", 18);
  xil_printf ("  Str_Comp:          %s\n",
                                Next_Ptr_Glob->variant.var_1.Str_Comp);
  xil_printf ("        should be:   DHRYSTONE PROGRAM, SOME STRING\n");
  xil_printf ("Int_1_Loc:           %d\n", Int_1_Loc);
  xil_printf ("        should be:   %d\n", 5);
  xil_printf ("Int_2_Loc:           %d\n", Int_2_Loc);
  xil_printf ("        should be:   %d\n", 13);
  xil_printf ("Int_3_Loc:           %d\n", Int_3_Loc);
  xil_printf ("        should be:   %d\n", 7);
  xil_printf ("Enum_Loc:            %d\n", Enum_Loc);
  xil_printf ("        should be:   %d\n", 1);
  xil_printf ("Str_1_Loc:           %s\n", Str_1_Loc);
  xil_printf ("        should be:   DHRYSTONE PROGRAM, 1'ST STRING\n");
  xil_printf ("Str_2_Loc:           %s\n", Str_2_Loc);
  xil_printf ("        should be:   DHRYSTONE PROGRAM, 2'ND STRING\n");
  xil_printf ("\n");

  User_Time = abs(Begin_Time - End_Time)/125000; // in ms for 125 MHz processor
  xil_printf("Begin_Time Ticks: %d\n", Begin_Time);
  xil_printf("End_Time Ticks: %d\n", End_Time);
  sprintf(str, "User_Time: %d ms", User_Time);
  xil_printf("%s\n",str);
  HDMI_cls(10); // clear screen
  HDMI_text (4, 2, str);

  if (User_Time < Too_Small_Time)
  {
    xil_printf ("Measured time too small to obtain meaningful results\n");
    sprintf(str,"Please increase number of runs to %d\0",(int) Too_Small_Time/User_Time*Number_Of_Runs);
    xil_printf("%s\n",str);
    HDMI_text (4, 1, str);
  }
  else
  {
    Nanoseconds = (float) User_Time * Mic_secs_Per_Second * 1.0
                        / (float) Number_Of_Runs;
    Dhrystones_Per_Second = (float) Number_Of_Runs / (User_Time * 0.001);
    Vax_Mips = Dhrystones_Per_Second / 1757.0;

    sprintf(str, "Time one run through Dhrystone: %d ns", (int) Nanoseconds);
    xil_printf("%s\n",str); HDMI_text (4, 3, str);
    sprintf(str,"Dhrystones per Second: %d", (int) Dhrystones_Per_Second);
    xil_printf("%s\n",str); HDMI_text(4, 4, str);
    sprintf(str,"VAX DMIPS rating = %d",(int) Vax_Mips);
    xil_printf("%s\n",str); HDMI_text(4, 5, str);
    sprintf(str,"Runs = %d",Number_Of_Runs);
    xil_printf("%s\n",str); HDMI_text(4, 6, str);
    sprintf(str,"start_time  = %d",Begin_Time);
    xil_printf("%s\n",str);
    //HDMI_text(4, 7, str);
    sprintf(str,"finish_time = %d",End_Time);
    xil_printf("%s\n",str);
    //HDMI_text(4, 8, str);

    xil_printf ("\n");
  }

    cleanup_platform();
}


void Proc_1 (Ptr_Val_Par)
/******************/

REG Rec_Pointer Ptr_Val_Par;
    /* executed once */
{
  REG Rec_Pointer Next_Record = Ptr_Val_Par->Ptr_Comp;
                                        /* == Ptr_Glob_Next */
  /* Local variable, initialized with Ptr_Val_Par->Ptr_Comp,    */
  /* corresponds to "rename" in Ada, "with" in Pascal           */

  structassign (*Ptr_Val_Par->Ptr_Comp, *Ptr_Glob);
  Ptr_Val_Par->variant.var_1.Int_Comp = 5;
  Next_Record->variant.var_1.Int_Comp
        = Ptr_Val_Par->variant.var_1.Int_Comp;
  Next_Record->Ptr_Comp = Ptr_Val_Par->Ptr_Comp;
  Proc_3 (&Next_Record->Ptr_Comp);
    /* Ptr_Val_Par->Ptr_Comp->Ptr_Comp
                        == Ptr_Glob->Ptr_Comp */
  if (Next_Record->Discr == Ident_1)
    /* then, executed */
  {
    Next_Record->variant.var_1.Int_Comp = 6;
    Proc_6 (Ptr_Val_Par->variant.var_1.Enum_Comp,
           &Next_Record->variant.var_1.Enum_Comp);
    Next_Record->Ptr_Comp = Ptr_Glob->Ptr_Comp;
    Proc_7 (Next_Record->variant.var_1.Int_Comp, 10,
           &Next_Record->variant.var_1.Int_Comp);
  }
  else /* not executed */
    structassign (*Ptr_Val_Par, *Ptr_Val_Par->Ptr_Comp);
} /* Proc_1 */


void Proc_2 (Int_Par_Ref)
/******************/
    /* executed once */
    /* *Int_Par_Ref == 1, becomes 4 */

One_Fifty   *Int_Par_Ref;
{
  One_Fifty  Int_Loc;
  Enumeration   Enum_Loc;

  Int_Loc = *Int_Par_Ref + 10;
  do /* executed once */
    if (Ch_1_Glob == 'A')
      /* then, executed */
    {
      Int_Loc -= 1;
      *Int_Par_Ref = Int_Loc - Int_Glob;
      Enum_Loc = Ident_1;
    } /* if */
  while (Enum_Loc != Ident_1); /* true */
} /* Proc_2 */


void Proc_3 (Ptr_Ref_Par)
/******************/
    /* executed once */
    /* Ptr_Ref_Par becomes Ptr_Glob */

Rec_Pointer *Ptr_Ref_Par;

{
  if (Ptr_Glob != Null)
    /* then, executed */
    *Ptr_Ref_Par = Ptr_Glob->Ptr_Comp;
  Proc_7 (10, Int_Glob, &Ptr_Glob->variant.var_1.Int_Comp);
} /* Proc_3 */


void Proc_4 () /* without parameters */
/*******/
    /* executed once */
{
  Boolean Bool_Loc;

  Bool_Loc = Ch_1_Glob == 'A';
  Bool_Glob = Bool_Loc | Bool_Glob;
  Ch_2_Glob = 'B';
} /* Proc_4 */

void Proc_5 () /* without parameters */
/*******/
    /* executed once */
{
  Ch_1_Glob = 'A';
  Bool_Glob = false;
} /* Proc_5 */


        /* Procedure for the assignment of structures,          */
        /* if the C compiler doesn't support this feature       */
#ifdef  NOSTRUCTASSIGN
memcpy (d, s, l)
register char   *d;
register char   *s;
register int    l;
{
        while (l--) *d++ = *s++;
}
#endif


