#include "hdmi_util.h"
#include "xil_io.h"
#include "xil_types.h"
char banner[40]    = "*** ZYBO HDMI Computer by UMB ***\0";
//===================================================================
// Subroutine to send a string of text to the HDMI monitor
//===================================================================
void HDMI_text(int x, int y, char *text_ptr)
{
    volatile int i;
    u32 sv, w0, w1, w2, w3, val, xx=x;

	/* assume that the text string fits on one line */
	while ( *(text_ptr) )
	{
  		     sv =  Xil_In32(SWITCHES);
             w0= mask0 & ((sv << 4) + 8);  // color =BW=00; serif font= SC=01; set WE=1
             w1= mask1 & (xx << 8);
             w2= mask2 & (y << 16);
             //i=x+y+48;
		     i = *(text_ptr);	// print one char at a time
  		     text_ptr++;
             w3= mask3 & (i << 24); // Char ASCII 0=48 dec
             val= w3 + w2 + w1 + w0;
  		   Xil_Out32(HDMI, val);
  		   xx++;
           for(i=0;i<(125000000/9)/30; i++); // wait WE 1sec/30 Hz
	}
}
//===================================================================
// Subroutine to clear the first y line of HDMI monitor
//===================================================================
void HDMI_cls(int ymax)
{
    volatile int i;
    u32 sv, w0, w1, w2, w3, val, x, y;

    for (y=0;y<ymax;y++)
 	   for (x=0;x<80;x++) {
 		    sv =  Xil_In32(SWITCHES);
            w0= mask0 & ((sv << 4) + 8);  // color =BW=00; serif font= SC=01; set WE=1
            w1= mask1 & (x << 8);
            w2= mask2 & (y << 16);
            if ((x==0)||(x==79)||(y==0)||(y==59))
             i=banner[(x+y)%32];
            else
             i=32; // space char dec=32
            w3= mask3 & (i << 24); // Char ASCII 0=48 dec
            val= w3 + w2 + w1 + w0;
 		   Xil_Out32(HDMI, val);
 		 for(i=0;i<(125000000/9)/60; i++); // wait 1sec/60 Hz
 	}
}
