//*********************************************************
// IEEE STD 1364-2001 Verilog file: img_ram.v 
// Store the 80x60 character array; use initialization file 
// Author-EMAIL: Uwe.Meyer-Baese@ieee.org
//*********************************************************
module img_ram 
#(parameter DATA_WIDTH=8, parameter ADDR_WIDTH=13)
  (input  CLOCK,                    // System clock
   input WE,                        // Write enable
   input [DATA_WIDTH-1:0] DATA,     // Data input
   input [ADDR_WIDTH-1:0] ADDRESS,  // Read/write address
   output [DATA_WIDTH-1:0] Q);      // Data output
// --------------------------------------------------------
// Declare the RAM variable
  reg [DATA_WIDTH-1:0] ram[2**ADDR_WIDTH-1:0];

// Variable to hold the registered read address
  reg [ADDR_WIDTH-1:0] addr_reg;

  initial
  begin
    $readmemh("eupsd_hex.mif", ram);
  end

  always @ (posedge CLOCK)
  begin
    if (WE)    // Write
      ram[ADDRESS] <= DATA;

    addr_reg <= ADDRESS; // Synchronous memory, i.e. store 
  end                    // address in register

  assign Q = ram[addr_reg];

endmodule
