-- ====================================================================
-- Implements a simple Nios II system for the DE1-SoC board.
-- Inputs: SW9-0 are parallel port inputs to the Nios II system
-- CLOCK_50 is the system clock
-- KEY0 is the system reset
-- Outputs: LEDR9-0 are parallel port outputs from the Nios II system
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.ALL;
-- ====================================================================
ENTITY DE1_SoC_Basic_Computer IS
  PORT (
    CLOCK_50  : IN STD_LOGIC;
    KEY       : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
    SW        : IN STD_LOGIC_VECTOR (9 DOWNTO 0);
    LEDR      : OUT STD_LOGIC_VECTOR (9 DOWNTO 0);
    DRAM_DQ   : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
    DRAM_ADDR : OUT STD_LOGIC_VECTOR (12 DOWNTO 0);
    DRAM_BA   : OUT STD_LOGIC_VECTOR (1 DOWNTO 0);
    DRAM_CAS_N, DRAM_RAS_N, DRAM_CLK : OUT STD_LOGIC;
    DRAM_CKE, DRAM_CS_N, DRAM_WE_N : OUT STD_LOGIC;
    DRAM_UDQM, DRAM_LDQM : OUT STD_LOGIC);
END ENTITY;
-- ======================================================================================
ARCHITECTURE fpga OF DE1_SoC_Basic_Computer IS

  component nios_system is
  port (
    clk_clk            : in    std_logic                     := 'X';             -- clk
    leds_export        : out   std_logic_vector(9 downto 0);                     -- export
    pushbuttons_export : in    std_logic_vector(3 downto 0)  := (others => 'X'); -- export   
    reset_reset        : in    std_logic                     := 'X';             -- reset
    sdram_clk_clk      : out   std_logic;                                        -- clk
    sdram_wire_addr    : out   std_logic_vector(12 downto 0);                    -- addr
    sdram_wire_ba      : out   std_logic_vector(1 downto 0);                     -- ba
    sdram_wire_cas_n   : out   std_logic;                                        -- cas_n
    sdram_wire_cke     : out   std_logic;                                        -- cke
    sdram_wire_cs_n    : out   std_logic;                                        -- cs_n
    sdram_wire_dq      : inout std_logic_vector(15 downto 0) := (others => 'X'); -- dq
    sdram_wire_dqm     : out   std_logic_vector(1 downto 0);                     -- dqm
    sdram_wire_ras_n   : out   std_logic;                                        -- ras_n
    sdram_wire_we_n    : out   std_logic;                                        -- we_n
    switches_export    : in    std_logic_vector(9 downto 0)  := (others => 'X')  -- export
    );
  end component nios_system;
    
BEGIN

  u0 : component nios_system
  port map (clk_clk            => CLOCK_50,        -- clk.clk
            leds_export        => LEDR(9 DOWNTO 0),-- leds.export
            pushbuttons_export => NOT KEY(3 DOWNTO 0), -- pushbuttons.export            
            reset_reset        => '0',        -- NOT KEY(0),      -- reset.reset
            sdram_clk_clk      => DRAM_CLK,   --  sdram_clk.clk
            sdram_wire_addr    => DRAM_ADDR,   -- sdram_wire.addr
            sdram_wire_ba      => DRAM_BA,     --           .ba
            sdram_wire_cas_n   => DRAM_CAS_N,  --           .cas_n
            sdram_wire_cke     => DRAM_CKE,    --           .cke
            sdram_wire_cs_n    => DRAM_CS_N,   --           .cs_n
            sdram_wire_dq      => DRAM_DQ,     --           .dq
            sdram_wire_dqm(1)  => DRAM_UDQM,
            sdram_wire_dqm(0)  => DRAM_LDQM,
            sdram_wire_ras_n   => DRAM_RAS_N, --           .ras_n
            sdram_wire_we_n    => DRAM_WE_N,  --           .we_n
            switches_export    => SW(9 DOWNTO 0)); -- switches.export
        
END ARCHITECTURE;
