// ====================================================================
// Implements a simple Nios II system for the DE1-SoC board.
// Inputs: SW9-0 are parallel port inputs to the Nios II system
// CLOCK_50 is the system clock
// KEY0 is the system reset
// Outputs: LEDR9-0 are parallel port outputs from the Nios II system
// ====================================================================
module DE1_SoC_CustomIPv (
    input CLOCK_50,
    input [3:0] KEY,
    input [9:0] SW,
    output [9:0] LEDR,
    inout [15:0] DRAM_DQ,
    output [12:0] DRAM_ADDR,
    output [1:0] DRAM_BA,
    output DRAM_CAS_N, DRAM_RAS_N, DRAM_CLK,
    output DRAM_CKE, DRAM_CS_N, DRAM_WE_N,
    output DRAM_UDQM, DRAM_LDQM);
// ====================================================================

  nios_system UUT
           (.clk_clk(CLOCK_50),        // clk.clk
            .leds_export(LEDR[9:0]),// leds.export
            .pushbuttons_export(~ KEY[3:0]), // pushbuttons.export            
            .reset_reset( 1'b0),        // NOT KEY(0),      // reset.reset
            .sdram_clk_clk(DRAM_CLK),   // sdram_clk.clk
            .sdram_wire_addr(DRAM_ADDR),   // sdram_wire.addr
            .sdram_wire_ba(DRAM_BA),     // .ba
            .sdram_wire_cas_n(DRAM_CAS_N),  // .cas_n
            .sdram_wire_cke(DRAM_CKE),    // .cke
            .sdram_wire_cs_n(DRAM_CS_N),   // .cs_n
            .sdram_wire_dq(DRAM_DQ),     // .dq
            .sdram_wire_dqm({DRAM_UDQM, DRAM_LDQM}),
            .sdram_wire_ras_n(DRAM_RAS_N), // .ras_n
            .sdram_wire_we_n(DRAM_WE_N),  // .we_n
            .switches_export(SW[9:0])); // switches.export
        
endmodule
