########## Compile project
set project_name "fp_sqrt64" 
puts "** Timing Simulation"
vlib work
vlog -reportprogress 300 -work work ${project_name}.vo

  vsim +altera -L C:/altera/15.1lite/modelsim_ase/altera/verilog/cyclonev \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/altera \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/cyclonev \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/cyclonev_hssi \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/cyclonev_pcie_hip \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/altera_mf \
  -L C:/altera/15.1lite/modelsim_ase/altera/verilog/altera_lnsim \
  -l msim_transcript -gui work.${project_name}

########## Add I/O signals to wave window
#### Always start with e-signature first:
radix -hex
add wave -divider  "Inputs:"
add wave clk reset start
add wave n dataa
add wave -divider  "Locals:"
add wave -uns cnt_out 
add wave sqrt_out done_delay_out
add wave -divider  "Outputs:"
add wave done result

######### Add stimuli data
force clk 0 0 ns, 1 5 ns -r 10 ns
force reset 1 0 ns, 0 10 ns
force clk_en 1 0ns
force n 0 0ns, 1 50ns, 2 200ns,3 400ns
force start 0 0ns, 1 10ns, 0 20ns, 1 50ns, 0 60ns, 1 200ns, 0 210ns, 1 400ns, 0 410ns
force dataa  C1DF4D84 0ns, 4374B66D 50ns
force datab 0 0ns

########## Run the simulation
run 470 ns  
wave zoomfull
configure wave -gridperiod 5ns
configure wave -timelineunits ns
