// nios_system.v

// Generated using ACDS version 15.1 185

`timescale 1 ps / 1 ps
module nios_system (
		input  wire        clk_clk,            //         clk.clk
		output wire [9:0]  leds_export,        //        leds.export
		input  wire [3:0]  pushbuttons_export, // pushbuttons.export
		input  wire        reset_reset,        //       reset.reset
		output wire        sdram_clk_clk,      //   sdram_clk.clk
		output wire [12:0] sdram_wire_addr,    //  sdram_wire.addr
		output wire [1:0]  sdram_wire_ba,      //            .ba
		output wire        sdram_wire_cas_n,   //            .cas_n
		output wire        sdram_wire_cke,     //            .cke
		output wire        sdram_wire_cs_n,    //            .cs_n
		inout  wire [15:0] sdram_wire_dq,      //            .dq
		output wire [1:0]  sdram_wire_dqm,     //            .dqm
		output wire        sdram_wire_ras_n,   //            .ras_n
		output wire        sdram_wire_we_n,    //            .we_n
		input  wire [9:0]  switches_export     //    switches.export
	);

	wire         clocks_sys_clk_clk;                                                            // clocks:sys_clk_clk -> [irq_mapper:clk, jtag_uart:clk, leds:clk, mm_interconnect_0:clocks_sys_clk_clk, nios2_gen2:clk, pushbuttons:clk, rst_controller:clk, sdram:clk, switches:clk, timer:clk]
	wire         nios2_gen2_custom_instruction_master_readra;                                   // nios2_gen2:D_ci_readra -> nios2_gen2_custom_instruction_master_translator:ci_slave_readra
	wire   [4:0] nios2_gen2_custom_instruction_master_a;                                        // nios2_gen2:D_ci_a -> nios2_gen2_custom_instruction_master_translator:ci_slave_a
	wire   [4:0] nios2_gen2_custom_instruction_master_b;                                        // nios2_gen2:D_ci_b -> nios2_gen2_custom_instruction_master_translator:ci_slave_b
	wire   [4:0] nios2_gen2_custom_instruction_master_c;                                        // nios2_gen2:D_ci_c -> nios2_gen2_custom_instruction_master_translator:ci_slave_c
	wire         nios2_gen2_custom_instruction_master_readrb;                                   // nios2_gen2:D_ci_readrb -> nios2_gen2_custom_instruction_master_translator:ci_slave_readrb
	wire         nios2_gen2_custom_instruction_master_clk;                                      // nios2_gen2:E_ci_multi_clock -> nios2_gen2_custom_instruction_master_translator:ci_slave_multi_clk
	wire  [31:0] nios2_gen2_custom_instruction_master_ipending;                                 // nios2_gen2:W_ci_ipending -> nios2_gen2_custom_instruction_master_translator:ci_slave_ipending
	wire         nios2_gen2_custom_instruction_master_start;                                    // nios2_gen2:E_ci_multi_start -> nios2_gen2_custom_instruction_master_translator:ci_slave_multi_start
	wire         nios2_gen2_custom_instruction_master_reset_req;                                // nios2_gen2:E_ci_multi_reset_req -> nios2_gen2_custom_instruction_master_translator:ci_slave_multi_reset_req
	wire         nios2_gen2_custom_instruction_master_done;                                     // nios2_gen2_custom_instruction_master_translator:ci_slave_multi_done -> nios2_gen2:E_ci_multi_done
	wire   [7:0] nios2_gen2_custom_instruction_master_n;                                        // nios2_gen2:D_ci_n -> nios2_gen2_custom_instruction_master_translator:ci_slave_n
	wire  [31:0] nios2_gen2_custom_instruction_master_result;                                   // nios2_gen2_custom_instruction_master_translator:ci_slave_result -> nios2_gen2:E_ci_result
	wire         nios2_gen2_custom_instruction_master_estatus;                                  // nios2_gen2:W_ci_estatus -> nios2_gen2_custom_instruction_master_translator:ci_slave_estatus
	wire         nios2_gen2_custom_instruction_master_clk_en;                                   // nios2_gen2:E_ci_multi_clk_en -> nios2_gen2_custom_instruction_master_translator:ci_slave_multi_clken
	wire  [31:0] nios2_gen2_custom_instruction_master_datab;                                    // nios2_gen2:E_ci_datab -> nios2_gen2_custom_instruction_master_translator:ci_slave_datab
	wire  [31:0] nios2_gen2_custom_instruction_master_dataa;                                    // nios2_gen2:E_ci_dataa -> nios2_gen2_custom_instruction_master_translator:ci_slave_dataa
	wire         nios2_gen2_custom_instruction_master_reset;                                    // nios2_gen2:E_ci_multi_reset -> nios2_gen2_custom_instruction_master_translator:ci_slave_multi_reset
	wire         nios2_gen2_custom_instruction_master_writerc;                                  // nios2_gen2:D_ci_writerc -> nios2_gen2_custom_instruction_master_translator:ci_slave_writerc
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_readra;        // nios2_gen2_custom_instruction_master_translator:multi_ci_master_readra -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_readra
	wire   [4:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_a;             // nios2_gen2_custom_instruction_master_translator:multi_ci_master_a -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_a
	wire   [4:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_b;             // nios2_gen2_custom_instruction_master_translator:multi_ci_master_b -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_b
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk;           // nios2_gen2_custom_instruction_master_translator:multi_ci_master_clk -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_clk
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_readrb;        // nios2_gen2_custom_instruction_master_translator:multi_ci_master_readrb -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_readrb
	wire   [4:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_c;             // nios2_gen2_custom_instruction_master_translator:multi_ci_master_c -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_c
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_start;         // nios2_gen2_custom_instruction_master_translator:multi_ci_master_start -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_start
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset_req;     // nios2_gen2_custom_instruction_master_translator:multi_ci_master_reset_req -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_reset_req
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_done;          // nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_done -> nios2_gen2_custom_instruction_master_translator:multi_ci_master_done
	wire   [7:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_n;             // nios2_gen2_custom_instruction_master_translator:multi_ci_master_n -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_n
	wire  [31:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_result;        // nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_result -> nios2_gen2_custom_instruction_master_translator:multi_ci_master_result
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk_en;        // nios2_gen2_custom_instruction_master_translator:multi_ci_master_clken -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_clken
	wire  [31:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_datab;         // nios2_gen2_custom_instruction_master_translator:multi_ci_master_datab -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_datab
	wire  [31:0] nios2_gen2_custom_instruction_master_translator_multi_ci_master_dataa;         // nios2_gen2_custom_instruction_master_translator:multi_ci_master_dataa -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_dataa
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset;         // nios2_gen2_custom_instruction_master_translator:multi_ci_master_reset -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_reset
	wire         nios2_gen2_custom_instruction_master_translator_multi_ci_master_writerc;       // nios2_gen2_custom_instruction_master_translator:multi_ci_master_writerc -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_slave_writerc
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readra;         // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_readra -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_readra
	wire   [4:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_a;              // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_a -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_a
	wire   [4:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_b;              // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_b -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_b
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readrb;         // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_readrb -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_readrb
	wire   [4:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_c;              // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_c -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_c
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk;            // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_clk -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_clk
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_ipending;       // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_ipending -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_ipending
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_start;          // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_start -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_start
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset_req;      // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_reset_req -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_reset_req
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_done;           // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_done -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_done
	wire   [7:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_n;              // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_n -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_n
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_result;         // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_result -> nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_result
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_estatus;        // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_estatus -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_estatus
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk_en;         // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_clken -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_clken
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_datab;          // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_datab -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_datab
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_dataa;          // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_dataa -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_dataa
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset;          // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_reset -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_reset
	wire         nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_writerc;        // nios2_gen2_custom_instruction_master_multi_xconnect:ci_master0_writerc -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_slave_writerc
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_result; // fp_sqrt64_0:result -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_result
	wire         nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk;    // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_clk -> fp_sqrt64_0:clk
	wire         nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk_en; // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_clken -> fp_sqrt64_0:clk_en
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_datab;  // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_datab -> fp_sqrt64_0:datab
	wire  [31:0] nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_dataa;  // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_dataa -> fp_sqrt64_0:dataa
	wire         nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_start;  // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_start -> fp_sqrt64_0:start
	wire         nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_reset;  // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_reset -> fp_sqrt64_0:reset
	wire         nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_done;   // fp_sqrt64_0:done -> nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_done
	wire   [7:0] nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_n;      // nios2_gen2_custom_instruction_master_multi_slave_translator0:ci_master_n -> fp_sqrt64_0:n
	wire  [31:0] nios2_gen2_data_master_readdata;                                               // mm_interconnect_0:nios2_gen2_data_master_readdata -> nios2_gen2:d_readdata
	wire         nios2_gen2_data_master_waitrequest;                                            // mm_interconnect_0:nios2_gen2_data_master_waitrequest -> nios2_gen2:d_waitrequest
	wire         nios2_gen2_data_master_debugaccess;                                            // nios2_gen2:debug_mem_slave_debugaccess_to_roms -> mm_interconnect_0:nios2_gen2_data_master_debugaccess
	wire  [31:0] nios2_gen2_data_master_address;                                                // nios2_gen2:d_address -> mm_interconnect_0:nios2_gen2_data_master_address
	wire   [3:0] nios2_gen2_data_master_byteenable;                                             // nios2_gen2:d_byteenable -> mm_interconnect_0:nios2_gen2_data_master_byteenable
	wire         nios2_gen2_data_master_read;                                                   // nios2_gen2:d_read -> mm_interconnect_0:nios2_gen2_data_master_read
	wire         nios2_gen2_data_master_write;                                                  // nios2_gen2:d_write -> mm_interconnect_0:nios2_gen2_data_master_write
	wire  [31:0] nios2_gen2_data_master_writedata;                                              // nios2_gen2:d_writedata -> mm_interconnect_0:nios2_gen2_data_master_writedata
	wire  [31:0] nios2_gen2_instruction_master_readdata;                                        // mm_interconnect_0:nios2_gen2_instruction_master_readdata -> nios2_gen2:i_readdata
	wire         nios2_gen2_instruction_master_waitrequest;                                     // mm_interconnect_0:nios2_gen2_instruction_master_waitrequest -> nios2_gen2:i_waitrequest
	wire  [26:0] nios2_gen2_instruction_master_address;                                         // nios2_gen2:i_address -> mm_interconnect_0:nios2_gen2_instruction_master_address
	wire         nios2_gen2_instruction_master_read;                                            // nios2_gen2:i_read -> mm_interconnect_0:nios2_gen2_instruction_master_read
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;                      // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;                        // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest;                     // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;                         // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;                            // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;                           // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;                       // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata;                         // nios2_gen2:debug_mem_slave_readdata -> mm_interconnect_0:nios2_gen2_debug_mem_slave_readdata
	wire         mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest;                      // nios2_gen2:debug_mem_slave_waitrequest -> mm_interconnect_0:nios2_gen2_debug_mem_slave_waitrequest
	wire         mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess;                      // mm_interconnect_0:nios2_gen2_debug_mem_slave_debugaccess -> nios2_gen2:debug_mem_slave_debugaccess
	wire   [8:0] mm_interconnect_0_nios2_gen2_debug_mem_slave_address;                          // mm_interconnect_0:nios2_gen2_debug_mem_slave_address -> nios2_gen2:debug_mem_slave_address
	wire         mm_interconnect_0_nios2_gen2_debug_mem_slave_read;                             // mm_interconnect_0:nios2_gen2_debug_mem_slave_read -> nios2_gen2:debug_mem_slave_read
	wire   [3:0] mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable;                       // mm_interconnect_0:nios2_gen2_debug_mem_slave_byteenable -> nios2_gen2:debug_mem_slave_byteenable
	wire         mm_interconnect_0_nios2_gen2_debug_mem_slave_write;                            // mm_interconnect_0:nios2_gen2_debug_mem_slave_write -> nios2_gen2:debug_mem_slave_write
	wire  [31:0] mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata;                        // mm_interconnect_0:nios2_gen2_debug_mem_slave_writedata -> nios2_gen2:debug_mem_slave_writedata
	wire  [31:0] mm_interconnect_0_switches_s1_readdata;                                        // switches:readdata -> mm_interconnect_0:switches_s1_readdata
	wire   [1:0] mm_interconnect_0_switches_s1_address;                                         // mm_interconnect_0:switches_s1_address -> switches:address
	wire         mm_interconnect_0_leds_s1_chipselect;                                          // mm_interconnect_0:leds_s1_chipselect -> leds:chipselect
	wire  [31:0] mm_interconnect_0_leds_s1_readdata;                                            // leds:readdata -> mm_interconnect_0:leds_s1_readdata
	wire   [1:0] mm_interconnect_0_leds_s1_address;                                             // mm_interconnect_0:leds_s1_address -> leds:address
	wire         mm_interconnect_0_leds_s1_write;                                               // mm_interconnect_0:leds_s1_write -> leds:write_n
	wire  [31:0] mm_interconnect_0_leds_s1_writedata;                                           // mm_interconnect_0:leds_s1_writedata -> leds:writedata
	wire         mm_interconnect_0_timer_s1_chipselect;                                         // mm_interconnect_0:timer_s1_chipselect -> timer:chipselect
	wire  [15:0] mm_interconnect_0_timer_s1_readdata;                                           // timer:readdata -> mm_interconnect_0:timer_s1_readdata
	wire   [2:0] mm_interconnect_0_timer_s1_address;                                            // mm_interconnect_0:timer_s1_address -> timer:address
	wire         mm_interconnect_0_timer_s1_write;                                              // mm_interconnect_0:timer_s1_write -> timer:write_n
	wire  [15:0] mm_interconnect_0_timer_s1_writedata;                                          // mm_interconnect_0:timer_s1_writedata -> timer:writedata
	wire         mm_interconnect_0_sdram_s1_chipselect;                                         // mm_interconnect_0:sdram_s1_chipselect -> sdram:az_cs
	wire  [15:0] mm_interconnect_0_sdram_s1_readdata;                                           // sdram:za_data -> mm_interconnect_0:sdram_s1_readdata
	wire         mm_interconnect_0_sdram_s1_waitrequest;                                        // sdram:za_waitrequest -> mm_interconnect_0:sdram_s1_waitrequest
	wire  [24:0] mm_interconnect_0_sdram_s1_address;                                            // mm_interconnect_0:sdram_s1_address -> sdram:az_addr
	wire         mm_interconnect_0_sdram_s1_read;                                               // mm_interconnect_0:sdram_s1_read -> sdram:az_rd_n
	wire   [1:0] mm_interconnect_0_sdram_s1_byteenable;                                         // mm_interconnect_0:sdram_s1_byteenable -> sdram:az_be_n
	wire         mm_interconnect_0_sdram_s1_readdatavalid;                                      // sdram:za_valid -> mm_interconnect_0:sdram_s1_readdatavalid
	wire         mm_interconnect_0_sdram_s1_write;                                              // mm_interconnect_0:sdram_s1_write -> sdram:az_wr_n
	wire  [15:0] mm_interconnect_0_sdram_s1_writedata;                                          // mm_interconnect_0:sdram_s1_writedata -> sdram:az_data
	wire         mm_interconnect_0_pushbuttons_s1_chipselect;                                   // mm_interconnect_0:pushbuttons_s1_chipselect -> pushbuttons:chipselect
	wire  [31:0] mm_interconnect_0_pushbuttons_s1_readdata;                                     // pushbuttons:readdata -> mm_interconnect_0:pushbuttons_s1_readdata
	wire   [1:0] mm_interconnect_0_pushbuttons_s1_address;                                      // mm_interconnect_0:pushbuttons_s1_address -> pushbuttons:address
	wire         mm_interconnect_0_pushbuttons_s1_write;                                        // mm_interconnect_0:pushbuttons_s1_write -> pushbuttons:write_n
	wire  [31:0] mm_interconnect_0_pushbuttons_s1_writedata;                                    // mm_interconnect_0:pushbuttons_s1_writedata -> pushbuttons:writedata
	wire         irq_mapper_receiver0_irq;                                                      // jtag_uart:av_irq -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                                      // timer:irq -> irq_mapper:receiver1_irq
	wire         irq_mapper_receiver2_irq;                                                      // pushbuttons:irq -> irq_mapper:receiver2_irq
	wire  [31:0] nios2_gen2_irq_irq;                                                            // irq_mapper:sender_irq -> nios2_gen2:irq
	wire         rst_controller_reset_out_reset;                                                // rst_controller:reset_out -> [irq_mapper:reset, jtag_uart:rst_n, leds:reset_n, mm_interconnect_0:nios2_gen2_reset_reset_bridge_in_reset_reset, nios2_gen2:reset_n, pushbuttons:reset_n, rst_translator:in_reset, sdram:reset_n, switches:reset_n, timer:reset_n]
	wire         rst_controller_reset_out_reset_req;                                            // rst_controller:reset_req -> [nios2_gen2:reset_req, rst_translator:reset_req_in]
	wire         nios2_gen2_debug_reset_request_reset;                                          // nios2_gen2:debug_reset_request -> rst_controller:reset_in0
	wire         clocks_reset_source_reset;                                                     // clocks:reset_source_reset -> rst_controller:reset_in1

	nios_system_clocks clocks (
		.ref_clk_clk        (clk_clk),                   //      ref_clk.clk
		.ref_reset_reset    (reset_reset),               //    ref_reset.reset
		.sys_clk_clk        (clocks_sys_clk_clk),        //      sys_clk.clk
		.sdram_clk_clk      (sdram_clk_clk),             //    sdram_clk.clk
		.reset_source_reset (clocks_reset_source_reset)  // reset_source.reset
	);

	fp_sqrt64 fp_sqrt64_0 (
		.clk_en (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk_en), // nios_custom_instruction_slave.clk_en
		.start  (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_start),  //                              .start
		.done   (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_done),   //                              .done
		.n      (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_n),      //                              .n
		.dataa  (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_dataa),  //                              .dataa
		.datab  (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_datab),  //                              .datab
		.result (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_result), //                              .result
		.clk    (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk),    //                              .clk
		.reset  (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_reset)   //                              .reset
	);

	nios_system_jtag_uart jtag_uart (
		.clk            (clocks_sys_clk_clk),                                        //               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  // avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //                  .waitrequest
		.av_irq         (irq_mapper_receiver0_irq)                                   //               irq.irq
	);

	nios_system_leds leds (
		.clk        (clocks_sys_clk_clk),                   //                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),      //               reset.reset_n
		.address    (mm_interconnect_0_leds_s1_address),    //                  s1.address
		.write_n    (~mm_interconnect_0_leds_s1_write),     //                    .write_n
		.writedata  (mm_interconnect_0_leds_s1_writedata),  //                    .writedata
		.chipselect (mm_interconnect_0_leds_s1_chipselect), //                    .chipselect
		.readdata   (mm_interconnect_0_leds_s1_readdata),   //                    .readdata
		.out_port   (leds_export)                           // external_connection.export
	);

	nios_system_nios2_gen2 nios2_gen2 (
		.clk                                 (clocks_sys_clk_clk),                                       //                       clk.clk
		.reset_n                             (~rst_controller_reset_out_reset),                          //                     reset.reset_n
		.reset_req                           (rst_controller_reset_out_reset_req),                       //                          .reset_req
		.d_address                           (nios2_gen2_data_master_address),                           //               data_master.address
		.d_byteenable                        (nios2_gen2_data_master_byteenable),                        //                          .byteenable
		.d_read                              (nios2_gen2_data_master_read),                              //                          .read
		.d_readdata                          (nios2_gen2_data_master_readdata),                          //                          .readdata
		.d_waitrequest                       (nios2_gen2_data_master_waitrequest),                       //                          .waitrequest
		.d_write                             (nios2_gen2_data_master_write),                             //                          .write
		.d_writedata                         (nios2_gen2_data_master_writedata),                         //                          .writedata
		.debug_mem_slave_debugaccess_to_roms (nios2_gen2_data_master_debugaccess),                       //                          .debugaccess
		.i_address                           (nios2_gen2_instruction_master_address),                    //        instruction_master.address
		.i_read                              (nios2_gen2_instruction_master_read),                       //                          .read
		.i_readdata                          (nios2_gen2_instruction_master_readdata),                   //                          .readdata
		.i_waitrequest                       (nios2_gen2_instruction_master_waitrequest),                //                          .waitrequest
		.irq                                 (nios2_gen2_irq_irq),                                       //                       irq.irq
		.debug_reset_request                 (nios2_gen2_debug_reset_request_reset),                     //       debug_reset_request.reset
		.debug_mem_slave_address             (mm_interconnect_0_nios2_gen2_debug_mem_slave_address),     //           debug_mem_slave.address
		.debug_mem_slave_byteenable          (mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable),  //                          .byteenable
		.debug_mem_slave_debugaccess         (mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess), //                          .debugaccess
		.debug_mem_slave_read                (mm_interconnect_0_nios2_gen2_debug_mem_slave_read),        //                          .read
		.debug_mem_slave_readdata            (mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata),    //                          .readdata
		.debug_mem_slave_waitrequest         (mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest), //                          .waitrequest
		.debug_mem_slave_write               (mm_interconnect_0_nios2_gen2_debug_mem_slave_write),       //                          .write
		.debug_mem_slave_writedata           (mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata),   //                          .writedata
		.E_ci_multi_done                     (nios2_gen2_custom_instruction_master_done),                // custom_instruction_master.done
		.E_ci_multi_clk_en                   (nios2_gen2_custom_instruction_master_clk_en),              //                          .clk_en
		.E_ci_multi_start                    (nios2_gen2_custom_instruction_master_start),               //                          .start
		.E_ci_result                         (nios2_gen2_custom_instruction_master_result),              //                          .result
		.D_ci_a                              (nios2_gen2_custom_instruction_master_a),                   //                          .a
		.D_ci_b                              (nios2_gen2_custom_instruction_master_b),                   //                          .b
		.D_ci_c                              (nios2_gen2_custom_instruction_master_c),                   //                          .c
		.D_ci_n                              (nios2_gen2_custom_instruction_master_n),                   //                          .n
		.D_ci_readra                         (nios2_gen2_custom_instruction_master_readra),              //                          .readra
		.D_ci_readrb                         (nios2_gen2_custom_instruction_master_readrb),              //                          .readrb
		.D_ci_writerc                        (nios2_gen2_custom_instruction_master_writerc),             //                          .writerc
		.E_ci_dataa                          (nios2_gen2_custom_instruction_master_dataa),               //                          .dataa
		.E_ci_datab                          (nios2_gen2_custom_instruction_master_datab),               //                          .datab
		.E_ci_multi_clock                    (nios2_gen2_custom_instruction_master_clk),                 //                          .clk
		.E_ci_multi_reset                    (nios2_gen2_custom_instruction_master_reset),               //                          .reset
		.E_ci_multi_reset_req                (nios2_gen2_custom_instruction_master_reset_req),           //                          .reset_req
		.W_ci_estatus                        (nios2_gen2_custom_instruction_master_estatus),             //                          .estatus
		.W_ci_ipending                       (nios2_gen2_custom_instruction_master_ipending)             //                          .ipending
	);

	nios_system_pushbuttons pushbuttons (
		.clk        (clocks_sys_clk_clk),                          //                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),             //               reset.reset_n
		.address    (mm_interconnect_0_pushbuttons_s1_address),    //                  s1.address
		.write_n    (~mm_interconnect_0_pushbuttons_s1_write),     //                    .write_n
		.writedata  (mm_interconnect_0_pushbuttons_s1_writedata),  //                    .writedata
		.chipselect (mm_interconnect_0_pushbuttons_s1_chipselect), //                    .chipselect
		.readdata   (mm_interconnect_0_pushbuttons_s1_readdata),   //                    .readdata
		.in_port    (pushbuttons_export),                          // external_connection.export
		.irq        (irq_mapper_receiver2_irq)                     //                 irq.irq
	);

	nios_system_sdram sdram (
		.clk            (clocks_sys_clk_clk),                       //   clk.clk
		.reset_n        (~rst_controller_reset_out_reset),          // reset.reset_n
		.az_addr        (mm_interconnect_0_sdram_s1_address),       //    s1.address
		.az_be_n        (~mm_interconnect_0_sdram_s1_byteenable),   //      .byteenable_n
		.az_cs          (mm_interconnect_0_sdram_s1_chipselect),    //      .chipselect
		.az_data        (mm_interconnect_0_sdram_s1_writedata),     //      .writedata
		.az_rd_n        (~mm_interconnect_0_sdram_s1_read),         //      .read_n
		.az_wr_n        (~mm_interconnect_0_sdram_s1_write),        //      .write_n
		.za_data        (mm_interconnect_0_sdram_s1_readdata),      //      .readdata
		.za_valid       (mm_interconnect_0_sdram_s1_readdatavalid), //      .readdatavalid
		.za_waitrequest (mm_interconnect_0_sdram_s1_waitrequest),   //      .waitrequest
		.zs_addr        (sdram_wire_addr),                          //  wire.export
		.zs_ba          (sdram_wire_ba),                            //      .export
		.zs_cas_n       (sdram_wire_cas_n),                         //      .export
		.zs_cke         (sdram_wire_cke),                           //      .export
		.zs_cs_n        (sdram_wire_cs_n),                          //      .export
		.zs_dq          (sdram_wire_dq),                            //      .export
		.zs_dqm         (sdram_wire_dqm),                           //      .export
		.zs_ras_n       (sdram_wire_ras_n),                         //      .export
		.zs_we_n        (sdram_wire_we_n)                           //      .export
	);

	nios_system_switches switches (
		.clk      (clocks_sys_clk_clk),                     //                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),        //               reset.reset_n
		.address  (mm_interconnect_0_switches_s1_address),  //                  s1.address
		.readdata (mm_interconnect_0_switches_s1_readdata), //                    .readdata
		.in_port  (switches_export)                         // external_connection.export
	);

	nios_system_timer timer (
		.clk        (clocks_sys_clk_clk),                    //   clk.clk
		.reset_n    (~rst_controller_reset_out_reset),       // reset.reset_n
		.address    (mm_interconnect_0_timer_s1_address),    //    s1.address
		.writedata  (mm_interconnect_0_timer_s1_writedata),  //      .writedata
		.readdata   (mm_interconnect_0_timer_s1_readdata),   //      .readdata
		.chipselect (mm_interconnect_0_timer_s1_chipselect), //      .chipselect
		.write_n    (~mm_interconnect_0_timer_s1_write),     //      .write_n
		.irq        (irq_mapper_receiver1_irq)               //   irq.irq
	);

	altera_customins_master_translator #(
		.SHARED_COMB_AND_MULTI (1)
	) nios2_gen2_custom_instruction_master_translator (
		.ci_slave_dataa            (nios2_gen2_custom_instruction_master_dataa),                                //        ci_slave.dataa
		.ci_slave_datab            (nios2_gen2_custom_instruction_master_datab),                                //                .datab
		.ci_slave_result           (nios2_gen2_custom_instruction_master_result),                               //                .result
		.ci_slave_n                (nios2_gen2_custom_instruction_master_n),                                    //                .n
		.ci_slave_readra           (nios2_gen2_custom_instruction_master_readra),                               //                .readra
		.ci_slave_readrb           (nios2_gen2_custom_instruction_master_readrb),                               //                .readrb
		.ci_slave_writerc          (nios2_gen2_custom_instruction_master_writerc),                              //                .writerc
		.ci_slave_a                (nios2_gen2_custom_instruction_master_a),                                    //                .a
		.ci_slave_b                (nios2_gen2_custom_instruction_master_b),                                    //                .b
		.ci_slave_c                (nios2_gen2_custom_instruction_master_c),                                    //                .c
		.ci_slave_ipending         (nios2_gen2_custom_instruction_master_ipending),                             //                .ipending
		.ci_slave_estatus          (nios2_gen2_custom_instruction_master_estatus),                              //                .estatus
		.ci_slave_multi_clk        (nios2_gen2_custom_instruction_master_clk),                                  //                .clk
		.ci_slave_multi_reset      (nios2_gen2_custom_instruction_master_reset),                                //                .reset
		.ci_slave_multi_clken      (nios2_gen2_custom_instruction_master_clk_en),                               //                .clk_en
		.ci_slave_multi_reset_req  (nios2_gen2_custom_instruction_master_reset_req),                            //                .reset_req
		.ci_slave_multi_start      (nios2_gen2_custom_instruction_master_start),                                //                .start
		.ci_slave_multi_done       (nios2_gen2_custom_instruction_master_done),                                 //                .done
		.comb_ci_master_dataa      (),                                                                          //  comb_ci_master.dataa
		.comb_ci_master_datab      (),                                                                          //                .datab
		.comb_ci_master_result     (),                                                                          //                .result
		.comb_ci_master_n          (),                                                                          //                .n
		.comb_ci_master_readra     (),                                                                          //                .readra
		.comb_ci_master_readrb     (),                                                                          //                .readrb
		.comb_ci_master_writerc    (),                                                                          //                .writerc
		.comb_ci_master_a          (),                                                                          //                .a
		.comb_ci_master_b          (),                                                                          //                .b
		.comb_ci_master_c          (),                                                                          //                .c
		.comb_ci_master_ipending   (),                                                                          //                .ipending
		.comb_ci_master_estatus    (),                                                                          //                .estatus
		.multi_ci_master_clk       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk),       // multi_ci_master.clk
		.multi_ci_master_reset     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset),     //                .reset
		.multi_ci_master_clken     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk_en),    //                .clk_en
		.multi_ci_master_reset_req (nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset_req), //                .reset_req
		.multi_ci_master_start     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_start),     //                .start
		.multi_ci_master_done      (nios2_gen2_custom_instruction_master_translator_multi_ci_master_done),      //                .done
		.multi_ci_master_dataa     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_dataa),     //                .dataa
		.multi_ci_master_datab     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_datab),     //                .datab
		.multi_ci_master_result    (nios2_gen2_custom_instruction_master_translator_multi_ci_master_result),    //                .result
		.multi_ci_master_n         (nios2_gen2_custom_instruction_master_translator_multi_ci_master_n),         //                .n
		.multi_ci_master_readra    (nios2_gen2_custom_instruction_master_translator_multi_ci_master_readra),    //                .readra
		.multi_ci_master_readrb    (nios2_gen2_custom_instruction_master_translator_multi_ci_master_readrb),    //                .readrb
		.multi_ci_master_writerc   (nios2_gen2_custom_instruction_master_translator_multi_ci_master_writerc),   //                .writerc
		.multi_ci_master_a         (nios2_gen2_custom_instruction_master_translator_multi_ci_master_a),         //                .a
		.multi_ci_master_b         (nios2_gen2_custom_instruction_master_translator_multi_ci_master_b),         //                .b
		.multi_ci_master_c         (nios2_gen2_custom_instruction_master_translator_multi_ci_master_c),         //                .c
		.ci_slave_multi_dataa      (32'b00000000000000000000000000000000),                                      //     (terminated)
		.ci_slave_multi_datab      (32'b00000000000000000000000000000000),                                      //     (terminated)
		.ci_slave_multi_result     (),                                                                          //     (terminated)
		.ci_slave_multi_n          (8'b00000000),                                                               //     (terminated)
		.ci_slave_multi_readra     (1'b0),                                                                      //     (terminated)
		.ci_slave_multi_readrb     (1'b0),                                                                      //     (terminated)
		.ci_slave_multi_writerc    (1'b0),                                                                      //     (terminated)
		.ci_slave_multi_a          (5'b00000),                                                                  //     (terminated)
		.ci_slave_multi_b          (5'b00000),                                                                  //     (terminated)
		.ci_slave_multi_c          (5'b00000)                                                                   //     (terminated)
	);

	nios_system_nios2_gen2_custom_instruction_master_multi_xconnect nios2_gen2_custom_instruction_master_multi_xconnect (
		.ci_slave_dataa       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_dataa),     //   ci_slave.dataa
		.ci_slave_datab       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_datab),     //           .datab
		.ci_slave_result      (nios2_gen2_custom_instruction_master_translator_multi_ci_master_result),    //           .result
		.ci_slave_n           (nios2_gen2_custom_instruction_master_translator_multi_ci_master_n),         //           .n
		.ci_slave_readra      (nios2_gen2_custom_instruction_master_translator_multi_ci_master_readra),    //           .readra
		.ci_slave_readrb      (nios2_gen2_custom_instruction_master_translator_multi_ci_master_readrb),    //           .readrb
		.ci_slave_writerc     (nios2_gen2_custom_instruction_master_translator_multi_ci_master_writerc),   //           .writerc
		.ci_slave_a           (nios2_gen2_custom_instruction_master_translator_multi_ci_master_a),         //           .a
		.ci_slave_b           (nios2_gen2_custom_instruction_master_translator_multi_ci_master_b),         //           .b
		.ci_slave_c           (nios2_gen2_custom_instruction_master_translator_multi_ci_master_c),         //           .c
		.ci_slave_ipending    (),                                                                          //           .ipending
		.ci_slave_estatus     (),                                                                          //           .estatus
		.ci_slave_clk         (nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk),       //           .clk
		.ci_slave_reset       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset),     //           .reset
		.ci_slave_clken       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_clk_en),    //           .clk_en
		.ci_slave_reset_req   (nios2_gen2_custom_instruction_master_translator_multi_ci_master_reset_req), //           .reset_req
		.ci_slave_start       (nios2_gen2_custom_instruction_master_translator_multi_ci_master_start),     //           .start
		.ci_slave_done        (nios2_gen2_custom_instruction_master_translator_multi_ci_master_done),      //           .done
		.ci_master0_dataa     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_dataa),      // ci_master0.dataa
		.ci_master0_datab     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_datab),      //           .datab
		.ci_master0_result    (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_result),     //           .result
		.ci_master0_n         (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_n),          //           .n
		.ci_master0_readra    (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readra),     //           .readra
		.ci_master0_readrb    (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readrb),     //           .readrb
		.ci_master0_writerc   (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_writerc),    //           .writerc
		.ci_master0_a         (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_a),          //           .a
		.ci_master0_b         (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_b),          //           .b
		.ci_master0_c         (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_c),          //           .c
		.ci_master0_ipending  (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_ipending),   //           .ipending
		.ci_master0_estatus   (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_estatus),    //           .estatus
		.ci_master0_clk       (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk),        //           .clk
		.ci_master0_reset     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset),      //           .reset
		.ci_master0_clken     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk_en),     //           .clk_en
		.ci_master0_reset_req (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset_req),  //           .reset_req
		.ci_master0_start     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_start),      //           .start
		.ci_master0_done      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_done)        //           .done
	);

	altera_customins_slave_translator #(
		.N_WIDTH          (8),
		.USE_DONE         (1),
		.NUM_FIXED_CYCLES (0)
	) nios2_gen2_custom_instruction_master_multi_slave_translator0 (
		.ci_slave_dataa      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_dataa),          //  ci_slave.dataa
		.ci_slave_datab      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_datab),          //          .datab
		.ci_slave_result     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_result),         //          .result
		.ci_slave_n          (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_n),              //          .n
		.ci_slave_readra     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readra),         //          .readra
		.ci_slave_readrb     (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_readrb),         //          .readrb
		.ci_slave_writerc    (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_writerc),        //          .writerc
		.ci_slave_a          (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_a),              //          .a
		.ci_slave_b          (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_b),              //          .b
		.ci_slave_c          (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_c),              //          .c
		.ci_slave_ipending   (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_ipending),       //          .ipending
		.ci_slave_estatus    (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_estatus),        //          .estatus
		.ci_slave_clk        (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk),            //          .clk
		.ci_slave_clken      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_clk_en),         //          .clk_en
		.ci_slave_reset_req  (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset_req),      //          .reset_req
		.ci_slave_reset      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_reset),          //          .reset
		.ci_slave_start      (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_start),          //          .start
		.ci_slave_done       (nios2_gen2_custom_instruction_master_multi_xconnect_ci_master0_done),           //          .done
		.ci_master_dataa     (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_dataa),  // ci_master.dataa
		.ci_master_datab     (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_datab),  //          .datab
		.ci_master_result    (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_result), //          .result
		.ci_master_n         (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_n),      //          .n
		.ci_master_clk       (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk),    //          .clk
		.ci_master_clken     (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_clk_en), //          .clk_en
		.ci_master_reset     (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_reset),  //          .reset
		.ci_master_start     (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_start),  //          .start
		.ci_master_done      (nios2_gen2_custom_instruction_master_multi_slave_translator0_ci_master_done),   //          .done
		.ci_master_readra    (),                                                                              // (terminated)
		.ci_master_readrb    (),                                                                              // (terminated)
		.ci_master_writerc   (),                                                                              // (terminated)
		.ci_master_a         (),                                                                              // (terminated)
		.ci_master_b         (),                                                                              // (terminated)
		.ci_master_c         (),                                                                              // (terminated)
		.ci_master_ipending  (),                                                                              // (terminated)
		.ci_master_estatus   (),                                                                              // (terminated)
		.ci_master_reset_req ()                                                                               // (terminated)
	);

	nios_system_mm_interconnect_0 mm_interconnect_0 (
		.clocks_sys_clk_clk                           (clocks_sys_clk_clk),                                        //                         clocks_sys_clk.clk
		.nios2_gen2_reset_reset_bridge_in_reset_reset (rst_controller_reset_out_reset),                            // nios2_gen2_reset_reset_bridge_in_reset.reset
		.nios2_gen2_data_master_address               (nios2_gen2_data_master_address),                            //                 nios2_gen2_data_master.address
		.nios2_gen2_data_master_waitrequest           (nios2_gen2_data_master_waitrequest),                        //                                       .waitrequest
		.nios2_gen2_data_master_byteenable            (nios2_gen2_data_master_byteenable),                         //                                       .byteenable
		.nios2_gen2_data_master_read                  (nios2_gen2_data_master_read),                               //                                       .read
		.nios2_gen2_data_master_readdata              (nios2_gen2_data_master_readdata),                           //                                       .readdata
		.nios2_gen2_data_master_write                 (nios2_gen2_data_master_write),                              //                                       .write
		.nios2_gen2_data_master_writedata             (nios2_gen2_data_master_writedata),                          //                                       .writedata
		.nios2_gen2_data_master_debugaccess           (nios2_gen2_data_master_debugaccess),                        //                                       .debugaccess
		.nios2_gen2_instruction_master_address        (nios2_gen2_instruction_master_address),                     //          nios2_gen2_instruction_master.address
		.nios2_gen2_instruction_master_waitrequest    (nios2_gen2_instruction_master_waitrequest),                 //                                       .waitrequest
		.nios2_gen2_instruction_master_read           (nios2_gen2_instruction_master_read),                        //                                       .read
		.nios2_gen2_instruction_master_readdata       (nios2_gen2_instruction_master_readdata),                    //                                       .readdata
		.jtag_uart_avalon_jtag_slave_address          (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //            jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write            (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),       //                                       .write
		.jtag_uart_avalon_jtag_slave_read             (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),        //                                       .read
		.jtag_uart_avalon_jtag_slave_readdata         (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //                                       .readdata
		.jtag_uart_avalon_jtag_slave_writedata        (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //                                       .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest      (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //                                       .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect       (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //                                       .chipselect
		.leds_s1_address                              (mm_interconnect_0_leds_s1_address),                         //                                leds_s1.address
		.leds_s1_write                                (mm_interconnect_0_leds_s1_write),                           //                                       .write
		.leds_s1_readdata                             (mm_interconnect_0_leds_s1_readdata),                        //                                       .readdata
		.leds_s1_writedata                            (mm_interconnect_0_leds_s1_writedata),                       //                                       .writedata
		.leds_s1_chipselect                           (mm_interconnect_0_leds_s1_chipselect),                      //                                       .chipselect
		.nios2_gen2_debug_mem_slave_address           (mm_interconnect_0_nios2_gen2_debug_mem_slave_address),      //             nios2_gen2_debug_mem_slave.address
		.nios2_gen2_debug_mem_slave_write             (mm_interconnect_0_nios2_gen2_debug_mem_slave_write),        //                                       .write
		.nios2_gen2_debug_mem_slave_read              (mm_interconnect_0_nios2_gen2_debug_mem_slave_read),         //                                       .read
		.nios2_gen2_debug_mem_slave_readdata          (mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata),     //                                       .readdata
		.nios2_gen2_debug_mem_slave_writedata         (mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata),    //                                       .writedata
		.nios2_gen2_debug_mem_slave_byteenable        (mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable),   //                                       .byteenable
		.nios2_gen2_debug_mem_slave_waitrequest       (mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest),  //                                       .waitrequest
		.nios2_gen2_debug_mem_slave_debugaccess       (mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess),  //                                       .debugaccess
		.pushbuttons_s1_address                       (mm_interconnect_0_pushbuttons_s1_address),                  //                         pushbuttons_s1.address
		.pushbuttons_s1_write                         (mm_interconnect_0_pushbuttons_s1_write),                    //                                       .write
		.pushbuttons_s1_readdata                      (mm_interconnect_0_pushbuttons_s1_readdata),                 //                                       .readdata
		.pushbuttons_s1_writedata                     (mm_interconnect_0_pushbuttons_s1_writedata),                //                                       .writedata
		.pushbuttons_s1_chipselect                    (mm_interconnect_0_pushbuttons_s1_chipselect),               //                                       .chipselect
		.sdram_s1_address                             (mm_interconnect_0_sdram_s1_address),                        //                               sdram_s1.address
		.sdram_s1_write                               (mm_interconnect_0_sdram_s1_write),                          //                                       .write
		.sdram_s1_read                                (mm_interconnect_0_sdram_s1_read),                           //                                       .read
		.sdram_s1_readdata                            (mm_interconnect_0_sdram_s1_readdata),                       //                                       .readdata
		.sdram_s1_writedata                           (mm_interconnect_0_sdram_s1_writedata),                      //                                       .writedata
		.sdram_s1_byteenable                          (mm_interconnect_0_sdram_s1_byteenable),                     //                                       .byteenable
		.sdram_s1_readdatavalid                       (mm_interconnect_0_sdram_s1_readdatavalid),                  //                                       .readdatavalid
		.sdram_s1_waitrequest                         (mm_interconnect_0_sdram_s1_waitrequest),                    //                                       .waitrequest
		.sdram_s1_chipselect                          (mm_interconnect_0_sdram_s1_chipselect),                     //                                       .chipselect
		.switches_s1_address                          (mm_interconnect_0_switches_s1_address),                     //                            switches_s1.address
		.switches_s1_readdata                         (mm_interconnect_0_switches_s1_readdata),                    //                                       .readdata
		.timer_s1_address                             (mm_interconnect_0_timer_s1_address),                        //                               timer_s1.address
		.timer_s1_write                               (mm_interconnect_0_timer_s1_write),                          //                                       .write
		.timer_s1_readdata                            (mm_interconnect_0_timer_s1_readdata),                       //                                       .readdata
		.timer_s1_writedata                           (mm_interconnect_0_timer_s1_writedata),                      //                                       .writedata
		.timer_s1_chipselect                          (mm_interconnect_0_timer_s1_chipselect)                      //                                       .chipselect
	);

	nios_system_irq_mapper irq_mapper (
		.clk           (clocks_sys_clk_clk),             //       clk.clk
		.reset         (rst_controller_reset_out_reset), // clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),       // receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),       // receiver1.irq
		.receiver2_irq (irq_mapper_receiver2_irq),       // receiver2.irq
		.sender_irq    (nios2_gen2_irq_irq)              //    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (nios2_gen2_debug_reset_request_reset), // reset_in0.reset
		.reset_in1      (clocks_reset_source_reset),            // reset_in1.reset
		.clk            (clocks_sys_clk_clk),                   //       clk.clk
		.reset_out      (rst_controller_reset_out_reset),       // reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req),   //          .reset_req
		.reset_req_in0  (1'b0),                                 // (terminated)
		.reset_req_in1  (1'b0),                                 // (terminated)
		.reset_in2      (1'b0),                                 // (terminated)
		.reset_req_in2  (1'b0),                                 // (terminated)
		.reset_in3      (1'b0),                                 // (terminated)
		.reset_req_in3  (1'b0),                                 // (terminated)
		.reset_in4      (1'b0),                                 // (terminated)
		.reset_req_in4  (1'b0),                                 // (terminated)
		.reset_in5      (1'b0),                                 // (terminated)
		.reset_req_in5  (1'b0),                                 // (terminated)
		.reset_in6      (1'b0),                                 // (terminated)
		.reset_req_in6  (1'b0),                                 // (terminated)
		.reset_in7      (1'b0),                                 // (terminated)
		.reset_req_in7  (1'b0),                                 // (terminated)
		.reset_in8      (1'b0),                                 // (terminated)
		.reset_req_in8  (1'b0),                                 // (terminated)
		.reset_in9      (1'b0),                                 // (terminated)
		.reset_req_in9  (1'b0),                                 // (terminated)
		.reset_in10     (1'b0),                                 // (terminated)
		.reset_req_in10 (1'b0),                                 // (terminated)
		.reset_in11     (1'b0),                                 // (terminated)
		.reset_req_in11 (1'b0),                                 // (terminated)
		.reset_in12     (1'b0),                                 // (terminated)
		.reset_req_in12 (1'b0),                                 // (terminated)
		.reset_in13     (1'b0),                                 // (terminated)
		.reset_req_in13 (1'b0),                                 // (terminated)
		.reset_in14     (1'b0),                                 // (terminated)
		.reset_req_in14 (1'b0),                                 // (terminated)
		.reset_in15     (1'b0),                                 // (terminated)
		.reset_req_in15 (1'b0)                                  // (terminated)
	);

endmodule
