-- nios_system.vhd

-- Generated using ACDS version 15.1 185

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity nios_system is
	port (
		clk_clk            : in    std_logic                     := '0';             --         clk.clk
		leds_export        : out   std_logic_vector(9 downto 0);                     --        leds.export
		pushbuttons_export : in    std_logic_vector(3 downto 0)  := (others => '0'); -- pushbuttons.export
		reset_reset        : in    std_logic                     := '0';             --       reset.reset
		sdram_clk_clk      : out   std_logic;                                        --   sdram_clk.clk
		sdram_wire_addr    : out   std_logic_vector(12 downto 0);                    --  sdram_wire.addr
		sdram_wire_ba      : out   std_logic_vector(1 downto 0);                     --            .ba
		sdram_wire_cas_n   : out   std_logic;                                        --            .cas_n
		sdram_wire_cke     : out   std_logic;                                        --            .cke
		sdram_wire_cs_n    : out   std_logic;                                        --            .cs_n
		sdram_wire_dq      : inout std_logic_vector(15 downto 0) := (others => '0'); --            .dq
		sdram_wire_dqm     : out   std_logic_vector(1 downto 0);                     --            .dqm
		sdram_wire_ras_n   : out   std_logic;                                        --            .ras_n
		sdram_wire_we_n    : out   std_logic;                                        --            .we_n
		switches_export    : in    std_logic_vector(9 downto 0)  := (others => '0')  --    switches.export
	);
end entity nios_system;

architecture rtl of nios_system is
	component nios_system_clocks is
		port (
			ref_clk_clk        : in  std_logic := 'X'; -- clk
			ref_reset_reset    : in  std_logic := 'X'; -- reset
			sys_clk_clk        : out std_logic;        -- clk
			sdram_clk_clk      : out std_logic;        -- clk
			reset_source_reset : out std_logic         -- reset
		);
	end component nios_system_clocks;

	component nios_system_jtag_uart is
		port (
			clk            : in  std_logic                     := 'X';             -- clk
			rst_n          : in  std_logic                     := 'X';             -- reset_n
			av_chipselect  : in  std_logic                     := 'X';             -- chipselect
			av_address     : in  std_logic                     := 'X';             -- address
			av_read_n      : in  std_logic                     := 'X';             -- read_n
			av_readdata    : out std_logic_vector(31 downto 0);                    -- readdata
			av_write_n     : in  std_logic                     := 'X';             -- write_n
			av_writedata   : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			av_waitrequest : out std_logic;                                        -- waitrequest
			av_irq         : out std_logic                                         -- irq
		);
	end component nios_system_jtag_uart;

	component nios_system_leds is
		port (
			clk        : in  std_logic                     := 'X';             -- clk
			reset_n    : in  std_logic                     := 'X';             -- reset_n
			address    : in  std_logic_vector(1 downto 0)  := (others => 'X'); -- address
			write_n    : in  std_logic                     := 'X';             -- write_n
			writedata  : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			chipselect : in  std_logic                     := 'X';             -- chipselect
			readdata   : out std_logic_vector(31 downto 0);                    -- readdata
			out_port   : out std_logic_vector(9 downto 0)                      -- export
		);
	end component nios_system_leds;

	component nios_system_nios2_gen2 is
		port (
			clk                                 : in  std_logic                     := 'X';             -- clk
			reset_n                             : in  std_logic                     := 'X';             -- reset_n
			reset_req                           : in  std_logic                     := 'X';             -- reset_req
			d_address                           : out std_logic_vector(31 downto 0);                    -- address
			d_byteenable                        : out std_logic_vector(3 downto 0);                     -- byteenable
			d_read                              : out std_logic;                                        -- read
			d_readdata                          : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			d_waitrequest                       : in  std_logic                     := 'X';             -- waitrequest
			d_write                             : out std_logic;                                        -- write
			d_writedata                         : out std_logic_vector(31 downto 0);                    -- writedata
			debug_mem_slave_debugaccess_to_roms : out std_logic;                                        -- debugaccess
			i_address                           : out std_logic_vector(26 downto 0);                    -- address
			i_read                              : out std_logic;                                        -- read
			i_readdata                          : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			i_waitrequest                       : in  std_logic                     := 'X';             -- waitrequest
			irq                                 : in  std_logic_vector(31 downto 0) := (others => 'X'); -- irq
			debug_reset_request                 : out std_logic;                                        -- reset
			debug_mem_slave_address             : in  std_logic_vector(8 downto 0)  := (others => 'X'); -- address
			debug_mem_slave_byteenable          : in  std_logic_vector(3 downto 0)  := (others => 'X'); -- byteenable
			debug_mem_slave_debugaccess         : in  std_logic                     := 'X';             -- debugaccess
			debug_mem_slave_read                : in  std_logic                     := 'X';             -- read
			debug_mem_slave_readdata            : out std_logic_vector(31 downto 0);                    -- readdata
			debug_mem_slave_waitrequest         : out std_logic;                                        -- waitrequest
			debug_mem_slave_write               : in  std_logic                     := 'X';             -- write
			debug_mem_slave_writedata           : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			dummy_ci_port                       : out std_logic                                         -- readra
		);
	end component nios_system_nios2_gen2;

	component nios_system_pushbuttons is
		port (
			clk        : in  std_logic                     := 'X';             -- clk
			reset_n    : in  std_logic                     := 'X';             -- reset_n
			address    : in  std_logic_vector(1 downto 0)  := (others => 'X'); -- address
			write_n    : in  std_logic                     := 'X';             -- write_n
			writedata  : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			chipselect : in  std_logic                     := 'X';             -- chipselect
			readdata   : out std_logic_vector(31 downto 0);                    -- readdata
			in_port    : in  std_logic_vector(3 downto 0)  := (others => 'X'); -- export
			irq        : out std_logic                                         -- irq
		);
	end component nios_system_pushbuttons;

	component nios_system_sdram is
		port (
			clk            : in    std_logic                     := 'X';             -- clk
			reset_n        : in    std_logic                     := 'X';             -- reset_n
			az_addr        : in    std_logic_vector(24 downto 0) := (others => 'X'); -- address
			az_be_n        : in    std_logic_vector(1 downto 0)  := (others => 'X'); -- byteenable_n
			az_cs          : in    std_logic                     := 'X';             -- chipselect
			az_data        : in    std_logic_vector(15 downto 0) := (others => 'X'); -- writedata
			az_rd_n        : in    std_logic                     := 'X';             -- read_n
			az_wr_n        : in    std_logic                     := 'X';             -- write_n
			za_data        : out   std_logic_vector(15 downto 0);                    -- readdata
			za_valid       : out   std_logic;                                        -- readdatavalid
			za_waitrequest : out   std_logic;                                        -- waitrequest
			zs_addr        : out   std_logic_vector(12 downto 0);                    -- export
			zs_ba          : out   std_logic_vector(1 downto 0);                     -- export
			zs_cas_n       : out   std_logic;                                        -- export
			zs_cke         : out   std_logic;                                        -- export
			zs_cs_n        : out   std_logic;                                        -- export
			zs_dq          : inout std_logic_vector(15 downto 0) := (others => 'X'); -- export
			zs_dqm         : out   std_logic_vector(1 downto 0);                     -- export
			zs_ras_n       : out   std_logic;                                        -- export
			zs_we_n        : out   std_logic                                         -- export
		);
	end component nios_system_sdram;

	component nios_system_switches is
		port (
			clk      : in  std_logic                     := 'X';             -- clk
			reset_n  : in  std_logic                     := 'X';             -- reset_n
			address  : in  std_logic_vector(1 downto 0)  := (others => 'X'); -- address
			readdata : out std_logic_vector(31 downto 0);                    -- readdata
			in_port  : in  std_logic_vector(9 downto 0)  := (others => 'X')  -- export
		);
	end component nios_system_switches;

	component nios_system_timer is
		port (
			clk        : in  std_logic                     := 'X';             -- clk
			reset_n    : in  std_logic                     := 'X';             -- reset_n
			address    : in  std_logic_vector(2 downto 0)  := (others => 'X'); -- address
			writedata  : in  std_logic_vector(15 downto 0) := (others => 'X'); -- writedata
			readdata   : out std_logic_vector(15 downto 0);                    -- readdata
			chipselect : in  std_logic                     := 'X';             -- chipselect
			write_n    : in  std_logic                     := 'X';             -- write_n
			irq        : out std_logic                                         -- irq
		);
	end component nios_system_timer;

	component nios_system_mm_interconnect_0 is
		port (
			clocks_sys_clk_clk                           : in  std_logic                     := 'X';             -- clk
			nios2_gen2_reset_reset_bridge_in_reset_reset : in  std_logic                     := 'X';             -- reset
			nios2_gen2_data_master_address               : in  std_logic_vector(31 downto 0) := (others => 'X'); -- address
			nios2_gen2_data_master_waitrequest           : out std_logic;                                        -- waitrequest
			nios2_gen2_data_master_byteenable            : in  std_logic_vector(3 downto 0)  := (others => 'X'); -- byteenable
			nios2_gen2_data_master_read                  : in  std_logic                     := 'X';             -- read
			nios2_gen2_data_master_readdata              : out std_logic_vector(31 downto 0);                    -- readdata
			nios2_gen2_data_master_write                 : in  std_logic                     := 'X';             -- write
			nios2_gen2_data_master_writedata             : in  std_logic_vector(31 downto 0) := (others => 'X'); -- writedata
			nios2_gen2_data_master_debugaccess           : in  std_logic                     := 'X';             -- debugaccess
			nios2_gen2_instruction_master_address        : in  std_logic_vector(26 downto 0) := (others => 'X'); -- address
			nios2_gen2_instruction_master_waitrequest    : out std_logic;                                        -- waitrequest
			nios2_gen2_instruction_master_read           : in  std_logic                     := 'X';             -- read
			nios2_gen2_instruction_master_readdata       : out std_logic_vector(31 downto 0);                    -- readdata
			jtag_uart_avalon_jtag_slave_address          : out std_logic_vector(0 downto 0);                     -- address
			jtag_uart_avalon_jtag_slave_write            : out std_logic;                                        -- write
			jtag_uart_avalon_jtag_slave_read             : out std_logic;                                        -- read
			jtag_uart_avalon_jtag_slave_readdata         : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			jtag_uart_avalon_jtag_slave_writedata        : out std_logic_vector(31 downto 0);                    -- writedata
			jtag_uart_avalon_jtag_slave_waitrequest      : in  std_logic                     := 'X';             -- waitrequest
			jtag_uart_avalon_jtag_slave_chipselect       : out std_logic;                                        -- chipselect
			leds_s1_address                              : out std_logic_vector(1 downto 0);                     -- address
			leds_s1_write                                : out std_logic;                                        -- write
			leds_s1_readdata                             : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			leds_s1_writedata                            : out std_logic_vector(31 downto 0);                    -- writedata
			leds_s1_chipselect                           : out std_logic;                                        -- chipselect
			nios2_gen2_debug_mem_slave_address           : out std_logic_vector(8 downto 0);                     -- address
			nios2_gen2_debug_mem_slave_write             : out std_logic;                                        -- write
			nios2_gen2_debug_mem_slave_read              : out std_logic;                                        -- read
			nios2_gen2_debug_mem_slave_readdata          : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			nios2_gen2_debug_mem_slave_writedata         : out std_logic_vector(31 downto 0);                    -- writedata
			nios2_gen2_debug_mem_slave_byteenable        : out std_logic_vector(3 downto 0);                     -- byteenable
			nios2_gen2_debug_mem_slave_waitrequest       : in  std_logic                     := 'X';             -- waitrequest
			nios2_gen2_debug_mem_slave_debugaccess       : out std_logic;                                        -- debugaccess
			pushbuttons_s1_address                       : out std_logic_vector(1 downto 0);                     -- address
			pushbuttons_s1_write                         : out std_logic;                                        -- write
			pushbuttons_s1_readdata                      : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			pushbuttons_s1_writedata                     : out std_logic_vector(31 downto 0);                    -- writedata
			pushbuttons_s1_chipselect                    : out std_logic;                                        -- chipselect
			sdram_s1_address                             : out std_logic_vector(24 downto 0);                    -- address
			sdram_s1_write                               : out std_logic;                                        -- write
			sdram_s1_read                                : out std_logic;                                        -- read
			sdram_s1_readdata                            : in  std_logic_vector(15 downto 0) := (others => 'X'); -- readdata
			sdram_s1_writedata                           : out std_logic_vector(15 downto 0);                    -- writedata
			sdram_s1_byteenable                          : out std_logic_vector(1 downto 0);                     -- byteenable
			sdram_s1_readdatavalid                       : in  std_logic                     := 'X';             -- readdatavalid
			sdram_s1_waitrequest                         : in  std_logic                     := 'X';             -- waitrequest
			sdram_s1_chipselect                          : out std_logic;                                        -- chipselect
			switches_s1_address                          : out std_logic_vector(1 downto 0);                     -- address
			switches_s1_readdata                         : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			timer_s1_address                             : out std_logic_vector(2 downto 0);                     -- address
			timer_s1_write                               : out std_logic;                                        -- write
			timer_s1_readdata                            : in  std_logic_vector(15 downto 0) := (others => 'X'); -- readdata
			timer_s1_writedata                           : out std_logic_vector(15 downto 0);                    -- writedata
			timer_s1_chipselect                          : out std_logic                                         -- chipselect
		);
	end component nios_system_mm_interconnect_0;

	component nios_system_irq_mapper is
		port (
			clk           : in  std_logic                     := 'X'; -- clk
			reset         : in  std_logic                     := 'X'; -- reset
			receiver0_irq : in  std_logic                     := 'X'; -- irq
			receiver1_irq : in  std_logic                     := 'X'; -- irq
			receiver2_irq : in  std_logic                     := 'X'; -- irq
			sender_irq    : out std_logic_vector(31 downto 0)         -- irq
		);
	end component nios_system_irq_mapper;

	component altera_reset_controller is
		generic (
			NUM_RESET_INPUTS          : integer := 6;
			OUTPUT_RESET_SYNC_EDGES   : string  := "deassert";
			SYNC_DEPTH                : integer := 2;
			RESET_REQUEST_PRESENT     : integer := 0;
			RESET_REQ_WAIT_TIME       : integer := 1;
			MIN_RST_ASSERTION_TIME    : integer := 3;
			RESET_REQ_EARLY_DSRT_TIME : integer := 1;
			USE_RESET_REQUEST_IN0     : integer := 0;
			USE_RESET_REQUEST_IN1     : integer := 0;
			USE_RESET_REQUEST_IN2     : integer := 0;
			USE_RESET_REQUEST_IN3     : integer := 0;
			USE_RESET_REQUEST_IN4     : integer := 0;
			USE_RESET_REQUEST_IN5     : integer := 0;
			USE_RESET_REQUEST_IN6     : integer := 0;
			USE_RESET_REQUEST_IN7     : integer := 0;
			USE_RESET_REQUEST_IN8     : integer := 0;
			USE_RESET_REQUEST_IN9     : integer := 0;
			USE_RESET_REQUEST_IN10    : integer := 0;
			USE_RESET_REQUEST_IN11    : integer := 0;
			USE_RESET_REQUEST_IN12    : integer := 0;
			USE_RESET_REQUEST_IN13    : integer := 0;
			USE_RESET_REQUEST_IN14    : integer := 0;
			USE_RESET_REQUEST_IN15    : integer := 0;
			ADAPT_RESET_REQUEST       : integer := 0
		);
		port (
			reset_in0      : in  std_logic := 'X'; -- reset
			reset_in1      : in  std_logic := 'X'; -- reset
			clk            : in  std_logic := 'X'; -- clk
			reset_out      : out std_logic;        -- reset
			reset_req      : out std_logic;        -- reset_req
			reset_req_in0  : in  std_logic := 'X'; -- reset_req
			reset_req_in1  : in  std_logic := 'X'; -- reset_req
			reset_in2      : in  std_logic := 'X'; -- reset
			reset_req_in2  : in  std_logic := 'X'; -- reset_req
			reset_in3      : in  std_logic := 'X'; -- reset
			reset_req_in3  : in  std_logic := 'X'; -- reset_req
			reset_in4      : in  std_logic := 'X'; -- reset
			reset_req_in4  : in  std_logic := 'X'; -- reset_req
			reset_in5      : in  std_logic := 'X'; -- reset
			reset_req_in5  : in  std_logic := 'X'; -- reset_req
			reset_in6      : in  std_logic := 'X'; -- reset
			reset_req_in6  : in  std_logic := 'X'; -- reset_req
			reset_in7      : in  std_logic := 'X'; -- reset
			reset_req_in7  : in  std_logic := 'X'; -- reset_req
			reset_in8      : in  std_logic := 'X'; -- reset
			reset_req_in8  : in  std_logic := 'X'; -- reset_req
			reset_in9      : in  std_logic := 'X'; -- reset
			reset_req_in9  : in  std_logic := 'X'; -- reset_req
			reset_in10     : in  std_logic := 'X'; -- reset
			reset_req_in10 : in  std_logic := 'X'; -- reset_req
			reset_in11     : in  std_logic := 'X'; -- reset
			reset_req_in11 : in  std_logic := 'X'; -- reset_req
			reset_in12     : in  std_logic := 'X'; -- reset
			reset_req_in12 : in  std_logic := 'X'; -- reset_req
			reset_in13     : in  std_logic := 'X'; -- reset
			reset_req_in13 : in  std_logic := 'X'; -- reset_req
			reset_in14     : in  std_logic := 'X'; -- reset
			reset_req_in14 : in  std_logic := 'X'; -- reset_req
			reset_in15     : in  std_logic := 'X'; -- reset
			reset_req_in15 : in  std_logic := 'X'  -- reset_req
		);
	end component altera_reset_controller;

	signal clocks_sys_clk_clk                                            : std_logic;                     -- clocks:sys_clk_clk -> [irq_mapper:clk, jtag_uart:clk, leds:clk, mm_interconnect_0:clocks_sys_clk_clk, nios2_gen2:clk, pushbuttons:clk, rst_controller:clk, sdram:clk, switches:clk, timer:clk]
	signal nios2_gen2_data_master_readdata                               : std_logic_vector(31 downto 0); -- mm_interconnect_0:nios2_gen2_data_master_readdata -> nios2_gen2:d_readdata
	signal nios2_gen2_data_master_waitrequest                            : std_logic;                     -- mm_interconnect_0:nios2_gen2_data_master_waitrequest -> nios2_gen2:d_waitrequest
	signal nios2_gen2_data_master_debugaccess                            : std_logic;                     -- nios2_gen2:debug_mem_slave_debugaccess_to_roms -> mm_interconnect_0:nios2_gen2_data_master_debugaccess
	signal nios2_gen2_data_master_address                                : std_logic_vector(31 downto 0); -- nios2_gen2:d_address -> mm_interconnect_0:nios2_gen2_data_master_address
	signal nios2_gen2_data_master_byteenable                             : std_logic_vector(3 downto 0);  -- nios2_gen2:d_byteenable -> mm_interconnect_0:nios2_gen2_data_master_byteenable
	signal nios2_gen2_data_master_read                                   : std_logic;                     -- nios2_gen2:d_read -> mm_interconnect_0:nios2_gen2_data_master_read
	signal nios2_gen2_data_master_write                                  : std_logic;                     -- nios2_gen2:d_write -> mm_interconnect_0:nios2_gen2_data_master_write
	signal nios2_gen2_data_master_writedata                              : std_logic_vector(31 downto 0); -- nios2_gen2:d_writedata -> mm_interconnect_0:nios2_gen2_data_master_writedata
	signal nios2_gen2_instruction_master_readdata                        : std_logic_vector(31 downto 0); -- mm_interconnect_0:nios2_gen2_instruction_master_readdata -> nios2_gen2:i_readdata
	signal nios2_gen2_instruction_master_waitrequest                     : std_logic;                     -- mm_interconnect_0:nios2_gen2_instruction_master_waitrequest -> nios2_gen2:i_waitrequest
	signal nios2_gen2_instruction_master_address                         : std_logic_vector(26 downto 0); -- nios2_gen2:i_address -> mm_interconnect_0:nios2_gen2_instruction_master_address
	signal nios2_gen2_instruction_master_read                            : std_logic;                     -- nios2_gen2:i_read -> mm_interconnect_0:nios2_gen2_instruction_master_read
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect      : std_logic;                     -- mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata        : std_logic_vector(31 downto 0); -- jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest     : std_logic;                     -- jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_address         : std_logic_vector(0 downto 0);  -- mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_read            : std_logic;                     -- mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> mm_interconnect_0_jtag_uart_avalon_jtag_slave_read:in
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_write           : std_logic;                     -- mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> mm_interconnect_0_jtag_uart_avalon_jtag_slave_write:in
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata       : std_logic_vector(31 downto 0); -- mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata         : std_logic_vector(31 downto 0); -- nios2_gen2:debug_mem_slave_readdata -> mm_interconnect_0:nios2_gen2_debug_mem_slave_readdata
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest      : std_logic;                     -- nios2_gen2:debug_mem_slave_waitrequest -> mm_interconnect_0:nios2_gen2_debug_mem_slave_waitrequest
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess      : std_logic;                     -- mm_interconnect_0:nios2_gen2_debug_mem_slave_debugaccess -> nios2_gen2:debug_mem_slave_debugaccess
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_address          : std_logic_vector(8 downto 0);  -- mm_interconnect_0:nios2_gen2_debug_mem_slave_address -> nios2_gen2:debug_mem_slave_address
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_read             : std_logic;                     -- mm_interconnect_0:nios2_gen2_debug_mem_slave_read -> nios2_gen2:debug_mem_slave_read
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable       : std_logic_vector(3 downto 0);  -- mm_interconnect_0:nios2_gen2_debug_mem_slave_byteenable -> nios2_gen2:debug_mem_slave_byteenable
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_write            : std_logic;                     -- mm_interconnect_0:nios2_gen2_debug_mem_slave_write -> nios2_gen2:debug_mem_slave_write
	signal mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata        : std_logic_vector(31 downto 0); -- mm_interconnect_0:nios2_gen2_debug_mem_slave_writedata -> nios2_gen2:debug_mem_slave_writedata
	signal mm_interconnect_0_switches_s1_readdata                        : std_logic_vector(31 downto 0); -- switches:readdata -> mm_interconnect_0:switches_s1_readdata
	signal mm_interconnect_0_switches_s1_address                         : std_logic_vector(1 downto 0);  -- mm_interconnect_0:switches_s1_address -> switches:address
	signal mm_interconnect_0_leds_s1_chipselect                          : std_logic;                     -- mm_interconnect_0:leds_s1_chipselect -> leds:chipselect
	signal mm_interconnect_0_leds_s1_readdata                            : std_logic_vector(31 downto 0); -- leds:readdata -> mm_interconnect_0:leds_s1_readdata
	signal mm_interconnect_0_leds_s1_address                             : std_logic_vector(1 downto 0);  -- mm_interconnect_0:leds_s1_address -> leds:address
	signal mm_interconnect_0_leds_s1_write                               : std_logic;                     -- mm_interconnect_0:leds_s1_write -> mm_interconnect_0_leds_s1_write:in
	signal mm_interconnect_0_leds_s1_writedata                           : std_logic_vector(31 downto 0); -- mm_interconnect_0:leds_s1_writedata -> leds:writedata
	signal mm_interconnect_0_timer_s1_chipselect                         : std_logic;                     -- mm_interconnect_0:timer_s1_chipselect -> timer:chipselect
	signal mm_interconnect_0_timer_s1_readdata                           : std_logic_vector(15 downto 0); -- timer:readdata -> mm_interconnect_0:timer_s1_readdata
	signal mm_interconnect_0_timer_s1_address                            : std_logic_vector(2 downto 0);  -- mm_interconnect_0:timer_s1_address -> timer:address
	signal mm_interconnect_0_timer_s1_write                              : std_logic;                     -- mm_interconnect_0:timer_s1_write -> mm_interconnect_0_timer_s1_write:in
	signal mm_interconnect_0_timer_s1_writedata                          : std_logic_vector(15 downto 0); -- mm_interconnect_0:timer_s1_writedata -> timer:writedata
	signal mm_interconnect_0_sdram_s1_chipselect                         : std_logic;                     -- mm_interconnect_0:sdram_s1_chipselect -> sdram:az_cs
	signal mm_interconnect_0_sdram_s1_readdata                           : std_logic_vector(15 downto 0); -- sdram:za_data -> mm_interconnect_0:sdram_s1_readdata
	signal mm_interconnect_0_sdram_s1_waitrequest                        : std_logic;                     -- sdram:za_waitrequest -> mm_interconnect_0:sdram_s1_waitrequest
	signal mm_interconnect_0_sdram_s1_address                            : std_logic_vector(24 downto 0); -- mm_interconnect_0:sdram_s1_address -> sdram:az_addr
	signal mm_interconnect_0_sdram_s1_read                               : std_logic;                     -- mm_interconnect_0:sdram_s1_read -> mm_interconnect_0_sdram_s1_read:in
	signal mm_interconnect_0_sdram_s1_byteenable                         : std_logic_vector(1 downto 0);  -- mm_interconnect_0:sdram_s1_byteenable -> mm_interconnect_0_sdram_s1_byteenable:in
	signal mm_interconnect_0_sdram_s1_readdatavalid                      : std_logic;                     -- sdram:za_valid -> mm_interconnect_0:sdram_s1_readdatavalid
	signal mm_interconnect_0_sdram_s1_write                              : std_logic;                     -- mm_interconnect_0:sdram_s1_write -> mm_interconnect_0_sdram_s1_write:in
	signal mm_interconnect_0_sdram_s1_writedata                          : std_logic_vector(15 downto 0); -- mm_interconnect_0:sdram_s1_writedata -> sdram:az_data
	signal mm_interconnect_0_pushbuttons_s1_chipselect                   : std_logic;                     -- mm_interconnect_0:pushbuttons_s1_chipselect -> pushbuttons:chipselect
	signal mm_interconnect_0_pushbuttons_s1_readdata                     : std_logic_vector(31 downto 0); -- pushbuttons:readdata -> mm_interconnect_0:pushbuttons_s1_readdata
	signal mm_interconnect_0_pushbuttons_s1_address                      : std_logic_vector(1 downto 0);  -- mm_interconnect_0:pushbuttons_s1_address -> pushbuttons:address
	signal mm_interconnect_0_pushbuttons_s1_write                        : std_logic;                     -- mm_interconnect_0:pushbuttons_s1_write -> mm_interconnect_0_pushbuttons_s1_write:in
	signal mm_interconnect_0_pushbuttons_s1_writedata                    : std_logic_vector(31 downto 0); -- mm_interconnect_0:pushbuttons_s1_writedata -> pushbuttons:writedata
	signal irq_mapper_receiver0_irq                                      : std_logic;                     -- jtag_uart:av_irq -> irq_mapper:receiver0_irq
	signal irq_mapper_receiver1_irq                                      : std_logic;                     -- timer:irq -> irq_mapper:receiver1_irq
	signal irq_mapper_receiver2_irq                                      : std_logic;                     -- pushbuttons:irq -> irq_mapper:receiver2_irq
	signal nios2_gen2_irq_irq                                            : std_logic_vector(31 downto 0); -- irq_mapper:sender_irq -> nios2_gen2:irq
	signal rst_controller_reset_out_reset                                : std_logic;                     -- rst_controller:reset_out -> [irq_mapper:reset, mm_interconnect_0:nios2_gen2_reset_reset_bridge_in_reset_reset, rst_controller_reset_out_reset:in, rst_translator:in_reset]
	signal rst_controller_reset_out_reset_req                            : std_logic;                     -- rst_controller:reset_req -> [nios2_gen2:reset_req, rst_translator:reset_req_in]
	signal nios2_gen2_debug_reset_request_reset                          : std_logic;                     -- nios2_gen2:debug_reset_request -> rst_controller:reset_in0
	signal clocks_reset_source_reset                                     : std_logic;                     -- clocks:reset_source_reset -> rst_controller:reset_in1
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_read_ports_inv  : std_logic;                     -- mm_interconnect_0_jtag_uart_avalon_jtag_slave_read:inv -> jtag_uart:av_read_n
	signal mm_interconnect_0_jtag_uart_avalon_jtag_slave_write_ports_inv : std_logic;                     -- mm_interconnect_0_jtag_uart_avalon_jtag_slave_write:inv -> jtag_uart:av_write_n
	signal mm_interconnect_0_leds_s1_write_ports_inv                     : std_logic;                     -- mm_interconnect_0_leds_s1_write:inv -> leds:write_n
	signal mm_interconnect_0_timer_s1_write_ports_inv                    : std_logic;                     -- mm_interconnect_0_timer_s1_write:inv -> timer:write_n
	signal mm_interconnect_0_sdram_s1_read_ports_inv                     : std_logic;                     -- mm_interconnect_0_sdram_s1_read:inv -> sdram:az_rd_n
	signal mm_interconnect_0_sdram_s1_byteenable_ports_inv               : std_logic_vector(1 downto 0);  -- mm_interconnect_0_sdram_s1_byteenable:inv -> sdram:az_be_n
	signal mm_interconnect_0_sdram_s1_write_ports_inv                    : std_logic;                     -- mm_interconnect_0_sdram_s1_write:inv -> sdram:az_wr_n
	signal mm_interconnect_0_pushbuttons_s1_write_ports_inv              : std_logic;                     -- mm_interconnect_0_pushbuttons_s1_write:inv -> pushbuttons:write_n
	signal rst_controller_reset_out_reset_ports_inv                      : std_logic;                     -- rst_controller_reset_out_reset:inv -> [jtag_uart:rst_n, leds:reset_n, nios2_gen2:reset_n, pushbuttons:reset_n, sdram:reset_n, switches:reset_n, timer:reset_n]

begin

	clocks : component nios_system_clocks
		port map (
			ref_clk_clk        => clk_clk,                   --      ref_clk.clk
			ref_reset_reset    => reset_reset,               --    ref_reset.reset
			sys_clk_clk        => clocks_sys_clk_clk,        --      sys_clk.clk
			sdram_clk_clk      => sdram_clk_clk,             --    sdram_clk.clk
			reset_source_reset => clocks_reset_source_reset  -- reset_source.reset
		);

	jtag_uart : component nios_system_jtag_uart
		port map (
			clk            => clocks_sys_clk_clk,                                            --               clk.clk
			rst_n          => rst_controller_reset_out_reset_ports_inv,                      --             reset.reset_n
			av_chipselect  => mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect,      -- avalon_jtag_slave.chipselect
			av_address     => mm_interconnect_0_jtag_uart_avalon_jtag_slave_address(0),      --                  .address
			av_read_n      => mm_interconnect_0_jtag_uart_avalon_jtag_slave_read_ports_inv,  --                  .read_n
			av_readdata    => mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata,        --                  .readdata
			av_write_n     => mm_interconnect_0_jtag_uart_avalon_jtag_slave_write_ports_inv, --                  .write_n
			av_writedata   => mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata,       --                  .writedata
			av_waitrequest => mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest,     --                  .waitrequest
			av_irq         => irq_mapper_receiver0_irq                                       --               irq.irq
		);

	leds : component nios_system_leds
		port map (
			clk        => clocks_sys_clk_clk,                        --                 clk.clk
			reset_n    => rst_controller_reset_out_reset_ports_inv,  --               reset.reset_n
			address    => mm_interconnect_0_leds_s1_address,         --                  s1.address
			write_n    => mm_interconnect_0_leds_s1_write_ports_inv, --                    .write_n
			writedata  => mm_interconnect_0_leds_s1_writedata,       --                    .writedata
			chipselect => mm_interconnect_0_leds_s1_chipselect,      --                    .chipselect
			readdata   => mm_interconnect_0_leds_s1_readdata,        --                    .readdata
			out_port   => leds_export                                -- external_connection.export
		);

	nios2_gen2 : component nios_system_nios2_gen2
		port map (
			clk                                 => clocks_sys_clk_clk,                                       --                       clk.clk
			reset_n                             => rst_controller_reset_out_reset_ports_inv,                 --                     reset.reset_n
			reset_req                           => rst_controller_reset_out_reset_req,                       --                          .reset_req
			d_address                           => nios2_gen2_data_master_address,                           --               data_master.address
			d_byteenable                        => nios2_gen2_data_master_byteenable,                        --                          .byteenable
			d_read                              => nios2_gen2_data_master_read,                              --                          .read
			d_readdata                          => nios2_gen2_data_master_readdata,                          --                          .readdata
			d_waitrequest                       => nios2_gen2_data_master_waitrequest,                       --                          .waitrequest
			d_write                             => nios2_gen2_data_master_write,                             --                          .write
			d_writedata                         => nios2_gen2_data_master_writedata,                         --                          .writedata
			debug_mem_slave_debugaccess_to_roms => nios2_gen2_data_master_debugaccess,                       --                          .debugaccess
			i_address                           => nios2_gen2_instruction_master_address,                    --        instruction_master.address
			i_read                              => nios2_gen2_instruction_master_read,                       --                          .read
			i_readdata                          => nios2_gen2_instruction_master_readdata,                   --                          .readdata
			i_waitrequest                       => nios2_gen2_instruction_master_waitrequest,                --                          .waitrequest
			irq                                 => nios2_gen2_irq_irq,                                       --                       irq.irq
			debug_reset_request                 => nios2_gen2_debug_reset_request_reset,                     --       debug_reset_request.reset
			debug_mem_slave_address             => mm_interconnect_0_nios2_gen2_debug_mem_slave_address,     --           debug_mem_slave.address
			debug_mem_slave_byteenable          => mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable,  --                          .byteenable
			debug_mem_slave_debugaccess         => mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess, --                          .debugaccess
			debug_mem_slave_read                => mm_interconnect_0_nios2_gen2_debug_mem_slave_read,        --                          .read
			debug_mem_slave_readdata            => mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata,    --                          .readdata
			debug_mem_slave_waitrequest         => mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest, --                          .waitrequest
			debug_mem_slave_write               => mm_interconnect_0_nios2_gen2_debug_mem_slave_write,       --                          .write
			debug_mem_slave_writedata           => mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata,   --                          .writedata
			dummy_ci_port                       => open                                                      -- custom_instruction_master.readra
		);

	pushbuttons : component nios_system_pushbuttons
		port map (
			clk        => clocks_sys_clk_clk,                               --                 clk.clk
			reset_n    => rst_controller_reset_out_reset_ports_inv,         --               reset.reset_n
			address    => mm_interconnect_0_pushbuttons_s1_address,         --                  s1.address
			write_n    => mm_interconnect_0_pushbuttons_s1_write_ports_inv, --                    .write_n
			writedata  => mm_interconnect_0_pushbuttons_s1_writedata,       --                    .writedata
			chipselect => mm_interconnect_0_pushbuttons_s1_chipselect,      --                    .chipselect
			readdata   => mm_interconnect_0_pushbuttons_s1_readdata,        --                    .readdata
			in_port    => pushbuttons_export,                               -- external_connection.export
			irq        => irq_mapper_receiver2_irq                          --                 irq.irq
		);

	sdram : component nios_system_sdram
		port map (
			clk            => clocks_sys_clk_clk,                              --   clk.clk
			reset_n        => rst_controller_reset_out_reset_ports_inv,        -- reset.reset_n
			az_addr        => mm_interconnect_0_sdram_s1_address,              --    s1.address
			az_be_n        => mm_interconnect_0_sdram_s1_byteenable_ports_inv, --      .byteenable_n
			az_cs          => mm_interconnect_0_sdram_s1_chipselect,           --      .chipselect
			az_data        => mm_interconnect_0_sdram_s1_writedata,            --      .writedata
			az_rd_n        => mm_interconnect_0_sdram_s1_read_ports_inv,       --      .read_n
			az_wr_n        => mm_interconnect_0_sdram_s1_write_ports_inv,      --      .write_n
			za_data        => mm_interconnect_0_sdram_s1_readdata,             --      .readdata
			za_valid       => mm_interconnect_0_sdram_s1_readdatavalid,        --      .readdatavalid
			za_waitrequest => mm_interconnect_0_sdram_s1_waitrequest,          --      .waitrequest
			zs_addr        => sdram_wire_addr,                                 --  wire.export
			zs_ba          => sdram_wire_ba,                                   --      .export
			zs_cas_n       => sdram_wire_cas_n,                                --      .export
			zs_cke         => sdram_wire_cke,                                  --      .export
			zs_cs_n        => sdram_wire_cs_n,                                 --      .export
			zs_dq          => sdram_wire_dq,                                   --      .export
			zs_dqm         => sdram_wire_dqm,                                  --      .export
			zs_ras_n       => sdram_wire_ras_n,                                --      .export
			zs_we_n        => sdram_wire_we_n                                  --      .export
		);

	switches : component nios_system_switches
		port map (
			clk      => clocks_sys_clk_clk,                       --                 clk.clk
			reset_n  => rst_controller_reset_out_reset_ports_inv, --               reset.reset_n
			address  => mm_interconnect_0_switches_s1_address,    --                  s1.address
			readdata => mm_interconnect_0_switches_s1_readdata,   --                    .readdata
			in_port  => switches_export                           -- external_connection.export
		);

	timer : component nios_system_timer
		port map (
			clk        => clocks_sys_clk_clk,                         --   clk.clk
			reset_n    => rst_controller_reset_out_reset_ports_inv,   -- reset.reset_n
			address    => mm_interconnect_0_timer_s1_address,         --    s1.address
			writedata  => mm_interconnect_0_timer_s1_writedata,       --      .writedata
			readdata   => mm_interconnect_0_timer_s1_readdata,        --      .readdata
			chipselect => mm_interconnect_0_timer_s1_chipselect,      --      .chipselect
			write_n    => mm_interconnect_0_timer_s1_write_ports_inv, --      .write_n
			irq        => irq_mapper_receiver1_irq                    --   irq.irq
		);

	mm_interconnect_0 : component nios_system_mm_interconnect_0
		port map (
			clocks_sys_clk_clk                           => clocks_sys_clk_clk,                                        --                         clocks_sys_clk.clk
			nios2_gen2_reset_reset_bridge_in_reset_reset => rst_controller_reset_out_reset,                            -- nios2_gen2_reset_reset_bridge_in_reset.reset
			nios2_gen2_data_master_address               => nios2_gen2_data_master_address,                            --                 nios2_gen2_data_master.address
			nios2_gen2_data_master_waitrequest           => nios2_gen2_data_master_waitrequest,                        --                                       .waitrequest
			nios2_gen2_data_master_byteenable            => nios2_gen2_data_master_byteenable,                         --                                       .byteenable
			nios2_gen2_data_master_read                  => nios2_gen2_data_master_read,                               --                                       .read
			nios2_gen2_data_master_readdata              => nios2_gen2_data_master_readdata,                           --                                       .readdata
			nios2_gen2_data_master_write                 => nios2_gen2_data_master_write,                              --                                       .write
			nios2_gen2_data_master_writedata             => nios2_gen2_data_master_writedata,                          --                                       .writedata
			nios2_gen2_data_master_debugaccess           => nios2_gen2_data_master_debugaccess,                        --                                       .debugaccess
			nios2_gen2_instruction_master_address        => nios2_gen2_instruction_master_address,                     --          nios2_gen2_instruction_master.address
			nios2_gen2_instruction_master_waitrequest    => nios2_gen2_instruction_master_waitrequest,                 --                                       .waitrequest
			nios2_gen2_instruction_master_read           => nios2_gen2_instruction_master_read,                        --                                       .read
			nios2_gen2_instruction_master_readdata       => nios2_gen2_instruction_master_readdata,                    --                                       .readdata
			jtag_uart_avalon_jtag_slave_address          => mm_interconnect_0_jtag_uart_avalon_jtag_slave_address,     --            jtag_uart_avalon_jtag_slave.address
			jtag_uart_avalon_jtag_slave_write            => mm_interconnect_0_jtag_uart_avalon_jtag_slave_write,       --                                       .write
			jtag_uart_avalon_jtag_slave_read             => mm_interconnect_0_jtag_uart_avalon_jtag_slave_read,        --                                       .read
			jtag_uart_avalon_jtag_slave_readdata         => mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata,    --                                       .readdata
			jtag_uart_avalon_jtag_slave_writedata        => mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata,   --                                       .writedata
			jtag_uart_avalon_jtag_slave_waitrequest      => mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest, --                                       .waitrequest
			jtag_uart_avalon_jtag_slave_chipselect       => mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect,  --                                       .chipselect
			leds_s1_address                              => mm_interconnect_0_leds_s1_address,                         --                                leds_s1.address
			leds_s1_write                                => mm_interconnect_0_leds_s1_write,                           --                                       .write
			leds_s1_readdata                             => mm_interconnect_0_leds_s1_readdata,                        --                                       .readdata
			leds_s1_writedata                            => mm_interconnect_0_leds_s1_writedata,                       --                                       .writedata
			leds_s1_chipselect                           => mm_interconnect_0_leds_s1_chipselect,                      --                                       .chipselect
			nios2_gen2_debug_mem_slave_address           => mm_interconnect_0_nios2_gen2_debug_mem_slave_address,      --             nios2_gen2_debug_mem_slave.address
			nios2_gen2_debug_mem_slave_write             => mm_interconnect_0_nios2_gen2_debug_mem_slave_write,        --                                       .write
			nios2_gen2_debug_mem_slave_read              => mm_interconnect_0_nios2_gen2_debug_mem_slave_read,         --                                       .read
			nios2_gen2_debug_mem_slave_readdata          => mm_interconnect_0_nios2_gen2_debug_mem_slave_readdata,     --                                       .readdata
			nios2_gen2_debug_mem_slave_writedata         => mm_interconnect_0_nios2_gen2_debug_mem_slave_writedata,    --                                       .writedata
			nios2_gen2_debug_mem_slave_byteenable        => mm_interconnect_0_nios2_gen2_debug_mem_slave_byteenable,   --                                       .byteenable
			nios2_gen2_debug_mem_slave_waitrequest       => mm_interconnect_0_nios2_gen2_debug_mem_slave_waitrequest,  --                                       .waitrequest
			nios2_gen2_debug_mem_slave_debugaccess       => mm_interconnect_0_nios2_gen2_debug_mem_slave_debugaccess,  --                                       .debugaccess
			pushbuttons_s1_address                       => mm_interconnect_0_pushbuttons_s1_address,                  --                         pushbuttons_s1.address
			pushbuttons_s1_write                         => mm_interconnect_0_pushbuttons_s1_write,                    --                                       .write
			pushbuttons_s1_readdata                      => mm_interconnect_0_pushbuttons_s1_readdata,                 --                                       .readdata
			pushbuttons_s1_writedata                     => mm_interconnect_0_pushbuttons_s1_writedata,                --                                       .writedata
			pushbuttons_s1_chipselect                    => mm_interconnect_0_pushbuttons_s1_chipselect,               --                                       .chipselect
			sdram_s1_address                             => mm_interconnect_0_sdram_s1_address,                        --                               sdram_s1.address
			sdram_s1_write                               => mm_interconnect_0_sdram_s1_write,                          --                                       .write
			sdram_s1_read                                => mm_interconnect_0_sdram_s1_read,                           --                                       .read
			sdram_s1_readdata                            => mm_interconnect_0_sdram_s1_readdata,                       --                                       .readdata
			sdram_s1_writedata                           => mm_interconnect_0_sdram_s1_writedata,                      --                                       .writedata
			sdram_s1_byteenable                          => mm_interconnect_0_sdram_s1_byteenable,                     --                                       .byteenable
			sdram_s1_readdatavalid                       => mm_interconnect_0_sdram_s1_readdatavalid,                  --                                       .readdatavalid
			sdram_s1_waitrequest                         => mm_interconnect_0_sdram_s1_waitrequest,                    --                                       .waitrequest
			sdram_s1_chipselect                          => mm_interconnect_0_sdram_s1_chipselect,                     --                                       .chipselect
			switches_s1_address                          => mm_interconnect_0_switches_s1_address,                     --                            switches_s1.address
			switches_s1_readdata                         => mm_interconnect_0_switches_s1_readdata,                    --                                       .readdata
			timer_s1_address                             => mm_interconnect_0_timer_s1_address,                        --                               timer_s1.address
			timer_s1_write                               => mm_interconnect_0_timer_s1_write,                          --                                       .write
			timer_s1_readdata                            => mm_interconnect_0_timer_s1_readdata,                       --                                       .readdata
			timer_s1_writedata                           => mm_interconnect_0_timer_s1_writedata,                      --                                       .writedata
			timer_s1_chipselect                          => mm_interconnect_0_timer_s1_chipselect                      --                                       .chipselect
		);

	irq_mapper : component nios_system_irq_mapper
		port map (
			clk           => clocks_sys_clk_clk,             --       clk.clk
			reset         => rst_controller_reset_out_reset, -- clk_reset.reset
			receiver0_irq => irq_mapper_receiver0_irq,       -- receiver0.irq
			receiver1_irq => irq_mapper_receiver1_irq,       -- receiver1.irq
			receiver2_irq => irq_mapper_receiver2_irq,       -- receiver2.irq
			sender_irq    => nios2_gen2_irq_irq              --    sender.irq
		);

	rst_controller : component altera_reset_controller
		generic map (
			NUM_RESET_INPUTS          => 2,
			OUTPUT_RESET_SYNC_EDGES   => "deassert",
			SYNC_DEPTH                => 2,
			RESET_REQUEST_PRESENT     => 1,
			RESET_REQ_WAIT_TIME       => 1,
			MIN_RST_ASSERTION_TIME    => 3,
			RESET_REQ_EARLY_DSRT_TIME => 1,
			USE_RESET_REQUEST_IN0     => 0,
			USE_RESET_REQUEST_IN1     => 0,
			USE_RESET_REQUEST_IN2     => 0,
			USE_RESET_REQUEST_IN3     => 0,
			USE_RESET_REQUEST_IN4     => 0,
			USE_RESET_REQUEST_IN5     => 0,
			USE_RESET_REQUEST_IN6     => 0,
			USE_RESET_REQUEST_IN7     => 0,
			USE_RESET_REQUEST_IN8     => 0,
			USE_RESET_REQUEST_IN9     => 0,
			USE_RESET_REQUEST_IN10    => 0,
			USE_RESET_REQUEST_IN11    => 0,
			USE_RESET_REQUEST_IN12    => 0,
			USE_RESET_REQUEST_IN13    => 0,
			USE_RESET_REQUEST_IN14    => 0,
			USE_RESET_REQUEST_IN15    => 0,
			ADAPT_RESET_REQUEST       => 0
		)
		port map (
			reset_in0      => nios2_gen2_debug_reset_request_reset, -- reset_in0.reset
			reset_in1      => clocks_reset_source_reset,            -- reset_in1.reset
			clk            => clocks_sys_clk_clk,                   --       clk.clk
			reset_out      => rst_controller_reset_out_reset,       -- reset_out.reset
			reset_req      => rst_controller_reset_out_reset_req,   --          .reset_req
			reset_req_in0  => '0',                                  -- (terminated)
			reset_req_in1  => '0',                                  -- (terminated)
			reset_in2      => '0',                                  -- (terminated)
			reset_req_in2  => '0',                                  -- (terminated)
			reset_in3      => '0',                                  -- (terminated)
			reset_req_in3  => '0',                                  -- (terminated)
			reset_in4      => '0',                                  -- (terminated)
			reset_req_in4  => '0',                                  -- (terminated)
			reset_in5      => '0',                                  -- (terminated)
			reset_req_in5  => '0',                                  -- (terminated)
			reset_in6      => '0',                                  -- (terminated)
			reset_req_in6  => '0',                                  -- (terminated)
			reset_in7      => '0',                                  -- (terminated)
			reset_req_in7  => '0',                                  -- (terminated)
			reset_in8      => '0',                                  -- (terminated)
			reset_req_in8  => '0',                                  -- (terminated)
			reset_in9      => '0',                                  -- (terminated)
			reset_req_in9  => '0',                                  -- (terminated)
			reset_in10     => '0',                                  -- (terminated)
			reset_req_in10 => '0',                                  -- (terminated)
			reset_in11     => '0',                                  -- (terminated)
			reset_req_in11 => '0',                                  -- (terminated)
			reset_in12     => '0',                                  -- (terminated)
			reset_req_in12 => '0',                                  -- (terminated)
			reset_in13     => '0',                                  -- (terminated)
			reset_req_in13 => '0',                                  -- (terminated)
			reset_in14     => '0',                                  -- (terminated)
			reset_req_in14 => '0',                                  -- (terminated)
			reset_in15     => '0',                                  -- (terminated)
			reset_req_in15 => '0'                                   -- (terminated)
		);

	mm_interconnect_0_jtag_uart_avalon_jtag_slave_read_ports_inv <= not mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;

	mm_interconnect_0_jtag_uart_avalon_jtag_slave_write_ports_inv <= not mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;

	mm_interconnect_0_leds_s1_write_ports_inv <= not mm_interconnect_0_leds_s1_write;

	mm_interconnect_0_timer_s1_write_ports_inv <= not mm_interconnect_0_timer_s1_write;

	mm_interconnect_0_sdram_s1_read_ports_inv <= not mm_interconnect_0_sdram_s1_read;

	mm_interconnect_0_sdram_s1_byteenable_ports_inv <= not mm_interconnect_0_sdram_s1_byteenable;

	mm_interconnect_0_sdram_s1_write_ports_inv <= not mm_interconnect_0_sdram_s1_write;

	mm_interconnect_0_pushbuttons_s1_write_ports_inv <= not mm_interconnect_0_pushbuttons_s1_write;

	rst_controller_reset_out_reset_ports_inv <= not rst_controller_reset_out_reset;

end architecture rtl; -- of nios_system
