//#include "address_map_arm.h"
#include "address_map_nios2.h"
#include <stdio.h>  /* printf */
#include <stdlib.h>  /* srand, rand */
#include <math.h>

/* function prototypes */
void wait (int s );
void DEC3(char, char, char);
void VGA_text (int, int, char *);
void VGA_box (int, int, int, int, char);
void draw_line(int , int , int , int , char );

int main(void)
{
/* The base addresses of devices are listed in the "BSP/system.h" file*/
	volatile int * KEY_ptr = (int *) KEY_BASE;
	int KEY_value;

/* used for clock */
  int start_time, finish_time, total_time;
  int min, sec, hour, inc=1, loc;
  int k, xcenter, ycenter, xradius, yradius;
  char colors[3]={0x80, 0xFF, 0x40}; //gray=0;white=1;dark=2

/* for plot */
  char pixel_color;
  int pixel_ptr;

/* used for drawing coordinates */
  int x0, y0, x1, y1, x2, y2, x3, y3, x4, y4;

/* create a message to be displayed on the VGA display */
  char text_top_row[40]    = "Gray VGA Clock\0";
  char text_bottom_row[40] = "(c) 2018 UMB\0";
  char clock1[40] = "The current time in NYC is  \0";
  char clock2[40] = "The current time in BER is  \0";
  char cities[30][4] = { {"NYC\0"}, {"CCS\0"}, {"RIO\0"},{"-02\0"},
{"-01\0"},{"LON\0"},{"BER\0"},{"ATH\0"}, {"JED\0"}, {"DXB\0"}, 
{"KHI\0"}, {"DAC\0"}, {"BKK\0"}, {"HKG\0"}, {"TYO\0"}, {"SYD\0"}, {"NOU\0"}, {"WLG\0"}, {"-11\0"},{"HNL\0"}, {"ANC\0"},{"LAX\0"}, {"DEN\0"}, {"CHI\0"} };
  char  text[3]= "12\0";

  printf("Welcome to the ARM/Nios Clock Program\n" );
  printf("Here are the US cities:\n" );
  for (k=3;k<=6;k++)
    printf("%d) %s\n",k,cities[k]);
  //printf("Ticks pers sec: %d\n",(int) alt_ticks_per_second());
  //start_time = alt_nticks();
  //printf("Start  ticks: %d \n", start_time);

/* Find the center of the VGA display */
//xcenter = alt_up_pixel_buffer_dma_x_res(pixel_buffer_dev) /2;
xcenter = 320;
//ycenter = alt_up_pixel_buffer_dma_y_res(pixel_buffer_dev) /2;
ycenter = 240;
xradius = xcenter/2*19/30;
yradius = ycenter/2;
printf("Xcenter = %d   Ycenter = %d Rx=%d  Ry=%d\n", xcenter, ycenter, xradius,yradius);

/* Run a couple of test: Draw line and gray levels */
  //draw_line(0, ycenter, xcenter, ycenter, colors[0]); // light
  //draw_line(xcenter, 0, xcenter, ycenter, colors[1]); // white
  for (y0=0;y0<128;y0++)
    for (x0=0;x0<128;x0++) {
      pixel_ptr = FPGA_ONCHIP_BASE + (y0+100) * 640 + x0 + 100;
      pixel_color= x0+ y0;
      *(char *) pixel_ptr =(char) pixel_color;
  }
  wait(20);

  VGA_box (0, 0, 639, 479, 0);// clear the screen
  VGA_text (34, 9, text_top_row);
  VGA_text (34, 10, text_bottom_row);
  for (y0=8*8;y0<12*8;y0++)
    for (x0=33*8;x0<49*8;x0++) {
      pixel_ptr = FPGA_ONCHIP_BASE + y0 * 640 + x0;
      pixel_color= x0 -264 + 4*(y0-64);
      *(char *) pixel_ptr =(char) pixel_color;
  }
 //VGA_box (33*8, 8*8, 49*8, 12*8, 0x7F); //Box 1 line x/y border */
 VGA_box (33*8, 8*8, 49*8, 12*8, 0x3F); //Box 1 line x/y border */

  VGA_text (5, 10, clock1);
  VGA_text (50, 10, clock2);

  x0=x1=x2=x3=y0=y1=y2=y3=x4=y4=0;
  loc=6; sec=0; min=40; hour=5; // initial time values

  while(1)	{
//    finish_time = alt_nticks();
//    total_time = ((finish_time - start_time)*1000) / //alt_ticks_per_second();
    
#ifdef PERIPH_BASE         
  wait(13); // for arm
#else
  wait(3); // for nios
#endif

    total_time=1001;
    if (total_time>1000) {
      start_time=finish_time; sec+=inc;
      if (sec>59) {sec=0;min++;}
      if (min>59) {min=0;hour++;}
      DEC3(hour, min, sec); // Display new time on 7-segments

// read the pushbutton KEY value
      KEY_value = *(KEY_ptr);    
      if (KEY_value != 0)  {  // check if any KEY was pressed
        while (*KEY_ptr); // wait for pushbutton KEY release
        if (KEY_value == 8) hour++;
        if (KEY_value == 4) min++;
        if (KEY_value == 2) sec++;
        if (KEY_value == 1) {loc++; loc %= 24;
          sprintf(clock2, "The current time in %s is   ",cities[loc]);
          printf("New city: %s\n",clock2);
          VGA_text (50, 10, clock2);
        }
      }

/* Dual clock: left is USA/NYC; right is other location in World */
// delete old second
        draw_line(xcenter/2, ycenter, xcenter/2+x1, ycenter+y1, 0);
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x1, ycenter+y1, 0);
// draw second in red/white
        x1= (int) xradius*sinf(sec/30.0*3.1415);	
        y1= (int) -yradius*cosf(sec/30.0*3.1415);	
        draw_line(xcenter/2, ycenter, xcenter/2+x1, ycenter+y1, colors[1]);
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x1, ycenter+y1, colors[1]);

// delete old minute
        draw_line(xcenter/2, ycenter, xcenter/2+x2, ycenter+y2, 0);
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x2, ycenter+y2, 0);
// draw minute in blue/light
        x2= (int) xradius*sinf(min/30.0*3.1415)*0.8;	
        y2= (int) -yradius*cosf(min/30.0*3.1415)*0.8;	
        draw_line(xcenter/2, ycenter, xcenter/2+x2, ycenter+y2, colors[0]);
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x2, ycenter+y2, colors[0]);
		
// delete old hour
        draw_line(xcenter/2, ycenter, xcenter/2+x3, ycenter+y3, 0);
        draw_line(xcenter/2+1, ycenter+1, xcenter/2+x3+1, ycenter+y3+1, 0);
        draw_line(xcenter/2-1, ycenter-1, xcenter/2+x3-1, ycenter+y3-1, 0);
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x4, ycenter+y4, 0);
        draw_line(3*xcenter/2+1, ycenter+1, 3*xcenter/2+x4+1, ycenter+y4+1, 0);
        draw_line(3*xcenter/2-1, ycenter-1, 3*xcenter/2+x4-1, ycenter+y4-1, 0);
// draw hour in green/dark
        x3= (int) xradius*sinf(hour/6.0*3.1415)*0.65;	
        y3= (int) -yradius*cosf(hour/6.0*3.1415)*0.65;	
        draw_line(xcenter/2, ycenter, xcenter/2+x3, ycenter+y3, colors[2]);
        draw_line(xcenter/2+1, ycenter+1, xcenter/2+x3+1, ycenter+y3+1, colors[2]);
        draw_line(xcenter/2-1, ycenter-1, xcenter/2+x3-1, ycenter+y3-1, colors[2]);
        x4= (int) xradius*sinf((loc+hour)/6.0*3.1415)*0.65;	
        y4= (int) -yradius*cosf((loc+hour)/6.0*3.1415)*0.65;
        draw_line(3*xcenter/2, ycenter, 3*xcenter/2+x4, ycenter+y4, colors[2]);
        draw_line(3*xcenter/2+1, ycenter+1, 3*xcenter/2+x4+1, ycenter+y4+1, colors[2]);
        draw_line(3*xcenter/2-1, ycenter-1, 3*xcenter/2+x4-1, ycenter+y4-1, colors[2]);
		
/* draws the face 1-12 for the clock */
        for (k=1;k<=12;k++) {
          sprintf(text,"%2d",k); // 8 pixel each character
          x0= (int) 1.3* xradius/8.0*sinf(k/6.0*3.1415)-1;	
          y0= (int) 1.3* -yradius/8.0*cosf(k/6.0*3.1415);	
          VGA_text (xcenter/16+x0, ycenter/8+y0, text);
          VGA_text (3*xcenter/16+x0, ycenter/8+y0, text);
        }
        printf("Time: %2d H  %2d M %2d S\n",hour,min,sec);
  //  printf("x0=%d y0=%d x1=%d y1=%d x2=%d y2=%d x3=%d y3=%d\n",x0, y0, x1, y1, x2, y2, x3, y3);
      } //if total-time

  } // while

} //main

/****************************************************************************************
 * Subroutine to show a string of HEX data on the HEX displays
****************************************************************************************/
void DEC3(char b1, char b2, char b3)
{
	volatile int * HEX3_HEX0_ptr = (int *) HEX3_HEX0_BASE;
	volatile int * HEX5_HEX4_ptr = (int *) HEX5_HEX4_BASE;

	/* SEVEN_SEGMENT_DECODE_TABLE gives the on/off settings for all segments in 
	 * a single 7-seg display in the DE1-SoC Computer, for the hex digits 0 - F */
	unsigned char	seven_seg_decode_table[] = 
       {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7C, 0x07, 
	0x7F, 0x67, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71 };
	unsigned char	hex_segs[] = { 0, 0, 0, 0, 0, 0, 0, 0 };
	unsigned int shift_buffer, nibble;
	unsigned char code;
	int i, d3, d2, d1; // Display in decimal not HEX
        d1 = b1/10; b1=b1 % 10;
        d2 = b2/10; b2=b2 % 10;
        d3 = b3/10; b3=b3 % 10;
	shift_buffer = (d1 << 20) | (b1 << 16) | (d2 << 12) | (b2 << 8) | (d3 << 4) | b3;
	for ( i = 0; i < 6; ++i )
	{
		nibble = shift_buffer & 0x0000000F;		// character is in rightmost nibble
		code = seven_seg_decode_table[nibble];
		hex_segs[i] = code;
		shift_buffer = shift_buffer >> 4;
	}
	/* drive the hex displays */
	*(HEX3_HEX0_ptr) = *(int *) (hex_segs);
	*(HEX5_HEX4_ptr) = *(int *) (hex_segs+4);
}

/****************************************************************************************
 * Draw a line on the VGA monitor using Bresenham compact
****************************************************************************************/
void draw_line(int x0, int y0, int x1, int y1, char pixel_color)
{
  int pixel_ptr;

  int dx =  abs(x1-x0);
  int sx = x0<x1 ? 1 : -1;
  int dy = -abs(y1-y0);
  int sy = y0<y1 ? 1 : -1;
  int err = dx+dy;
  int e2; /* error value e_xy */

  while (1) {
  //  setPixel(x0,y0);
  /* assume that the box coordinates are valid */
  pixel_ptr = FPGA_ONCHIP_BASE + (y0 * 640) + x0;
  *(char *) pixel_ptr = pixel_color;		// set pixel color
    if (x0==x1 && y0==y1) break;
    e2 = 2*err;
    if (e2 > dy) { err += dy; x0 += sx; } /* e_xy+e_x > 0 */
    if (e2 < dx) { err += dx; y0 += sy; } /* e_xy+e_y < 0 */
  }

}


/****************************************************************************************
 * Custom wait since usleep() not available 
****************************************************************************************/
void wait ( int s ) 
{
   volatile int u,v,sum=0;
   for (u=1;u<100000;u++)
    for (v=1;v<s;v++)
     sum+=v;
     //printf("...  Done wait\n");
}
/****************************************************************************************
 * Subroutine to send a string of text to the VGA monitor 
****************************************************************************************/
void VGA_text(int x, int y, char * text_ptr)
{
	int offset;
  	volatile char * character_buffer = (char *) FPGA_CHAR_BASE;	// VGA character buffer

	/* assume that the text string fits on one line */
	offset = (y << 7) + x;
	while ( *(text_ptr) )
	{
		*(character_buffer + offset) = *(text_ptr);	// write to the character buffer
		++text_ptr;
		++offset;
	}
}

/****************************************************************************************
 * Draw a filled rectangle on the VGA monitor 
****************************************************************************************/
void VGA_box(int x1, int y1, int x2, int y2, char pixel_color)
{
     int pixel_ptr;
     int row, col;

	/* assume that the box coordinates are valid */
	for (row = y1; row <= y2; row++)
		for (col = x1; col <= x2; ++col)
		{
	pixel_ptr = FPGA_ONCHIP_BASE + (row * 640) + col;
			*(char *)pixel_ptr = pixel_color;		// set pixel color
		}
}


