//#include "address_map_arm.h"
#include "address_map_nios2.h"
#include <stdio.h>

/* function prototypes */
void VGA_text (int, int, char *);
void VGA_box (int, int, int, int, short);
void HEX3(char, char, char);
void wait ( int ); 
/********************************************************************************
 * This program demonstrates use of the media ports in the DE1-SoC Computer
 *
 * It performs the following: 
 *   1. draws a test picture with some color boxes
 *   2. displays Mandelbrot type fractal 
 *   3. displays Douday rabbit type fractal 
 *   4. displays Siegel disc type fractal 
 *   5. displays San marco type fractal 
 *   6. continue with step 2
********************************************************************************/
int main(void)
{
//*************** variable use for fractals **************
  volatile int * sw_ptr = (int *) SW_BASE;
  volatile int * red_LED_ptr = (int *) LEDR_BASE;
  int pixel_ptr;
  short pixel_color;
  short img[4][240][320];
  int r, s, g, sw, k;
  int fig=0;
  int iterations=30;
  float sq, tr, ti, cr=0, ci=0, nr=0, ni= 0;
  
  /* create a message to be displayed on the VGA display */
  char text_top_row0[40] = "0: Mandelbrot   \0";
  char text_top_row1[40] = "1: Douday rabbit\0";
  char text_top_row2[40] = "2: Siegel disc  \0";
  char text_top_row3[40] = "3: San marco    \0";
  char text_empty[40] =    "                \0";
  char text_bottom_row[40] =  " Type Fractal   \0";

  // clear the screen to green; print test image
  VGA_box (0, 0, 319, 239, 0x03E0);
  VGA_text (35, 29, text_empty);
  VGA_text (35, 30, text_empty);
  VGA_box (130, 130, 150, 150, 0x8410/8);
  VGA_box (150, 150, 170, 170, 0x8410/4);
  VGA_box (170, 170, 190, 190, 0x8410/2);
  VGA_box (190, 190, 210, 210, 0x8410);
#ifdef PERIPH_BASE
  printf("Hi from DE1-SoC ARM\n");
#else
  printf("Hi from DE1-SoC Nios II\n");
#endif
 
//***** MandelBrot ******************************
  for (fig=0;fig<4;fig++) {
  HEX3(0, 0, fig);
  printf("Start computing fractal %d ...\n",fig);
  for (r=0;r<240;r++) 
    for (s=0;s<320;s++) {
    // Possible constant seeds from Mathematica:
    // 0.32+j*0.043
    // 0.9*j*0.15
    // 0.7875+j*0.27
    // 0.54725625+j*0.42525
    // 0.11865184066406255+j*0.46544144062500015
    // -0.20255747535810545+j*0.1104509673029785
    // 0.02883011464528587-j*0.044745338175503954
    // -0.0011709697779798847-j*0.002580026458883731
    // -5.285366307597864e-6+j*6.042266019482621e-6
    // -8.57388164470368e-12-j*6.387117848183381e-11
    // -4.006015994200883e-21+j*1.095247849621975e-21
    // 1.484859629369173e-41-j*8.77516080639951e-42
    //********** Mandelbrot ************
    if (fig==0) {
      cr=(float) s/320.0*3-2.25; // x has range -2.25 .. 0.75
      ci=(float) 1.5-r/240.0*3; // y has range -1.5 .. 1.5   
      nr=0; ni=0;
    }
    //********** Douday rabbit ************
    if (fig==1) {
      nr=(float) s/320.0*3-1.5; // x has range -1.5 .. 1.5
      ni=(float) 1.5-r/240.0*3; // y has range -1.5 .. 1.5   
      cr=-0.123; ci=0.745;    
    }
    //********** Siegel disc ************
    if (fig==2) {
      nr=(float) s/320.0*3-1.5; // x has range -1.5 .. 1.5
      ni=(float) 1.5-r/240.0*3; // y has range -1.5 .. 1.5   
      cr=-0.391; ci=-0.587;    
    }
    //********** San marco ************
    if (fig==3) {
      nr=(float) s/320.0*3.5-1.75; // x has range -1.75 .. 1.75
      ni=(float) 1.5-r/240.0*3; // y has range -1.5 .. 1.5   
      cr=-0.75; ci=0.0;    
    }        
    k=0;sq=0;
    while ((k<iterations) && (sq < 5)) {
      k=k+2;
      //z=z.*z + c;
      tr = nr; ti=ni;
      nr = tr*tr - ti*ti + cr;
      ni = 2*tr*ti + ci;
      // a=find(abs(z)>sqrt(5));
      sq = nr*nr + ni*ni;
    }
    //map(r,s)=k*4;
    g = 30-k; // Use ref color for small iteration k
    switch (fig) {
      case 1 : pixel_color = g << 6; break;   // green back
      case 2 : pixel_color = g; break;  // blue
      case 3 : pixel_color = (short) (g << 6) + g; break; // light blue
      default: pixel_color = g; // blue 
    }
    if (g<=2) pixel_color = 0xF800;  // red default
    img[fig][r][s] = pixel_color;
    }
  }
  HEX3(0, 0, 13); // display d for done
  printf("Fractal computation done; watch the VGA monitor now!\n");
  printf("Change display speed with SW value.\n");

  /***************** loop the 4 images *************/
  while(1) {
  /* output text message in the middle of the VGA monitor */
  VGA_text (35, 30, text_bottom_row);
  VGA_box (0, 0, 319, 239, 0x8410/2); // reset to gray
  switch (fig) {
    case 1 : VGA_text (35, 29, text_top_row1);break;    
    case 2 : VGA_text (35, 29, text_top_row2);break;
    case 3 : VGA_text (35, 29, text_top_row3);break;
    default: VGA_text (35, 29, text_top_row0);
  }
  for (r=0;r<240;r++) 
    for (s=0;s<320;s++) {
      pixel_ptr = FPGA_ONCHIP_BASE + (r << 10) + (s << 1);
      switch (fig) {
        case 1 : *(short *) pixel_ptr = img[1][r][s]; break;    
        case 2 : *(short *) pixel_ptr = img[2][r][s]; break; 
        case 3 : *(short *) pixel_ptr = img[3][r][s]; break; 
        default: *(short *) pixel_ptr = img[0][r][s]; break; 
      }
    }
    sw = *(sw_ptr); // use switch value for speed    
    *(red_LED_ptr) = sw; // display on red LEDs
    fig ++; // show all figures
    if (fig>3) fig=0;  
#ifdef PERIPH_BASE         
  sw = sw * 13 /3; // Wait statement ARM
#endif
  wait(sw);
  }
}

/****************************************************************************************
 * Subroutine to send a string of text to the VGA monitor 
****************************************************************************************/
void VGA_text(int x, int y, char * text_ptr)
{
  int offset;
  volatile char * character_buffer = (char *) FPGA_CHAR_BASE;  // VGA character buffer

  /* assume that the text string fits on one line */
  offset = (y << 7) + x;
  while ( *(text_ptr) )
  {
    *(character_buffer + offset) = *(text_ptr);  // write to the character buffer
    ++text_ptr;
    ++offset;
  }
}

/****************************************************************************************
 * Draw a filled rectangle on the VGA monitor 
****************************************************************************************/
void VGA_box(int x1, int y1, int x2, int y2, short pixel_color)
{
  int pixel_ptr, row, col;

  /* assume that the box coordinates are valid */
  for (row = y1; row <= y2; row++)
    for (col = x1; col <= x2; ++col)
    {
      pixel_ptr = FPGA_ONCHIP_BASE + (row << 10) + (col << 1);
      *(short *)pixel_ptr = pixel_color;    // set pixel color
    }
}

/****************************************************************************************
 * Subroutine to show a string of HEX data on the HEX displays
****************************************************************************************/
void HEX3(char b1, char b2, char b3)
{
  volatile int * HEX3_HEX0_ptr = (int *) HEX3_HEX0_BASE;
  volatile int * HEX5_HEX4_ptr = (int *) HEX5_HEX4_BASE;

  /* SEVEN_SEGMENT_DECODE_TABLE gives the on/off settings for all segments in 
   * a single 7-seg display in the DE1-SoC Computer, for the hex digits 0 - F */
  unsigned char  seven_seg_decode_table[] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7C, 0x07, 
                          0x7F, 0x67, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71 };
  unsigned char  hex_segs[] = { 0, 0, 0, 0, 0, 0, 0, 0 };
  unsigned int shift_buffer, nibble;
  unsigned char code;
  int i;

  shift_buffer = (b1 << 16) | (b2 << 8) | b3;
  for ( i = 0; i < 6; ++i )
  {
    nibble = shift_buffer & 0x0000000F;    // character is in rightmost nibble
    code = seven_seg_decode_table[nibble];
    hex_segs[i] = code;
    shift_buffer = shift_buffer >> 4;
  }
  /* drive the hex displays */
  *(HEX3_HEX0_ptr) = *(int *) (hex_segs);
  *(HEX5_HEX4_ptr) = *(int *) (hex_segs+4);
}

/****************************************************************************************
 * Custom wait since usleep() not available 
****************************************************************************************/
void wait ( int s ) 
{
  volatile int u,v,sum=0; // volatile so the C compiler doesn't remove the loop
  for (u=1;u<100000;u++)
    for (v=1;v<s;v++)
      sum+=v;
}
