//#include "address_map_arm.h"
#include "address_map_nios2.h"
#include <stdio.h>  /* printf */

/* globals */
#define FMAX 25

/* function prototypes */
void VGA_text (int, int, char *);
void VGA_box (int, int, int, int, short);
void HEX3(char, char, char);
void wait ( int ); 

/********************************************************************************
 * This program demonstrates how to build a fractal zoom movie for the DE1-SoC Computer
 *
 * It performs the following: 
 *  1. Computes 25 zoom levels of the Mandelbrot type fractal
 *     Frame number is shown on 7-segment; line counter on LEDs
 *     Computation on Nios takes 30 seconds per frame or 15 minutes total
 *     Computation on ARM takes 1 seconds per frame or 1/2 minute total
 *  2. Displays in loop the fractal zoom in/out on the DE1-SoC Computer VGA display
 *     The SW values determine the wait time between two frames
********************************************************************************/
int main(void)
{
//*************** variable use for fractals **************
  volatile int * sw_ptr = (int *) SW_BASE;
  volatile int * red_LED_ptr = (int *) LEDR_BASE;
  int pixel_ptr;
  short pixel_color;
  short img[FMAX+1][240][320];
  int r, s, g, sw, k, iframe;
  float direction;
  int iterations=30;
  float d, sq, cr, ci, nr, ni, tr, ti;
  int xmin, xmax, ymin, ymax; 
  char byte1 = 0, byte2 = 0, byte3 = 0;

  /* create a message to be displayed on the VGA and LCD displays */
  char text_top_row0[40] = "0: Zoom         \0";
  char text_empty[40] =    "                \0";
  char text_bottom_row[40] =  " Fractal Video  \0";

#ifdef PERIPH_BASE
  printf("Hi from DE1-SoC ARM\n");
#else
  printf("Hi from DE1-SoC Nios II\n");
#endif
  printf("%s\n",text_bottom_row);

  // Generate a test image; clear the screen to green
  VGA_box (0, 0, 319, 239, 0x03E0);   
  VGA_text (35, 29, text_empty);
  VGA_text (35, 30, text_empty);         
 // plot some gray boxes
  VGA_box (130, 130, 150, 150, 0x8410/8);
  VGA_box (150, 150, 170, 170, 0x8410/4);
  VGA_box (170, 170, 190, 190, 0x8410/2);
  VGA_box (190, 190, 210, 210, 0x8410);
  
  float x1=-0.109351;
  float y1=1.1; //0.894692; // Zoom center
  x1=-1.8,y1=0; // go to to peak
  d=1/0.9;
   printf("Start computing %d frames ... may take some time\n",FMAX);
//***** Compute MandelBrot Images and Store *************
  for (iframe=0;iframe<FMAX;iframe++) {
    d= d*0.9;
    byte2 = iframe/10; byte3 = iframe % 10;
    HEX3(0, byte2, byte3); // display d for done 
    xmin= (int) 100*(d*(0/320.0*2.0-1.5-x1)+x1);
    xmax= (int)100*(d*(320/320.0*2.5-1.5-x1)+x1);
    printf("%2d: x*100 = %d...%d\n",iframe,xmin,xmax); 
    ymin=(int)100*(d*(1.5-0/240.0*3-y1)+y1);
    ymax=(int)100*(d*(1.5-240/240.0*3-y1)+y1);
    printf("%2d: y*100 = %d...%d\n",iframe,ymin,ymax); 
    for (r=0;r<240;r++) {
     *(red_LED_ptr) = r;
    for (s=0;s<320;s++) {
    //********** Mandelbrot ************
      cr=(float) d*(s/320.0*2.5-2.2-x1)+x1; // x has range -1.5 .. 1
      ci=(float) d*(1.5-r/240.0*3-y1)+y1; // y has range 1.5 .. -1.5   
      nr=0; ni=0;
    k=0;sq=0;
    while ((k<iterations) && (sq < 5)) {
      k=k+2;
      //z=z.*z + c;
      tr = nr; ti=ni;
      nr = tr*tr - ti*ti + cr;
      ni = 2*tr*ti + ci;
      // a=find(abs(z)>sqrt(5));
      sq = nr*nr + ni*ni;
    }
    
    g = 30-k; // Use dark color for small iteration k
    pixel_color = g; // blue
    if (g<=0) pixel_color = 0xF800; // red
    if ((g>=2) & (g<=8)) pixel_color = 0x07FF; // light blue
    pixel_ptr = FPGA_ONCHIP_BASE + (r << 10) + (s << 1);  
    *(short *) pixel_ptr =  pixel_color;    
    img[iframe][r][s] = pixel_color;
    }
  }
  }
  byte1 = 13; byte2 = iframe/10; byte3 = iframe % 10;
  HEX3(byte1, byte2, byte3); // display d for done
  printf("Done with computing %d frames\n",iframe);
  /***************** loop the  images *************/
  iframe=0;direction=1;
  while(1) {
  /* output text message in the middle of the VGA monitor */
  VGA_text (35, 30, text_bottom_row);
  //VGA_box (0, 0, 319, 239, 0x8410/2); // reset to gray
    sprintf(text_top_row0, "%2d: Zoom         \0",iframe);
    VGA_text (35, 29, text_top_row0);
  for (r=0;r<240;r++)  // copy the image to image buffer
    for (s=0;s<320;s++) {
      pixel_ptr = FPGA_ONCHIP_BASE + (r << 10) + (s << 1);
      *(short *) pixel_ptr = img[iframe][r][s];
      }
    *(red_LED_ptr) = iframe;
    iframe += direction;
    if (iframe>FMAX) {direction=-1;iframe=FMAX;}
    if (iframe<0) {direction=1;iframe=0;}
    sw = *(sw_ptr); // use switch value for speed    
    wait(sw); // Wait statement
  }
}

/****************************************************************************************
 * Subroutine to send a string of text to the VGA monitor 
****************************************************************************************/
void VGA_text(int x, int y, char * text_ptr)
{
  int offset;
    volatile char * character_buffer = (char *) FPGA_CHAR_BASE;  // VGA character buffer

  /* assume that the text string fits on one line */
  offset = (y << 7) + x;
  while ( *(text_ptr) )
  {
    *(character_buffer + offset) = *(text_ptr);  // write to the character buffer
    ++text_ptr;
    ++offset;
  }
}

/****************************************************************************************
 * Draw a filled rectangle on the VGA monitor 
****************************************************************************************/
void VGA_box(int x1, int y1, int x2, int y2, short pixel_color)
{
  int pixel_ptr, row, col;

  /* assume that the box coordinates are valid */
  for (row = y1; row <= y2; row++)
    for (col = x1; col <= x2; ++col)
    {
      pixel_ptr = FPGA_ONCHIP_BASE + (row << 10) + (col << 1);
      *(short *)pixel_ptr = pixel_color;    // set pixel color
    }
}

/****************************************************************************************
 * Subroutine to show a string of HEX data on the HEX displays
****************************************************************************************/
void HEX3(char b1, char b2, char b3)
{
  volatile int * HEX3_HEX0_ptr = (int *) HEX3_HEX0_BASE;
  volatile int * HEX5_HEX4_ptr = (int *) HEX5_HEX4_BASE;

  /* SEVEN_SEGMENT_DECODE_TABLE gives the on/off settings for all segments in 
   * a single 7-seg display in the DE1-SoC Computer, for the hex digits 0 - F */
  unsigned char  seven_seg_decode_table[] = {  0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7C, 0x07, 
                          0x7F, 0x67, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71 };
  unsigned char  hex_segs[] = { 0, 0, 0, 0, 0, 0, 0, 0 };
  unsigned int shift_buffer, nibble;
  unsigned char code;
  int i;

  shift_buffer = (b1 << 16) | (b2 << 8) | b3;
  for ( i = 0; i < 6; ++i )
  {
    nibble = shift_buffer & 0x0000000F;    // character is in rightmost nibble
    code = seven_seg_decode_table[nibble];
    hex_segs[i] = code;
    shift_buffer = shift_buffer >> 4;
  }
  /* drive the hex displays */
  *(HEX3_HEX0_ptr) = *(int *) (hex_segs);
  *(HEX5_HEX4_ptr) = *(int *) (hex_segs+4);
}

/****************************************************************************************
 * Custom wait since usleep() not available 
****************************************************************************************/
void wait ( int s ) 
{
   volatile int u,v,sum=0; // volatile so the C compiler doesn't remove the loop
   for (u=1;u<100000;u++)
    for (v=1;v<s;v++)
     sum+=v;
     //printf("...  Done wait\n");
}
