set project_name "trisc2" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vcom -93 {rom4096x18 - flash.vhd}
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_OUT pc
add_one op_code op6
add_one ir_imm12 imm12
add_one jc_OUT jc 
add_local s(0) 
add_local s(1) 
add_local s(2) 
add_local s(3)  
add_local z 
add_local c
#add wave -divider  "Link Stack:" 
#add_local lcount 
#add_local lreg(0) 
#add_local lreg(1) 
#add_local lreg(2) 
#add wave -divider  "Data Memory:" 
#add_one me_ena mem_ena 
#add_local scratch_pad_ram/idma
#add_local x
#add_local dram(61) 
#add_local dram(62) 
#add_local dram(63) 
#add_local dmd
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 5ns
force in_port 5 0ns, 15 1000ns 

########## Run the simulation
run 300ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
