-- Title: T-RISC 2 address machine data ram

LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;

ENTITY data_ram IS 
 PORT(not_clk : IN  STD_LOGIC; -- System clock (clk=>CLOCK_50)
      reset   : IN  STD_LOGIC; -- Active low asynchronous reset (reset<=> KEY(0))
      mem_ena : IN STD_LOGIC;
      Rd      : IN  STD_LOGIC_VECTOR(31 DOWNTO 0); -- Input port (in_port<=>SW)
      dma     : IN  STD_LOGIC_VECTOR(31 DOWNTO 0); -- Input port (in_port<=>SW)
      dmd     : OUT STD_LOGIC_VECTOR(31 DOWNTO 0) -- Output port (out_port<=>LEDR)
);
END;
ARCHITECTURE fpga OF data_ram IS

  CONSTANT DRAMAX : INTEGER := 4095; -- No. of DRAM words -1
  CONSTANT DRAMAX4 : INTEGER := 16383; -- No. of DRAM bytes -1
  SUBTYPE U12 IS INTEGER RANGE 0 TO 4095;
  SUBTYPE SLVD IS STD_LOGIC_VECTOR(31 DOWNTO 0); -- Width data

-- RAM data definition and values
TYPE MTYPE IS ARRAY(0 TO DRAMAX) OF SLVD;
SIGNAL dram : MTYPE := (
X"E3A01000",  -- mov r1, #0
X"E34F1F20",  -- movt r1, 0xff20  
X"E5912040",  -- ldr r2, [r1, #0x40] 
X"E5812000",  -- str r2, [r1]
X"E3073840",  -- movw r3, #0x7840
X"E340317D",  -- movt r3, 0x17d
X"E2533001",  -- subs r3, r3, #1
X"1AFFFFFD",  -- bne -1 inst. <loop>
X"E1E02002",  -- mvn r2, r2
X"EAFFFFF8",  -- branch -6 inst. <flash>
OTHERS => X"E320F000"); -- default NOP


BEGIN
  
--  ram: PROCESS (reset, not_clk, imm8)
--  VARIABLE idma : U8;
--  BEGIN
--    idma := CONV_INTEGER('0' & imm8); -- force unsigned
--    IF reset = '0' THEN               -- Asynchronous clear
--      dmd <= (OTHERS => '0');          
--    ELSIF rising_edge(not_clk) THEN
--      IF mem_ena = '1' THEN
--        dram(idma) <= x;  -- Write to RAM at falling clk edge
--      END IF;
--      dmd <= dram(idma);  -- Read from RAM at falling clk edge   
--    END IF;
--  END PROCESS;
  
  ram: PROCESS (reset, dma, not_clk) -- Use one BRAM: 4096x32
  VARIABLE idma : U12 := 0;
  BEGIN
    idma := CONV_INTEGER('0' & dma(13 DOWNTO 2));--force uns/skip 2 LSBs
    IF reset = '0' THEN       -- Asynchronous clear
      dmd <= (OTHERS => '0');          
    ELSIF rising_edge(not_clk) THEN
      IF mem_ena = '1' THEN
        dram(idma) <= Rd;  -- Write to RAM at falling clk edge
      END IF;
      dmd <= dram(idma);  -- Read from RAM at falling clk edge
    END IF;
  END PROCESS;  
  
END fpga;
