set project_name "trisc3a" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
#vcom -93 dpram4Kx32.vhd
vcom -93 {dpram4Kx32 - flash.vhd}
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_out pc
add_local ir
add_local bx
add_one op_code op
add_local pc8
add_local branch_target
add_one ir_imm12 imm12
add_one imm32_out imm32
add_local dma
add_one jc_out jc 
add_local NN
add_local M
add_local D
add_local Rd
add_local Rn
add_local Rm
add_one r1_out {r(1)}  
add_one r2_out {r(2)}
add_one r3_out {r(3)}
add_one r4_out {r(4)}
#add_one i_out I
add_local ALU/res
#add wave -divider  "Link Stack:" #
#add_local lcount 
#add_local lreg(0) 
#add_local lreg(1) 
#add_local lreg(2) 
#add wave -divider  "Data Memory:" 
#add_one me_ena mem_ena 
#add_local scratch_pad_ram/idma
#add_local x
#add_local dram(61) 
#add_local dram(62) 
#add_local dram(63) 
#add_local dmd
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 240ns
#run 1010000us
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
