set project_name "trisc3mb" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vcom -93 {rom4096x32 - dmem.vhd}
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_local {pc[24:31]}
add_local ir
add_one op_code op
add_one jc_OUT jc 
add_local_uns A 
add_local_uns B 
add_local_uns D
add_local {r(1)} 
add_local {r(3)}
add_local_label  {r19=sp} {r(19)}
add wave -divider  "Data Memory:" 
add_local store
add_local load
add_local_uns {dma[18:29]}
add wave -divider  "global region:" 
add_local dram(776) 
add_local dram(777) 
add_local dram(778) 
add_local dram(779) 
add wave -divider  "sp region:" 
add_local dram(1536) 
add_local dram(1537) 
add_local dram(1538) 
add_local dram(1539) 
add_local dmd
#add wave -divider  "I/O Ports:"
#add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 750ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
