set project_name "trisc3mb" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
#vcom -93 {rom4096x32 - flash.vhd}
vcom -93 rom4096x32.vhd
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_local {pc[24:31]}
add_local ir
add_one op_code op
add_local go
add_local cmp
add_local branch_target
add_one jc_out jc 
add_local A
add_local B
add_local D
add_one r1_out {r(1)}  
add_one r2_out {r(2)} 
add_one r3_out {r(3)}  
add_one r4_out {r(4)} 
add_local {r(18)}
add_local_label {r19=sp} {r(19)}
add_local ALU/res
add_local store
add_local load
add_local write
add_local read
add_local_uns {dma[18:29]}
add_local dram(1909) 
add_local dram(1910) 
add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 400ns
#run 1060ns
#run 1010000us
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
