set project_name "trisc3mb" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vcom -93 {rom4096x32 - nesting.vhd}
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_local {pc[0:31]}
add_local ir
add_one op_code op
add_local Delay
add_local go
add_local link
add_local branch_target
add_one jc_OUT jc 
add_local_uns A 
add_local_uns B
add_local_uns D
add_local {r(1)}
add_local {r(2)} 
add_local {r(3)}
add_local_label {r19=sp} {r(19)}
add_local_label {r15=lr} {r(15)}
add wave -divider  "Data Memory:" 
add_local store
add_local load
add_local_uns {dma[18:29]}
add wave -divider  "sp lr value:" 
add_local dram(1557)
add_local dram(1549)
add wave -divider  "sp variable:" 
add_local dram(1572)
add_local dram(1573)
add_local dram(1574) 
add_local dram(1575) 
add_local dram(1576) 
add_local dram(1577) 
add_local dram(1578) 
add_local dmd
#add wave -divider  "I/O Ports:"
#add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 25ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 1880ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
