

set project_name "trisc3n" 
puts "** Functional (f) or Timing (t) simulation ? "
set data ""
set valid 0 
while {!$valid} {
    gets stdin data
    set valid [expr {($data == f) || ($data == t)}]
    if {!$valid} {
        puts "** Functional (f) or Timing (t) simulation ?)"
        puts "Choose either f or t"
    }
}

if {$data == f} {
    puts "** Run Functional simulation now ..."
} elseif {$data == t} {
    puts "** Run Timing simulation now ..."
}

########## Compile design
vlib work
vcom -93 {rom4096x32 - dmem.vhd}
do {tb_ini.do}  

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add wave clk reset
radix -hex
add wave -divider  "Locals:" 
add_one pc_OUT pc
add_one op_code op
add_local opx
#add_local branch_target
#add_one ir_imm16 imm16
#add_one imm32 imm32_out
add_one jc_OUT jc 
add_local_uns A
add_local_uns B
add_local_uns C
#add_local rA
#add_local rB
#add_local rC
#add_local r1_out 
add_local r2_out 
add_local r3_out 
add_local r4_out
add_local_label {r27=sp} {r(27)}
add_local_label {r26=gp} {r(26)}
#add wave  -label ra {r(31)}
#add_local kflag 
#add_local ALU/res
add wave -divider  "Data Memory:" 
add_one me_ena mem_ena 
add_local_uns {dma[15:2]}
#add wave -uns ram/idma
add wave -divider  "gp region:" 
add_local dram(555) 
add_local dram(556) 
#add_local dram(557) 
add_local dram(558) 
add wave -divider  "sp region:" 
add_local dram(4080) 
add_local dram(4081) 
add_local dram(4082) 
add_local dmd
#add wave -divider  "I/O Ports:"
#add wave in_port out_port

######### Add stimuli data
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 5ns
force in_port 5 0ns, 5 1000ns 

########## Run the simulation
run 640ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
