-- Test program for the URISC processors
library ieee;
use ieee.std_logic_1164.all; use ieee.std_logic_unsigned.all;
-- =============================================================
ENTITY rom128x16 IS
  PORT(clk      : IN STD_LOGIC;  -- System clock
       address  : IN STD_LOGIC_VECTOR(6 DOWNTO 0); -- Address input
       data     : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)); -- Data output
END;
-- ==============================================================
ARCHITECTURE fpga OF rom128x16 IS

  TYPE rom_type IS ARRAY (0 TO 127) OF STD_LOGIC_VECTOR(15 DOWNTO 0);
  CONSTANT rom : rom_type := (
  X"2201", X"2001", X"ff01", X"f201", X"2201", X"1280",
  OTHERS => X"0000");

BEGIN
  data <= rom(conv_integer(address));
END fpga;
