########## Compile design
vlib work
vcom -93 rom128x16.vhd
vcom -93 urisc.vhd 
vsim work.urisc(fpga)

########## Add I/O signals to wave window
add wave clk reset
add wave -divider  "Locals:" 
add wave -hex state pc data 
add wave -uns rd rs address
add wave -dec r(0) r(1) r(2) r(15) 
add wave -dec jump mode dif
add wave -divider  "I/O Ports:"
add wave -dec in_port out_port

######### Add stimuli data
radix -hex
force clk 0 0ns, 1 10ns -r 20ns
force reset 0 0ns, 1 105ns
force in_port 5 0ns 

########## Run the simulation
run 750ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
