## add a local signal for behavior simulation only
proc add_local {var_name} { 
  if { [catch {add wave $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local variable $var_name in wave window for simulation!"
  }
}

## add one of two local signals for behavior simulation only
proc add_one {var_one var_two} { 
  if { [catch {add wave $var_one}] > 0 } {
    puts "** Uwe Info: Local Signal $var_one is NOT available!"
    if { [catch {add wave $var_two}] > 0 } {
      puts "** Uwe Info: Local Signal $var_two is NOT available!"
  } else {    puts "** Uwe Info: Add local variable $var_two in wave window for simulation!"
  }
  } else {
    puts "** Uwe Info: Add local variable $var_one in wave window for simulation!"
  }
}

########## Compile design
puts "** Functional Simulation"
vlib work
vcom -2008 rom4096x18.vhd
vcom -2008 trisc2.vhd
vcom -2008 trisc2_tb.vhd
vsim work.trisc2_tb(fpga)

########## Add I/O signals to wave window
add wave clk reset

radix -hex
add wave -divider  "Locals:" 
add_local UUT/pc
add_local UUT/op6
add_local UUT/imm12
add_local UUT/jc 
add_local UUT/{s(0)}
add_local UUT/{s(1)}
add_local UUT/{s(2)}
add_local UUT/{s(3)}
add_local UUT/z 
add_local UUT/c 

add wave -divider  "I/O Ports:"
add wave in_port out_port

######### Add stimuli data in HDL code => see HDL code
#force clk 0 0ns, 1 10ns -r 20ns
#force reset 1 0ns, 0 5ns
#force iport 3 0ns

########## Run the simulation
run 500ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
