LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_signed.ALL;
-- ========================================================
ENTITY trisc2_tb IS END;
-- ========================================================
ARCHITECTURE fpga OF trisc2_tb IS

-- ========= Unit under test definition: ==================
  COMPONENT trisc2 IS 
 PORT(clk      : IN  STD_LOGIC; -- System clock (clk=>CLOCK_50)
      reset    : IN  STD_LOGIC; -- Active low asynchronous reset (reset<=> KEY(0))
      in_port  : IN  STD_LOGIC_VECTOR(7 DOWNTO 0); -- Input port (in_port<=>SW)
      out_port : OUT STD_LOGIC_VECTOR(7 DOWNTO 0) -- Output port (out_port<=>LEDR)
      -- s0_OUT   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);      -- Register 0
      -- s1_OUT   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);      -- Register 1
      -- s2_OUT   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);      -- Register 2
      -- s3_OUT   : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);      -- Register 3 
      -- jc_OUT   : OUT STD_LOGIC;   -- Jump condition flag     
      -- z_OUT    : OUT STD_LOGIC; -- Zero flag 
      -- c_OUT    : OUT STD_LOGIC; -- Carry flag           
      -- pc_OUT   : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);      -- Program counter   
      -- ir_imm12 : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);      -- Immediate value 
      -- op_code  : OUT STD_LOGIC_VECTOR(5 DOWNTO 0)       -- Operation code
       );
  END COMPONENT;                
             
-- ==== Signal definition with intial values: =============
  SIGNAL clk : STD_LOGIC := '0';
  SIGNAL reset : STD_LOGIC;
  SIGNAL pc_OUT : STD_LOGIC_VECTOR (11 DOWNTO 0);
  SIGNAL op_code : STD_LOGIC_VECTOR (5 DOWNTO 0);
  SIGNAL ir_imm12 : STD_LOGIC_VECTOR (11 DOWNTO 0); 
  SIGNAL s0_OUT : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL s1_OUT : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL s2_OUT : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL s3_OUT : STD_LOGIC_VECTOR (7 DOWNTO 0); 
  SIGNAL jc_OUT, z_OUT, c_OUT : STD_LOGIC;    
-- I/O Ports:     
  SIGNAL in_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL out_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  
  CONSTANT T : TIME := 20 ns;

BEGIN
-- ========= Unit under test instantiation: ==================
    UUT : trisc2
    PORT MAP (
        clk => clk,
        reset => reset,
        in_port  => in_port,
        out_port => out_port
        -- s0_OUT => s0_OUT,
        -- s1_OUT => s1_OUT,        
        -- s2_OUT => s2_OUT,
        -- s3_OUT => s3_OUT,
        -- jc_OUT => jc_OUT, 
        -- z_OUT => z_OUT,
        -- c_OUT => c_OUT,       
        -- pc_OUT => pc_OUT,
        -- ir_imm12 => ir_imm12,
        -- op_code => op_code
		);
    
-- =============== Periodic signals: ======================
  clk <= NOT clk AFTER T/2;

-- ================= Add stimuli: =========================
  PROCESS  
  BEGIN
    -- ====================
    reset <= '1';
    in_port <= CONV_STD_LOGIC_VECTOR(5, 8);
    -- ====================
    WAIT FOR 105ns; -- Time=105 ns    
    reset <= transport '0';
    -- ====================
    WAIT; -- Time=805 us
    -- ====================
  END PROCESS;

END fpga;
