-- File is True Dual Port RAM with dual clock for DRAM and ROM
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- ===================================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- ===================================================================
ENTITY dpram4Kx32 IS
PORT (clk_a  : IN STD_LOGIC; -- System clock DRAM
      clk_b  : IN STD_LOGIC; -- System clock PROM
      addr_a : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Data mem. address
      addr_b : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Prog. mem. address
      data_a : IN STD_LOGIC_VECTOR(31 DOWNTO 0); -- Data in for DRAM 
      we_a   : IN STD_LOGIC := '0'; -- Write only DRAM
      q_a    : OUT STD_LOGIC_VECTOR(31 DOWNTO 0); -- DRAM output
      q_b    : OUT STD_LOGIC_VECTOR(31 DOWNTO 0)); -- ROM output
END ENTITY dpram4Kx32;
-- ===================================================================
ARCHITECTURE fpga OF dpram4Kx32 IS

-- Build a 2-D array type for the RAM
TYPE MEM IS ARRAY(0 TO 4095) of STD_LOGIC_VECTOR(31 DOWNTO 0);
 
-- Define RAM and initial values
SHARED VARIABLE dram : MEM  := (
X"E3A01000",  -- 00: mov r1, #0
X"E34F1F20",  -- 04: movt r1, 0xff20  
X"E5912040",  -- 08: ldr r2, [r1, #0x40] 
X"E5812000",  -- 0C: str r2, [r1]
X"E3073840",  -- 10: movw r3, #0x7840
X"E340317D",  -- 14: movt r3, #0x17d
X"E2533001",  -- 18: subs r3, r3, #1
X"1AFFFFFD",  -- 1C: bne -1 inst. <loop>
X"E1E02002",  -- 20: mvn r2, r2
X"EAFFFFF8",  -- 24: branch -6 inst. <flash>
OTHERS => X"E320F000"); -- default NOP

BEGIN

  -- Port A aka DRAM
  PROCESS(clk_a)
  BEGIN
    IF(RISING_EDGE(clk_a)) THEN 
      IF(we_a = '1') THEN
        dram(CONV_INTEGER('0'& addr_a)) := data_a;
        q_a <= data_a;
      ELSE
        q_a <= dram(CONV_INTEGER('0'& addr_a));
      END IF;
    END IF;
  END PROCESS;

  -- Port B aka ROM
  PROCESS(clk_b)
  BEGIN
    IF(RISING_EDGE(clk_b)) THEN 
      q_b <= dram(CONV_INTEGER('0' & addr_b));
    END IF;
  END PROCESS;
  
END fpga;
