## add a local signal for behavior simulation only
proc add_local {var_name} { 
  if { [catch {add wave $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local variable $var_name in wave window for simulation!"
  }
}

## add one of two local signals for behavior simulation only
proc add_one {var_one var_two} { 
  if { [catch {add wave $var_one}] > 0 } {
    if { [catch {add wave $var_two}] > 0 } {
      puts "** Uwe Info: Local Signals $var_one and $var_two are NOT available!"
  } else {    puts "** Uwe Info: Add local variable $var_two in wave window for simulation!"
  }
  } else {
    puts "** Uwe Info: Add local variable $var_one in wave window for simulation!"
  }
}


########## Compile design
puts "** Functional Simulation"
vlib work
vcom -93 dpram4Kx32.vhd
vcom -2008 trisc3a.vhd
vcom -2008 trisc3a_tb.vhd
vsim work.trisc3a_tb(fpga)

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add_one clk sys_clk
add wave reset
radix -hex
add wave -divider  "Locals:" 
add_local UUT/P0/cnt
add_local UUT/clk
add_local UUT/pc
add_local UUT/ir
add_local UUT/bx
add_local UUT/op
add_local UUT/pc8
add_local UUT/branch_target
add_local UUT/imm12
add_local UUT/imm32
add_local UUT/dma
add_local UUT/jc 
add_local UUT/NN
add_local UUT/M
add_local UUT/D
add_local UUT/Rd
add_local UUT/Rn
add_local UUT/Rm
add_local UUT/{r(1)}
add_local UUT/{r(2)}
add_local UUT/{r(3)}
add_local UUT/{r(4)}
add_local UUT/ALU/res
add wave -divider  "I/O Ports:"
add wave UUT/in_port 
add wave UUT/out_port

######### Add stimuli data in HDL code => see HDL code
#force clk 0 0ns, 1 10ns -r 20ns
#force reset 1 0ns, 0 5ns
#force iport 3 0ns

########## Run the simulation
#run 500ns
run 1000ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
