LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_signed.ALL;
-- ========================================================
ENTITY trisc3a_tb IS END;
-- ========================================================
ARCHITECTURE fpga OF trisc3a_tb IS

-- ========= Unit under test definition: ==================
COMPONENT trisc3a IS 
 PORT(sys_clk      : IN  STD_LOGIC; -- System clock
      reset    : IN  STD_LOGIC; -- Active low asynchronous reset
      in_port  : IN  STD_LOGIC_VECTOR(7 DOWNTO 0); -- Input port
      out_port : OUT STD_LOGIC_VECTOR(7 DOWNTO 0) -- Output port
--    r0_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 0
--    r1_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 1
--    r2_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 2
--    r3_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 3
--    sp_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 13 aka stack pointer
--    lr_OUT   : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);  -- Register 14 aka return address
--    jc_OUT   : OUT STD_LOGIC;   -- Jump condition flag
--    me_ena   : OUT STD_LOGIC;   -- Memory enable
--    i_OUT    : OUT STD_LOGIC;   -- constant flag
--    pc_OUT   : OUT STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program counter
--    ir_imm12 : OUT STD_LOGIC_VECTOR(11 DOWNTO 0); -- Immediate value
--    imm32_out : OUT STD_LOGIC_VECTOR (31 DOWNTO 0);             -- Sign extend immediate value
--    op_code  : OUT STD_LOGIC_VECTOR(3 DOWNTO 0)    -- Operation code
       );
END COMPONENT;               
             
-- ==== Signal definition with intial values: =============
  SIGNAL sys_clk : STD_LOGIC := '0';
  SIGNAL reset : STD_LOGIC;
  SIGNAL pc_OUT : STD_LOGIC_VECTOR (11 DOWNTO 0);
  SIGNAL op_code : STD_LOGIC_VECTOR (3 DOWNTO 0);
  SIGNAL ir_imm12 : STD_LOGIC_VECTOR (11 DOWNTO 0); 
  SIGNAL imm32_out : STD_LOGIC_VECTOR (31 DOWNTO 0);  
  SIGNAL r0_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r1_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r2_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r3_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL sp_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL lr_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);   
  SIGNAL me_ena, jc_OUT, i_OUT, c_OUT : STD_LOGIC;    
-- I/O Ports:     
  SIGNAL in_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL out_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  
  CONSTANT T : TIME := 20 ns;

BEGIN
-- ========= Unit under test instantiation: ==================
    UUT : trisc3a
    PORT MAP (
        sys_clk => sys_clk,
        reset => reset,
        in_port  => in_port,
        out_port => out_port
--        r0_OUT => r0_OUT,
--        r1_OUT => r1_OUT,        
--        r2_OUT => r2_OUT,
--        r3_OUT => r3_OUT,
--        sp_OUT => sp_OUT,
--        lr_OUT => lr_OUT,        
--        jc_OUT => jc_OUT, 
--        me_ena => me_ena,       
--        pc_OUT => pc_OUT,
--        i_OUT => i_OUT,        
--        ir_imm12 => ir_imm12,
--        imm32_out => imm32_out, 
--        op_code => op_code
        );
    
-- =============== Periodic signals: ======================
  sys_clk <= NOT sys_clk AFTER T/2;

-- ================= Add stimuli: =========================
  PROCESS  
  BEGIN
    -- ====================
    reset <= '1';
    in_port <= CONV_STD_LOGIC_VECTOR(5, 8);
    -- ====================
    WAIT FOR 105ns; -- Time=105 ns
    reset <= transport '0';
    -- ====================
    WAIT; -- Time=805 us
    -- ====================
  END PROCESS;

END fpga;
