## add a local signal for behavior simulation only
proc add_local {var_name} { 
  if { [catch {add wave $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local variable $var_name in wave window for simulation!"
  }
}

## add a local signal with label for behavior simulation only
proc add_local_label {var_one var_two} { 
  if { [catch {add wave -label $var_one $var_two}] > 0 } {
    puts "** Uwe Info: Local Signal $var_two is NOT available!"
  } else {
    puts "** Uwe Info: Add local variable $var_two with label in wave window for simulation!"
  }
}


## add a local unsigned signal for behavior simulation only
proc add_local_uns {var_name} { 
  if { [catch {add wave -uns $var_name}] > 0 } {
    puts "** Uwe Info: Local Signal $var_name is NOT available!"
  } else {
    puts "** Uwe Info: Add local unsigned variable $var_name in wave window for simulation!"
  }
}

## add one of two local signals for behavior simulation only
proc add_one {var_one var_two} { 
  if { [catch {add wave $var_one}] > 0 } {
    puts "** Uwe Info: Local Signal $var_one is NOT available!"
    if { [catch {add wave $var_two}] > 0 } {
      puts "** Uwe Info: Local Signal $var_two is NOT available!"
  } else {    puts "** Uwe Info: Add local variable $var_two in wave window for simulation!"
  }
  } else {
    puts "** Uwe Info: Add local variable $var_one in wave window for simulation!"
  }
}

########## Compile design
puts "** Functional Simulation"
vlib work
vcom -93 rom4096x32.vhd
vcom -2008 trisc3mb.vhd
vcom -2008 trisc3mb_tb.vhd
vsim work.trisc3mb_tb(fpga)

########## Add I/O signals to wave window
#add wave -divider  "Simulation by UMB"
add_one clk sys_clk
add wave reset
radix -hex
add wave -divider  "Locals:" 
add_local {UUT/pc(24:31)}
add_local UUT/ir
add_local UUT/op
add_local UUT/go
add_local UUT/cmp
add_local UUT/branch_target
add_local UUT/jc 
add_local UUT/A
add_local UUT/B
add_local UUT/D
add_local UUT/{r(1)}
add_local UUT/{r(2)}
add_local UUT/{r(3)}
add_local UUT/{r(4)}
add_local UUT/{r(18)}
add_local_label {r19=sp}  UUT/{r(19)}
add_local UUT/ALU/res
add_local UUT/store
add_local UUT/load
add_local UUT/write
add_local UUT/read
add_local_uns {UUT/dma(18:29)}
add_local UUT/dram(1909) 
add_local UUT/dram(1910) 
add wave -divider  "I/O Ports:"
add wave UUT/in_port 
add wave UUT/out_port

######### Add stimuli data in HDL code => see HDL code
#force clk 0 0ns, 1 10ns -r 20ns
#force reset 1 0ns, 0 5ns
#force iport 3 0ns

########## Run the simulation
run 500ns
#run 1200ns
wave zoomfull
configure wave -gridperiod 40ns
configure wave -timelineunits ns
