LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_signed.ALL;
-- ========================================================
ENTITY trisc3mb_tb IS END;
-- ========================================================
ARCHITECTURE fpga OF trisc3mb_tb IS

-- ========= Unit under test definition: ==================
COMPONENT trisc3mb IS 
 PORT(sys_clk      : IN  STD_LOGIC; -- System clock
      reset    : IN  STD_LOGIC; -- Active low asynchronous reset
      in_port  : IN  STD_LOGIC_VECTOR(0 TO 7); -- Input port
      out_port : OUT STD_LOGIC_VECTOR(0 TO 7) -- Output port
    -- r1_OUT   : OUT STD_LOGIC_VECTOR (0 TO 31);  -- Register 1
    -- r2_OUT   : OUT STD_LOGIC_VECTOR (0 TO 31);  -- Register 2
    -- r3_OUT   : OUT STD_LOGIC_VECTOR (0 TO 31);  -- Register 3
    -- r19_OUT   : OUT STD_LOGIC_VECTOR (0 TO 31);  -- Register 13 aka stack pointer
    -- r15_OUT   : OUT STD_LOGIC_VECTOR (0 TO 31);  -- Register 14 aka return address
    -- jc_OUT   : OUT STD_LOGIC;   -- Jump condition flag
    -- me_ena   : OUT STD_LOGIC;   -- Memory enable
    -- i_OUT    : OUT STD_LOGIC;   -- constant flag
    -- pc_OUT   : OUT STD_LOGIC_VECTOR(0 TO 11); -- Program counter
    -- ir_imm16 : OUT STD_LOGIC_VECTOR(0 TO 15); -- Immediate value
    -- imm32_OUT : OUT STD_LOGIC_VECTOR (0 TO 31);             -- Sign extend immediate value
    -- op_code  : OUT STD_LOGIC_VECTOR(0 TO 5)    -- Operation code
       );
END COMPONENT;               
             
-- ==== Signal definition with intial values: =============
  SIGNAL sys_clk : STD_LOGIC := '0';
  SIGNAL reset : STD_LOGIC;
  SIGNAL pc_OUT : STD_LOGIC_VECTOR (0 TO 11);
  SIGNAL op_code : STD_LOGIC_VECTOR (0 TO 5);
  SIGNAL ir_imm16 : STD_LOGIC_VECTOR (0 TO 15); 
  SIGNAL imm32_out : STD_LOGIC_VECTOR (0 TO 31);  
  SIGNAL r1_OUT : STD_LOGIC_VECTOR (0 TO 31);
  SIGNAL r2_OUT : STD_LOGIC_VECTOR (0 TO 31);
  SIGNAL r3_OUT : STD_LOGIC_VECTOR (0 TO 31);
  SIGNAL r19_OUT : STD_LOGIC_VECTOR (0 TO 31);
  SIGNAL r15_OUT : STD_LOGIC_VECTOR (0 TO 31);   
  SIGNAL me_ena, jc_OUT, i_OUT, c_OUT : STD_LOGIC;    
-- I/O Ports:     
  SIGNAL in_port : STD_LOGIC_VECTOR (0 TO 7);
  SIGNAL out_port : STD_LOGIC_VECTOR (0 TO 7);
  
  CONSTANT T : TIME := 20 ns;

BEGIN
-- ========= Unit under test instantiation: ==================
    UUT : trisc3mb
    PORT MAP (
        sys_clk => sys_clk,
        reset => reset,
        in_port  => in_port,
        out_port => out_port
        -- r1_OUT => r1_OUT,        
        -- r2_OUT => r2_OUT,
        -- r3_OUT => r3_OUT,
        -- r19_OUT => r19_OUT,
        -- r15_OUT => r15_OUT,        
        -- jc_OUT => jc_OUT, 
        -- me_ena => me_ena,       
        -- pc_OUT => pc_OUT,
        -- i_OUT => i_OUT,        
        -- ir_imm16 => ir_imm16,
        -- imm32_OUT => imm32_OUT, 
        -- op_code => op_code
        );
    
-- =============== Periodic signals: ======================
  sys_clk <= NOT sys_clk AFTER T/2;

-- ================= Add stimuli: =========================
  PROCESS  
  BEGIN
    -- ====================
    reset <= '1';
    in_port <= CONV_STD_LOGIC_VECTOR(5, 8);
    -- ====================
    WAIT FOR 105ns; -- Time=105 ns
    reset <= transport '0';
    -- ====================
    WAIT; -- Time=805 us
    -- ====================
  END PROCESS;

END fpga;
