-- File generated with srec2prom.exe  DO NOT EDIT THIS FILE!
-- Copyright (C) 2019  Dr. Uwe Meyer-Baese.
-- =======================================================
LIBRARY ieee;
USE ieee.STD_LOGIC_1164.ALL;
USE ieee.STD_LOGIC_arith.ALL;
USE ieee.STD_LOGIC_unsigned.ALL;
-- =======================================================
ENTITY rom4096x32 IS
PORT (clk   : IN STD_LOGIC;      -- System clock
      reset : IN STD_LOGIC;      -- Asynchronous reset
      pma   : IN STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program memory address
      pmd   : OUT STD_LOGIC_VECTOR(31 DOWNTO 0)); -- Program memory data
END ENTITY rom4096x32;
-- =======================================================
ARCHITECTURE fpga OF rom4096x32 IS
-- Program ROM definition and values
TYPE MEMP IS ARRAY (0 TO 4095) OF STD_LOGIC_VECTOR(31 DOWNTO 0);
CONSTANT prom : MEMP := (
X"007F_C834", X"0880_1037", X"0880_0035", X"00C0_5F74", X"18DE_1004", 
X"0100_0044", X"1907_C83A", X"183F_FE1E", X"1080_FFDC", X"0000_0081",
OTHERS => X"00000001"); -- default jump to 0

BEGIN
-- The following process will be mapped to a BlockRAM for Zynq/Virtex/Spartan
-- devices (if addr > 4 bit!) and to Distributed RAM in all other cases

prog_rom: PROCESS (reset, clk)
BEGIN
  IF reset = '1' THEN               -- Asynchronous clear
    pmd <= (OTHERS => '0');     
  ELSIF rising_edge(clk) THEN
      pmd <= prom(CONV_INTEGER(pma)); -- Read from ROM
  END IF;
END PROCESS;

END ARCHITECTURE fpga;
