LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
USE ieee.std_logic_signed.ALL;
-- ========================================================
ENTITY trisc3n_tb IS END;
-- ========================================================
ARCHITECTURE fpga OF trisc3n_tb IS
  SUBTYPE SLVD IS STD_LOGIC_VECTOR(31 DOWNTO 0); -- Width data

-- ========= Unit under test definition: ==================
COMPONENT trisc3n IS 
 PORT(clk      : IN  STD_LOGIC; -- System clock
      reset    : IN  STD_LOGIC; -- Active low asynchronous reset
      in_port  : IN  STD_LOGIC_VECTOR(7 DOWNTO 0); -- Input port
      out_port : OUT STD_LOGIC_VECTOR(7 DOWNTO 0) -- Output port
      -- r1_OUT   : OUT SLVD;  -- Register 1
      -- r2_OUT   : OUT SLVD;  -- Register 2
      -- r3_OUT   : OUT SLVD;  -- Register 3
      -- r4_OUT   : OUT SLVD;  -- Register 4
      -- sp_OUT   : OUT SLVD;  -- Register 27 aka stack pointer
      -- ra_OUT   : OUT SLVD;  -- Register 31 aka return address
      -- jc_OUT   : OUT STD_LOGIC;   -- Jump condition flag
      -- me_ena   : OUT STD_LOGIC;   -- Memory enable
      -- k_OUT    : OUT STD_LOGIC;   -- constant flag
      -- pc_OUT   : OUT STD_LOGIC_VECTOR(11 DOWNTO 0); -- Program counter
      -- ir_imm16 : OUT STD_LOGIC_VECTOR(15 DOWNTO 0); -- Immediate value
      -- imm32_OUT : OUT SLVD;             -- Sign extend immediate value
      -- op_code  : OUT STD_LOGIC_VECTOR(5 DOWNTO 0)    -- Operation code
       );
END COMPONENT;               
             
-- ==== Signal definition with intial values: =============
  SIGNAL clk : STD_LOGIC := '0';
  SIGNAL reset : STD_LOGIC;
  SIGNAL pc_OUT : STD_LOGIC_VECTOR (11 DOWNTO 0);
  SIGNAL op_code : STD_LOGIC_VECTOR (5 DOWNTO 0);
  SIGNAL ir_imm16 : STD_LOGIC_VECTOR (15 DOWNTO 0); 
  SIGNAL imm32_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);  
  SIGNAL r4_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r1_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r2_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL r3_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL sp_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);
  SIGNAL ra_OUT : STD_LOGIC_VECTOR (31 DOWNTO 0);   
  SIGNAL me_ena, jc_OUT, k_OUT : STD_LOGIC;    
-- I/O Ports:     
  SIGNAL in_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  SIGNAL out_port : STD_LOGIC_VECTOR (7 DOWNTO 0);
  
  CONSTANT T : TIME := 20 ns;

BEGIN
-- ========= Unit under test instantiation: ==================
    UUT : trisc3n
    PORT MAP (
        clk => clk,
        reset => reset,
        in_port  => in_port,
        out_port => out_port
        -- r4_OUT => r4_OUT,
        -- r1_OUT => r1_OUT,        
        -- r2_OUT => r2_OUT,
        -- r3_OUT => r3_OUT,
        -- sp_OUT => sp_OUT,
        -- ra_OUT => ra_OUT,        
        -- jc_OUT => jc_OUT, 
        -- me_ena => me_ena,       
        -- pc_OUT => pc_OUT,
        -- k_OUT => k_OUT,        
        -- ir_imm16 => ir_imm16,
        -- imm32_OUT => imm32_OUT, 
        -- op_code => op_code
        );
    
-- =============== Periodic signals: ======================
  clk <= NOT clk AFTER T/2;

-- ================= Add stimuli: =========================
  PROCESS  
  BEGIN
    -- ====================
    reset <= '1';
    in_port <= CONV_STD_LOGIC_VECTOR(5, 8);
    -- ====================
    WAIT FOR 105ns; -- Time=105 ns
    reset <= transport '0';
    -- ====================
    WAIT; -- Time=805 us
    -- ====================
  END PROCESS;

END fpga;
